/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.EnvironmentKey;
import gnu.mapping.Namespace;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.PrintWriter;

public class Symbol
implements EnvironmentKey,
Comparable,
Externalizable {
    protected String name;
    Namespace namespace;
    public static final Object FUNCTION = new Symbol("(function)", null);
    public static final Symbol PLIST = new Symbol("(property-list)", null);

    public final Symbol getKeySymbol() {
        return this;
    }

    public final Object getKeyProperty() {
        return null;
    }

    public boolean matches(EnvironmentKey environmentKey) {
        return environmentKey.getKeySymbol() == this && environmentKey.getKeyProperty() == null;
    }

    public boolean matches(Symbol symbol, Object object2) {
        return symbol == this && object2 == null;
    }

    public final String getNamespaceURI() {
        Namespace namespace = this.getNamespace();
        return namespace == null ? null : namespace.getName();
    }

    public final boolean hasEmptyNamespace() {
        String string;
        Namespace namespace = this.getNamespace();
        return namespace == null || (string = namespace.getName()) == null || string.length() == 0;
    }

    public final String getLocalName() {
        return this.name;
    }

    public final String getName() {
        return this.name;
    }

    public static Symbol make(Object object2, String string) {
        Namespace namespace;
        Namespace namespace2 = namespace = object2 instanceof String ? Namespace.getInstance((String)object2) : (Namespace)object2;
        if (namespace == null || string == null) {
            return new Symbol(string, namespace);
        }
        return namespace.getSymbol(string.intern());
    }

    public Symbol() {
    }

    public Symbol(String string) {
        this.name = string;
    }

    public Symbol(String string, Namespace namespace) {
        this.name = string;
        this.namespace = namespace;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<symbol ");
        String string = this.getName();
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print('>');
    }

    public int compareTo(Object object2) {
        Symbol symbol = (Symbol)object2;
        if (this.getNamespaceURI() != symbol.getNamespaceURI()) {
            throw new IllegalArgumentException("comparing Symbols in different namespaces");
        }
        return this.getLocalName().compareTo(symbol.getLocalName());
    }

    public boolean equals(Object object2) {
        return this == object2;
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public final Namespace getNamespace() {
        return this.namespace;
    }

    public final void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public String toString() {
        String string = this.getNamespaceURI();
        if (string == null || string.length() == 0) {
            return this.getName();
        }
        return '{' + this.getNamespaceURI() + "}" + this.getName();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        String string;
        Namespace namespace = this.getNamespace();
        if (namespace != null && (string = namespace.getName()) != null && Namespace.getInstance(string) == namespace) {
            objectOutput.writeObject(string);
        } else {
            objectOutput.writeObject(namespace);
        }
        objectOutput.writeObject(this.getName());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object2 = objectInput.readObject();
        this.namespace = object2 instanceof String ? Namespace.getInstance((String)object2) : (Namespace)object2;
        this.name = (String)objectInput.readObject();
    }

    public Object readResolve() throws ObjectStreamException {
        if (this.namespace == null) {
            return this;
        }
        return Symbol.make(this.namespace, this.getName());
    }
}

