/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.models;

import gnu.kawa.models.Paintable;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class WithComposite
implements Paintable {
    Paintable[] paintable;
    Composite[] composite;

    public static WithComposite make(Paintable paintable, Composite composite) {
        WithComposite withComposite = new WithComposite();
        withComposite.paintable = new Paintable[]{paintable};
        withComposite.composite = new Composite[]{composite};
        return withComposite;
    }

    public static WithComposite make(Paintable[] paintableArray, Composite[] compositeArray) {
        WithComposite withComposite = new WithComposite();
        withComposite.paintable = paintableArray;
        withComposite.composite = compositeArray;
        return withComposite;
    }

    public static WithComposite make(Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        while (--n2 >= 0) {
            if (!(objectArray[n2] instanceof Paintable)) continue;
            ++n;
        }
        Paintable[] paintableArray = new Paintable[n];
        Composite[] compositeArray = new Composite[n];
        Composite composite = null;
        int n3 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if (object2 instanceof Paintable) {
                paintableArray[n3] = (Paintable)objectArray[i];
                compositeArray[n3] = composite;
                ++n3;
                continue;
            }
            composite = (Composite)object2;
        }
        return WithComposite.make(paintableArray, compositeArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D graphics2D) {
        Composite composite;
        Composite composite2 = composite = graphics2D.getComposite();
        try {
            int n = this.paintable.length;
            for (int i = 0; i < n; ++i) {
                Composite composite3 = this.composite[i];
                if (composite3 != null && composite3 != composite2) {
                    graphics2D.setComposite(composite3);
                    composite2 = composite3;
                }
                this.paintable[i].paint(graphics2D);
            }
        }
        finally {
            if (composite2 != composite) {
                graphics2D.setComposite(composite);
            }
        }
    }

    public Rectangle2D getBounds2D() {
        int n = this.paintable.length;
        if (n == 0) {
            return null;
        }
        Rectangle2D rectangle2D = this.paintable[0].getBounds2D();
        for (int i = 1; i < n; ++i) {
            rectangle2D = rectangle2D.createUnion(this.paintable[i].getBounds2D());
        }
        return rectangle2D;
    }

    public Paintable transform(AffineTransform affineTransform) {
        int n = this.paintable.length;
        Paintable[] paintableArray = new Paintable[n];
        for (int i = 0; i < n; ++i) {
            paintableArray[i] = this.paintable[i].transform(affineTransform);
        }
        return WithComposite.make(paintableArray, this.composite);
    }
}

