/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.management;

import org.apache.activemq.management.StatisticImpl;
import org.apache.activemq.management.UnsampledStatistic;

public class UnsampledStatisticImpl<T>
extends StatisticImpl
implements UnsampledStatistic<T> {
    private volatile T value;
    private final T defaultValue;

    public UnsampledStatisticImpl(String name, String unit, String description, T defaultValue) {
        super(name, unit, description, 0L, 0L);
        this.value = defaultValue;
        this.defaultValue = defaultValue;
    }

    @Override
    public void reset() {
        if (this.isDoReset()) {
            this.value = this.defaultValue;
        }
    }

    @Override
    protected void updateSampleTime() {
    }

    @Override
    public long getStartTime() {
        return 0L;
    }

    @Override
    public long getLastSampleTime() {
        return 0L;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        if (this.isEnabled()) {
            this.value = value;
        }
    }

    @Override
    protected void appendFieldDescription(StringBuffer buffer) {
        buffer.append(" value: ");
        buffer.append(this.value);
        super.appendFieldDescription(buffer);
    }
}

