/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.usage.SystemUsage;
import org.springframework.beans.CachedIntrospectionResults;

public class XBeanBrokerService
extends BrokerService {
    private boolean start = BrokerFactory.getStartDefault();

    @PostConstruct
    private void postConstruct() {
        try {
            this.afterPropertiesSet();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.ensureSystemUsageHasStore();
        if (this.shouldAutostart()) {
            this.start();
        }
    }

    protected boolean shouldAutostart() {
        return this.start;
    }

    private void ensureSystemUsageHasStore() throws IOException {
        SystemUsage usage = this.getSystemUsage();
        if (usage.getStoreUsage().getStore() == null) {
            usage.getStoreUsage().setStore(this.getPersistenceAdapter());
        }
        if (usage.getTempUsage().getStore() == null) {
            usage.getTempUsage().setStore(this.getTempDataStore());
        }
        if (usage.getJobSchedulerUsage().getStore() == null) {
            usage.getJobSchedulerUsage().setStore(this.getJobSchedulerStore());
        }
    }

    @PreDestroy
    private void preDestroy() {
        try {
            this.destroy();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public void stop() throws Exception {
        CachedIntrospectionResults.clearClassLoader((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        super.stop();
    }

    public void setStart(boolean start) {
        this.start = start;
    }
}

