/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.processor.BaseProcessorSupport;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.Tokenizer;
import org.apache.camel.support.AsyncProcessorConverterHelper;

public class TokenizerProcessor
extends BaseProcessorSupport
implements Navigate<Processor>,
CamelContextAware,
IdAware,
RouteIdAware {
    private final AsyncProcessor processor;
    private final Tokenizer tokenizer;
    private CamelContext camelContext;
    private String id;
    private String routeId;

    public TokenizerProcessor(Processor processor, Tokenizer tokenizer) {
        this.processor = AsyncProcessorConverterHelper.convert((Processor)processor);
        this.tokenizer = tokenizer;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        String[] tokenized = this.tokenizer.tokenize(exchange);
        exchange.getMessage().setBody((Object)tokenized);
        return this.processor.process(exchange, callback);
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add((Processor)this.processor);
        return answer;
    }

    public boolean hasNext() {
        return false;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }
}

