/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.BaseProcessorSupport;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.InterceptableProcessor;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TryProcessor
extends BaseProcessorSupport
implements Navigate<Processor>,
Traceable,
IdAware,
RouteIdAware,
InterceptableProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TryProcessor.class);
    protected final CamelContext camelContext;
    protected final ReactiveExecutor reactiveExecutor;
    protected String id;
    protected String routeId;
    protected final Processor tryProcessor;
    protected final List<Processor> catchClauses;
    protected final Processor finallyProcessor;

    public TryProcessor(CamelContext camelContext, Processor tryProcessor, List<Processor> catchClauses, Processor finallyProcessor) {
        this.camelContext = camelContext;
        this.reactiveExecutor = camelContext.getCamelContextExtension().getReactiveExecutor();
        this.tryProcessor = tryProcessor;
        this.catchClauses = catchClauses;
        this.finallyProcessor = finallyProcessor;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "doTry";
    }

    public boolean canIntercept() {
        return false;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        this.reactiveExecutor.schedule((Runnable)new TryState(exchange, callback));
        return false;
    }

    protected boolean continueRouting(Iterator<Processor> it, Exchange exchange) {
        if (exchange.isRouteStop()) {
            LOG.debug("Exchange is marked to stop routing: {}", (Object)exchange);
            return false;
        }
        return it.hasNext();
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object[])new Object[]{this.tryProcessor, this.catchClauses, this.finallyProcessor});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.tryProcessor, this.catchClauses, this.finallyProcessor});
    }

    public List<Processor> getCatchClauses() {
        return this.catchClauses;
    }

    public Processor getFinallyProcessor() {
        return this.finallyProcessor;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        if (this.tryProcessor != null) {
            answer.add(this.tryProcessor);
        }
        if (this.catchClauses != null && !this.catchClauses.isEmpty()) {
            answer.addAll(this.catchClauses);
        }
        if (this.finallyProcessor != null) {
            answer.add(this.finallyProcessor);
        }
        return answer;
    }

    public boolean hasNext() {
        return this.tryProcessor != null || this.catchClauses != null && !this.catchClauses.isEmpty() || this.finallyProcessor != null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    class TryState
    implements Runnable {
        final Exchange exchange;
        final AsyncCallback callback;
        final Iterator<Processor> processors;
        final Object lastHandled;

        public TryState(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
            this.processors = TryProcessor.this.next().iterator();
            this.lastHandled = exchange.getProperty(ExchangePropertyKey.EXCEPTION_HANDLED);
            exchange.removeProperty(ExchangePropertyKey.EXCEPTION_HANDLED);
        }

        @Override
        public void run() {
            if (TryProcessor.this.continueRouting(this.processors, this.exchange)) {
                this.exchange.setProperty(ExchangePropertyKey.TRY_ROUTE_BLOCK, (Object)true);
                ExchangeHelper.prepareOutToIn((Exchange)this.exchange);
                Processor processor = this.processors.next();
                AsyncProcessor async = AsyncProcessorConverterHelper.convert((Processor)processor);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing exchangeId: {} >>> {}", (Object)this.exchange.getExchangeId(), (Object)this.exchange);
                }
                async.process(this.exchange, doneSync -> TryProcessor.this.reactiveExecutor.schedule((Runnable)this));
            } else {
                ExchangeHelper.prepareOutToIn((Exchange)this.exchange);
                this.exchange.removeProperty(ExchangePropertyKey.TRY_ROUTE_BLOCK);
                this.exchange.setProperty(ExchangePropertyKey.EXCEPTION_HANDLED, this.lastHandled);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)this.exchange.getExchangeId(), (Object)this.exchange);
                }
                this.callback.done(false);
            }
        }

        public String toString() {
            return "TryState";
        }
    }
}

