/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * OpenAI endpoint for chat completion and embeddings.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface OpenAIEndpointBuilderFactory {

    /**
     * Builder for endpoint for the OpenAI component.
     */
    public interface OpenAIEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedOpenAIEndpointBuilder advanced() {
            return (AdvancedOpenAIEndpointBuilder) this;
        }

        /**
         * Additional JSON properties to include in the request body (e.g.
         * additionalBodyProperty.traceId=123). This is a multi-value option
         * with prefix: additionalBodyProperty.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * additionalBodyProperty(String, Object) method to add a value (call
         * the method multiple times to set more values).
         * 
         * Group: producer
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder additionalBodyProperty(String key, Object value) {
            doSetMultiValueProperty("additionalBodyProperty", "additionalBodyProperty." + key, value);
            return this;
        }
        /**
         * Additional JSON properties to include in the request body (e.g.
         * additionalBodyProperty.traceId=123). This is a multi-value option
         * with prefix: additionalBodyProperty.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * additionalBodyProperty(String, Object) method to add a value (call
         * the method multiple times to set more values).
         * 
         * Group: producer
         * 
         * @param values the values
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder additionalBodyProperty(Map values) {
            doSetMultiValueProperties("additionalBodyProperty", "additionalBodyProperty.", values);
            return this;
        }
        /**
         * OpenAI API key. Can also be set via OPENAI_API_KEY environment
         * variable.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder apiKey(String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
        /**
         * Base URL for OpenAI API. Defaults to OpenAI's official endpoint. Can
         * be used for local or third-party providers.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: https://api.openai.com/v1
         * Group: producer
         * 
         * @param baseUrl the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder baseUrl(String baseUrl) {
            doSetProperty("baseUrl", baseUrl);
            return this;
        }
        /**
         * Exchange property name for storing conversation history.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: CamelOpenAIConversationHistory
         * Group: producer
         * 
         * @param conversationHistoryProperty the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder conversationHistoryProperty(String conversationHistoryProperty) {
            doSetProperty("conversationHistoryProperty", conversationHistoryProperty);
            return this;
        }
        /**
         * Enable conversation memory per Exchange.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param conversationMemory the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder conversationMemory(boolean conversationMemory) {
            doSetProperty("conversationMemory", conversationMemory);
            return this;
        }
        /**
         * Enable conversation memory per Exchange.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param conversationMemory the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder conversationMemory(String conversationMemory) {
            doSetProperty("conversationMemory", conversationMemory);
            return this;
        }
        /**
         * Developer message to prepend before user messages.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param developerMessage the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder developerMessage(String developerMessage) {
            doSetProperty("developerMessage", developerMessage);
            return this;
        }
        /**
         * Number of dimensions for the embedding output. Only supported by
         * text-embedding-3 models. Reducing dimensions can lower costs and
         * improve performance without significant quality loss.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         * 
         * @param dimensions the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder dimensions(Integer dimensions) {
            doSetProperty("dimensions", dimensions);
            return this;
        }
        /**
         * Number of dimensions for the embedding output. Only supported by
         * text-embedding-3 models. Reducing dimensions can lower costs and
         * improve performance without significant quality loss.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         * 
         * @param dimensions the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder dimensions(String dimensions) {
            doSetProperty("dimensions", dimensions);
            return this;
        }
        /**
         * The model to use for embeddings.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param embeddingModel the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder embeddingModel(String embeddingModel) {
            doSetProperty("embeddingModel", embeddingModel);
            return this;
        }
        /**
         * The format for embedding output: 'float' for list of floats, 'base64'
         * for compressed format.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: float
         * Group: producer
         * 
         * @param encodingFormat the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder encodingFormat(String encodingFormat) {
            doSetProperty("encodingFormat", encodingFormat);
            return this;
        }
        /**
         * JSON schema for structured output validation.
         * 
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param jsonSchema the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder jsonSchema(String jsonSchema) {
            doSetProperty("jsonSchema", jsonSchema);
            return this;
        }
        /**
         * Maximum number of tokens to generate.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         * 
         * @param maxTokens the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder maxTokens(Integer maxTokens) {
            doSetProperty("maxTokens", maxTokens);
            return this;
        }
        /**
         * Maximum number of tokens to generate.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         * 
         * @param maxTokens the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder maxTokens(String maxTokens) {
            doSetProperty("maxTokens", maxTokens);
            return this;
        }
        /**
         * The model to use for chat completion.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param model the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder model(String model) {
            doSetProperty("model", model);
            return this;
        }
        /**
         * Fully qualified class name for structured output using response
         * format.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param outputClass the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder outputClass(String outputClass) {
            doSetProperty("outputClass", outputClass);
            return this;
        }
        /**
         * Store the full response in the exchange property
         * 'CamelOpenAIResponse' in non-streaming mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param storeFullResponse the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder storeFullResponse(boolean storeFullResponse) {
            doSetProperty("storeFullResponse", storeFullResponse);
            return this;
        }
        /**
         * Store the full response in the exchange property
         * 'CamelOpenAIResponse' in non-streaming mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param storeFullResponse the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder storeFullResponse(String storeFullResponse) {
            doSetProperty("storeFullResponse", storeFullResponse);
            return this;
        }
        /**
         * Enable streaming responses.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param streaming the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder streaming(boolean streaming) {
            doSetProperty("streaming", streaming);
            return this;
        }
        /**
         * Enable streaming responses.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param streaming the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder streaming(String streaming) {
            doSetProperty("streaming", streaming);
            return this;
        }
        /**
         * System message to prepend. When set and conversationMemory is
         * enabled, the conversation history is reset.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param systemMessage the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder systemMessage(String systemMessage) {
            doSetProperty("systemMessage", systemMessage);
            return this;
        }
        /**
         * Temperature for response generation (0.0 to 2.0).
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param temperature the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder temperature(Double temperature) {
            doSetProperty("temperature", temperature);
            return this;
        }
        /**
         * Temperature for response generation (0.0 to 2.0).
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param temperature the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder temperature(String temperature) {
            doSetProperty("temperature", temperature);
            return this;
        }
        /**
         * Top P for response generation (0.0 to 1.0).
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param topP the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder topP(Double topP) {
            doSetProperty("topP", topP);
            return this;
        }
        /**
         * Top P for response generation (0.0 to 1.0).
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: producer
         * 
         * @param topP the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder topP(String topP) {
            doSetProperty("topP", topP);
            return this;
        }
        /**
         * Default user message text to use when no prompt is provided.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param userMessage the value to set
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder userMessage(String userMessage) {
            doSetProperty("userMessage", userMessage);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the OpenAI component.
     */
    public interface AdvancedOpenAIEndpointBuilder
            extends
                EndpointProducerBuilder {
        default OpenAIEndpointBuilder basic() {
            return (OpenAIEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedOpenAIEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedOpenAIEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface OpenAIBuilders {
        /**
         * OpenAI (camel-openai)
         * OpenAI endpoint for chat completion and embeddings.
         * 
         * Category: ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-openai
         * 
         * @return the dsl builder for the headers' name.
         */
        default OpenAIHeaderNameBuilder openai() {
            return OpenAIHeaderNameBuilder.INSTANCE;
        }
        /**
         * OpenAI (camel-openai)
         * OpenAI endpoint for chat completion and embeddings.
         * 
         * Category: ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-openai
         * 
         * Syntax: <code>openai:operation</code>
         * 
         * Path parameter: operation (required)
         * The operation to perform: 'chat-completion' or 'embeddings'
         * 
         * @param path operation
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder openai(String path) {
            return OpenAIEndpointBuilderFactory.endpointBuilder("openai", path);
        }
        /**
         * OpenAI (camel-openai)
         * OpenAI endpoint for chat completion and embeddings.
         * 
         * Category: ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-openai
         * 
         * Syntax: <code>openai:operation</code>
         * 
         * Path parameter: operation (required)
         * The operation to perform: 'chat-completion' or 'embeddings'
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path operation
         * @return the dsl builder
         */
        default OpenAIEndpointBuilder openai(String componentName, String path) {
            return OpenAIEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the OpenAI component.
     */
    public static class OpenAIHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final OpenAIHeaderNameBuilder INSTANCE = new OpenAIHeaderNameBuilder();

        /**
         * The user message to send to the OpenAI chat completion API.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIUserMessage}.
         */
        public String openAIUserMessage() {
            return "CamelOpenAIUserMessage";
        }
        /**
         * The system message to provide context and instructions to the model.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAISystemMessage}.
         */
        public String openAISystemMessage() {
            return "CamelOpenAISystemMessage";
        }
        /**
         * The developer message to provide additional instructions to the
         * model.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIDeveloperMessage}.
         */
        public String openAIDeveloperMessage() {
            return "CamelOpenAIDeveloperMessage";
        }
        /**
         * The model to use for chat completion.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIModel}.
         */
        public String openAIModel() {
            return "CamelOpenAIModel";
        }
        /**
         * Controls randomness in the response. Higher values (e.g., 0.8) make
         * output more random, lower values (e.g., 0.2) make it more
         * deterministic.
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAITemperature}.
         */
        public String openAITemperature() {
            return "CamelOpenAITemperature";
        }
        /**
         * An alternative to temperature for controlling randomness. Uses
         * nucleus sampling where the model considers tokens with top_p
         * probability mass.
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAITopP}.
         */
        public String openAITopP() {
            return "CamelOpenAITopP";
        }
        /**
         * The maximum number of tokens to generate in the completion.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIMaxTokens}.
         */
        public String openAIMaxTokens() {
            return "CamelOpenAIMaxTokens";
        }
        /**
         * Whether to stream the response back incrementally.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIStreaming}.
         */
        public String openAIStreaming() {
            return "CamelOpenAIStreaming";
        }
        /**
         * The Java class to use for structured output parsing.
         * 
         * The option is a: {@code Class} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIOutputClass}.
         */
        public String openAIOutputClass() {
            return "CamelOpenAIOutputClass";
        }
        /**
         * The JSON schema to use for structured output validation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIJsonSchema}.
         */
        public String openAIJsonSchema() {
            return "CamelOpenAIJsonSchema";
        }
        /**
         * The model used for the completion response.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIResponseModel}.
         */
        public String openAIResponseModel() {
            return "CamelOpenAIResponseModel";
        }
        /**
         * The unique identifier for the completion response.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIResponseId}.
         */
        public String openAIResponseId() {
            return "CamelOpenAIResponseId";
        }
        /**
         * The reason the completion finished (e.g., stop, length,
         * content_filter).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIFinishReason}.
         */
        public String openAIFinishReason() {
            return "CamelOpenAIFinishReason";
        }
        /**
         * The number of tokens used in the prompt.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIPromptTokens}.
         */
        public String openAIPromptTokens() {
            return "CamelOpenAIPromptTokens";
        }
        /**
         * The number of tokens used in the completion.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAICompletionTokens}.
         */
        public String openAICompletionTokens() {
            return "CamelOpenAICompletionTokens";
        }
        /**
         * The total number of tokens used (prompt completion).
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAITotalTokens}.
         */
        public String openAITotalTokens() {
            return "CamelOpenAITotalTokens";
        }
        /**
         * The complete OpenAI response object.
         * 
         * The option is a: {@code com.openai.models.ChatCompletion} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIResponse}.
         */
        public String openAIResponse() {
            return "CamelOpenAIResponse";
        }
        /**
         * The model to use for embeddings.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIEmbeddingModel}.
         */
        public String openAIEmbeddingModel() {
            return "CamelOpenAIEmbeddingModel";
        }
        /**
         * Number of output dimensions.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIEmbeddingDimensions}.
         */
        public String openAIEmbeddingDimensions() {
            return "CamelOpenAIEmbeddingDimensions";
        }
        /**
         * The embedding model used in the response.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIEmbeddingResponseModel}.
         */
        public String openAIEmbeddingResponseModel() {
            return "CamelOpenAIEmbeddingResponseModel";
        }
        /**
         * Number of embeddings returned.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIEmbeddingCount}.
         */
        public String openAIEmbeddingCount() {
            return "CamelOpenAIEmbeddingCount";
        }
        /**
         * Vector dimensions of the embeddings.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIEmbeddingVectorSize}.
         */
        public String openAIEmbeddingVectorSize() {
            return "CamelOpenAIEmbeddingVectorSize";
        }
        /**
         * Reference embedding vector for similarity comparison.
         * 
         * The option is a: {@code List<Float>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIReferenceEmbedding}.
         */
        public String openAIReferenceEmbedding() {
            return "CamelOpenAIReferenceEmbedding";
        }
        /**
         * Calculated cosine similarity score (0.0 to 1.0).
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAISimilarityScore}.
         */
        public String openAISimilarityScore() {
            return "CamelOpenAISimilarityScore";
        }
        /**
         * Original text content when embeddings operation is used.
         * 
         * The option is a: {@code String or List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OpenAIOriginalText}.
         */
        public String openAIOriginalText() {
            return "CamelOpenAIOriginalText";
        }
    }
    static OpenAIEndpointBuilder endpointBuilder(String componentName, String path) {
        class OpenAIEndpointBuilderImpl extends AbstractEndpointBuilder implements OpenAIEndpointBuilder, AdvancedOpenAIEndpointBuilder {
            public OpenAIEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new OpenAIEndpointBuilderImpl(path);
    }
}