/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Perform SQL queries using Spring JDBC.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SqlEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the SQL component.
     */
    public interface SqlEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSqlEndpointConsumerBuilder advanced() {
            return (AdvancedSqlEndpointConsumerBuilder) this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param allowNamedParameters the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder allowNamedParameters(boolean allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param allowNamedParameters the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder allowNamedParameters(String allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database at
         * endpoint level.
         * 
         * The option is a: <code>javax.sql.DataSource</code> type.
         * 
         * Group: common
         * 
         * @param dataSource the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder dataSource(javax.sql.DataSource dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database at
         * endpoint level.
         * 
         * The option will be converted to a <code>javax.sql.DataSource</code>
         * type.
         * 
         * Group: common
         * 
         * @param dataSource the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder dataSource(String dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Specify the full package and class name to use as conversion when
         * outputType=SelectOne.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param outputClass the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder outputClass(String outputClass) {
            doSetProperty("outputClass", outputClass);
            return this;
        }
        /**
         * Store the query result in a header instead of the message body. By
         * default, outputHeader == null and the query result is stored in the
         * message body, any existing content in the message body is discarded.
         * If outputHeader is set, the value is used as the name of the header
         * to store the query result and the original message body is preserved.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param outputHeader the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder outputHeader(String outputHeader) {
            doSetProperty("outputHeader", outputHeader);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.SqlOutputType</code> type.
         * 
         * Default: SelectList
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder outputType(org.apache.camel.component.sql.SqlOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.SqlOutputType</code> type.
         * 
         * Default: SelectList
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option is a: <code>char</code> type.
         * 
         * Default: ,
         * Group: common
         * 
         * @param separator the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder separator(char separator) {
            doSetProperty("separator", separator);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option will be converted to a <code>char</code> type.
         * 
         * Default: ,
         * Group: common
         * 
         * @param separator the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder separator(String separator) {
            doSetProperty("separator", separator);
            return this;
        }
        /**
         * Sets whether to break batch if onConsume failed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param breakBatchOnConsumeFail the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder breakBatchOnConsumeFail(boolean breakBatchOnConsumeFail) {
            doSetProperty("breakBatchOnConsumeFail", breakBatchOnConsumeFail);
            return this;
        }
        /**
         * Sets whether to break batch if onConsume failed.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param breakBatchOnConsumeFail the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder breakBatchOnConsumeFail(String breakBatchOnConsumeFail) {
            doSetProperty("breakBatchOnConsumeFail", breakBatchOnConsumeFail);
            return this;
        }
        /**
         * Sets an expected update count to validate when using onConsume.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: -1
         * Group: consumer
         * 
         * @param expectedUpdateCount the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder expectedUpdateCount(int expectedUpdateCount) {
            doSetProperty("expectedUpdateCount", expectedUpdateCount);
            return this;
        }
        /**
         * Sets an expected update count to validate when using onConsume.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: -1
         * Group: consumer
         * 
         * @param expectedUpdateCount the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder expectedUpdateCount(String expectedUpdateCount) {
            doSetProperty("expectedUpdateCount", expectedUpdateCount);
            return this;
        }
        /**
         * Sets the maximum number of messages to poll.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder maxMessagesPerPoll(int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * Sets the maximum number of messages to poll.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder maxMessagesPerPoll(String maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * After processing each row then this query can be executed, if the
         * Exchange was processed successfully, for example to mark the row as
         * processed. The query can have parameter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param onConsume the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder onConsume(String onConsume) {
            doSetProperty("onConsume", onConsume);
            return this;
        }
        /**
         * After processing the entire batch, this query can be executed to bulk
         * update rows etc. The query cannot have parameters.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param onConsumeBatchComplete the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder onConsumeBatchComplete(String onConsumeBatchComplete) {
            doSetProperty("onConsumeBatchComplete", onConsumeBatchComplete);
            return this;
        }
        /**
         * After processing each row then this query can be executed, if the
         * Exchange failed, for example to mark the row as failed. The query can
         * have parameter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param onConsumeFailed the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder onConsumeFailed(String onConsumeFailed) {
            doSetProperty("onConsumeFailed", onConsumeFailed);
            return this;
        }
        /**
         * Sets whether empty resultset should be allowed to be sent to the next
         * hop. Defaults to false. So the empty resultset will be filtered out.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param routeEmptyResultSet the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder routeEmptyResultSet(boolean routeEmptyResultSet) {
            doSetProperty("routeEmptyResultSet", routeEmptyResultSet);
            return this;
        }
        /**
         * Sets whether empty resultset should be allowed to be sent to the next
         * hop. Defaults to false. So the empty resultset will be filtered out.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param routeEmptyResultSet the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder routeEmptyResultSet(String routeEmptyResultSet) {
            doSetProperty("routeEmptyResultSet", routeEmptyResultSet);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder sendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder sendEmptyMessageWhenIdle(String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Enables or disables transaction. If enabled then if processing an
         * exchange failed then the consumer breaks out processing any further
         * exchanges to cause a rollback eager.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder transacted(boolean transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Enables or disables transaction. If enabled then if processing an
         * exchange failed then the consumer breaks out processing any further
         * exchanges to cause a rollback eager.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder transacted(String transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Sets how resultset should be delivered to route. Indicates delivery
         * as either a list or individual object. defaults to true.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param useIterator the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder useIterator(boolean useIterator) {
            doSetProperty("useIterator", useIterator);
            return this;
        }
        /**
         * Sets how resultset should be delivered to route. Indicates delivery
         * as either a list or individual object. defaults to true.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param useIterator the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder useIterator(String useIterator) {
            doSetProperty("useIterator", useIterator);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder backoffErrorThreshold(int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder backoffErrorThreshold(String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder backoffIdleThreshold(int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder backoffIdleThreshold(String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder backoffMultiplier(int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder backoffMultiplier(String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder runLoggingLevel(org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder runLoggingLevel(String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder scheduledExecutorService(String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler. This is a multi-value
         * option with prefix: scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder schedulerProperties(String key, Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler. This is a multi-value
         * option with prefix: scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder startScheduler(boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default SqlEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the SQL component.
     */
    public interface AdvancedSqlEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SqlEndpointConsumerBuilder basic() {
            return (SqlEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder pollStrategy(org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder pollStrategy(String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlProcessingStrategy to execute
         * queries when the consumer has processed the rows/batch.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.SqlProcessingStrategy</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param processingStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder processingStrategy(org.apache.camel.component.sql.SqlProcessingStrategy processingStrategy) {
            doSetProperty("processingStrategy", processingStrategy);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlProcessingStrategy to execute
         * queries when the consumer has processed the rows/batch.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.SqlProcessingStrategy</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param processingStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder processingStrategy(String processingStrategy) {
            doSetProperty("processingStrategy", processingStrategy);
            return this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param alwaysPopulateStatement the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder alwaysPopulateStatement(boolean alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param alwaysPopulateStatement the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder alwaysPopulateStatement(String alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * Gives the JDBC driver a hint as to the number of rows that should be
         * fetched from the database when more rows are needed for ResultSet
         * objects generated by this Statement. If the value specified is zero,
         * then the hint is ignored. The default value is zero. This is
         * important for processing large result sets: Setting this higher than
         * the default value will increase processing speed at the cost of
         * memory consumption; setting this lower can avoid transferring row
         * data that will never be read by the application.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         * 
         * @param fetchSize the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder fetchSize(int fetchSize) {
            doSetProperty("fetchSize", fetchSize);
            return this;
        }
        /**
         * Gives the JDBC driver a hint as to the number of rows that should be
         * fetched from the database when more rows are needed for ResultSet
         * objects generated by this Statement. If the value specified is zero,
         * then the hint is ignored. The default value is zero. This is
         * important for processing large result sets: Setting this higher than
         * the default value will increase processing speed at the cost of
         * memory consumption; setting this lower can avoid transferring row
         * data that will never be read by the application.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         * 
         * @param fetchSize the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder fetchSize(String fetchSize) {
            doSetProperty("fetchSize", fetchSize);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         * 
         * @param parametersCount the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder parametersCount(int parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         * 
         * @param parametersCount the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder parametersCount(String parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * Specifies a character that will be replaced to in SQL query. Notice,
         * that it is simple String.replaceAll() operation and no SQL parsing is
         * involved (quoted strings will also change).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: #
         * Group: advanced
         * 
         * @param placeholder the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder placeholder(String placeholder) {
            doSetProperty("placeholder", placeholder);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.SqlPrepareStatementStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param prepareStatementStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder prepareStatementStrategy(org.apache.camel.component.sql.SqlPrepareStatementStrategy prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.SqlPrepareStatementStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param prepareStatementStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder prepareStatementStrategy(String prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Factory for creating RowMapper.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.RowMapperFactory</code> type.
         * 
         * Group: advanced
         * 
         * @param rowMapperFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder rowMapperFactory(org.apache.camel.component.sql.RowMapperFactory rowMapperFactory) {
            doSetProperty("rowMapperFactory", rowMapperFactory);
            return this;
        }
        /**
         * Factory for creating RowMapper.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.RowMapperFactory</code> type.
         * 
         * Group: advanced
         * 
         * @param rowMapperFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder rowMapperFactory(String rowMapperFactory) {
            doSetProperty("rowMapperFactory", rowMapperFactory);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * This is a multi-value option with prefix: template.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * templateOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder templateOptions(String key, Object value) {
            doSetMultiValueProperty("templateOptions", "template." + key, value);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * This is a multi-value option with prefix: template.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * templateOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder templateOptions(Map values) {
            doSetMultiValueProperties("templateOptions", "template.", values);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param usePlaceholder the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder usePlaceholder(boolean usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param usePlaceholder the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointConsumerBuilder usePlaceholder(String usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the SQL component.
     */
    public interface SqlEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSqlEndpointProducerBuilder advanced() {
            return (AdvancedSqlEndpointProducerBuilder) this;
        }

        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param allowNamedParameters the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder allowNamedParameters(boolean allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param allowNamedParameters the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder allowNamedParameters(String allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database at
         * endpoint level.
         * 
         * The option is a: <code>javax.sql.DataSource</code> type.
         * 
         * Group: common
         * 
         * @param dataSource the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder dataSource(javax.sql.DataSource dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database at
         * endpoint level.
         * 
         * The option will be converted to a <code>javax.sql.DataSource</code>
         * type.
         * 
         * Group: common
         * 
         * @param dataSource the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder dataSource(String dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Specify the full package and class name to use as conversion when
         * outputType=SelectOne.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param outputClass the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder outputClass(String outputClass) {
            doSetProperty("outputClass", outputClass);
            return this;
        }
        /**
         * Store the query result in a header instead of the message body. By
         * default, outputHeader == null and the query result is stored in the
         * message body, any existing content in the message body is discarded.
         * If outputHeader is set, the value is used as the name of the header
         * to store the query result and the original message body is preserved.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param outputHeader the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder outputHeader(String outputHeader) {
            doSetProperty("outputHeader", outputHeader);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.SqlOutputType</code> type.
         * 
         * Default: SelectList
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder outputType(org.apache.camel.component.sql.SqlOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.SqlOutputType</code> type.
         * 
         * Default: SelectList
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option is a: <code>char</code> type.
         * 
         * Default: ,
         * Group: common
         * 
         * @param separator the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder separator(char separator) {
            doSetProperty("separator", separator);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option will be converted to a <code>char</code> type.
         * 
         * Default: ,
         * Group: common
         * 
         * @param separator the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder separator(String separator) {
            doSetProperty("separator", separator);
            return this;
        }
        /**
         * Enables or disables batch mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param batch the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder batch(boolean batch) {
            doSetProperty("batch", batch);
            return this;
        }
        /**
         * Enables or disables batch mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param batch the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder batch(String batch) {
            doSetProperty("batch", batch);
            return this;
        }
        /**
         * Whether to optimize batch by turning off auto-commit which can
         * dramatic improve performance, and instead execute as a manual commit
         * after the entire batch operation is complete.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param batchAutoCommitDisabled the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder batchAutoCommitDisabled(boolean batchAutoCommitDisabled) {
            doSetProperty("batchAutoCommitDisabled", batchAutoCommitDisabled);
            return this;
        }
        /**
         * Whether to optimize batch by turning off auto-commit which can
         * dramatic improve performance, and instead execute as a manual commit
         * after the entire batch operation is complete.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param batchAutoCommitDisabled the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder batchAutoCommitDisabled(String batchAutoCommitDisabled) {
            doSetProperty("batchAutoCommitDisabled", batchAutoCommitDisabled);
            return this;
        }
        /**
         * If set, will ignore the results of the SQL query and use the existing
         * IN message as the OUT message for the continuation of processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param noop the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder noop(boolean noop) {
            doSetProperty("noop", noop);
            return this;
        }
        /**
         * If set, will ignore the results of the SQL query and use the existing
         * IN message as the OUT message for the continuation of processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param noop the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder noop(String noop) {
            doSetProperty("noop", noop);
            return this;
        }
        /**
         * Whether to use the message body as the SQL and then headers for
         * parameters. If this option is enabled then the SQL in the uri is not
         * used. Note that query parameters in the message body are represented
         * by a question mark instead of a # symbol.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useMessageBodyForSql the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder useMessageBodyForSql(boolean useMessageBodyForSql) {
            doSetProperty("useMessageBodyForSql", useMessageBodyForSql);
            return this;
        }
        /**
         * Whether to use the message body as the SQL and then headers for
         * parameters. If this option is enabled then the SQL in the uri is not
         * used. Note that query parameters in the message body are represented
         * by a question mark instead of a # symbol.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useMessageBodyForSql the value to set
         * @return the dsl builder
         */
        default SqlEndpointProducerBuilder useMessageBodyForSql(String useMessageBodyForSql) {
            doSetProperty("useMessageBodyForSql", useMessageBodyForSql);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the SQL component.
     */
    public interface AdvancedSqlEndpointProducerBuilder extends EndpointProducerBuilder {
        default SqlEndpointProducerBuilder basic() {
            return (SqlEndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param alwaysPopulateStatement the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder alwaysPopulateStatement(boolean alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param alwaysPopulateStatement the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder alwaysPopulateStatement(String alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * Gives the JDBC driver a hint as to the number of rows that should be
         * fetched from the database when more rows are needed for ResultSet
         * objects generated by this Statement. If the value specified is zero,
         * then the hint is ignored. The default value is zero. This is
         * important for processing large result sets: Setting this higher than
         * the default value will increase processing speed at the cost of
         * memory consumption; setting this lower can avoid transferring row
         * data that will never be read by the application.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         * 
         * @param fetchSize the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder fetchSize(int fetchSize) {
            doSetProperty("fetchSize", fetchSize);
            return this;
        }
        /**
         * Gives the JDBC driver a hint as to the number of rows that should be
         * fetched from the database when more rows are needed for ResultSet
         * objects generated by this Statement. If the value specified is zero,
         * then the hint is ignored. The default value is zero. This is
         * important for processing large result sets: Setting this higher than
         * the default value will increase processing speed at the cost of
         * memory consumption; setting this lower can avoid transferring row
         * data that will never be read by the application.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         * 
         * @param fetchSize the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder fetchSize(String fetchSize) {
            doSetProperty("fetchSize", fetchSize);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         * 
         * @param parametersCount the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder parametersCount(int parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         * 
         * @param parametersCount the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder parametersCount(String parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * Specifies a character that will be replaced to in SQL query. Notice,
         * that it is simple String.replaceAll() operation and no SQL parsing is
         * involved (quoted strings will also change).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: #
         * Group: advanced
         * 
         * @param placeholder the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder placeholder(String placeholder) {
            doSetProperty("placeholder", placeholder);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.SqlPrepareStatementStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param prepareStatementStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder prepareStatementStrategy(org.apache.camel.component.sql.SqlPrepareStatementStrategy prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.SqlPrepareStatementStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param prepareStatementStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder prepareStatementStrategy(String prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Factory for creating RowMapper.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.RowMapperFactory</code> type.
         * 
         * Group: advanced
         * 
         * @param rowMapperFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder rowMapperFactory(org.apache.camel.component.sql.RowMapperFactory rowMapperFactory) {
            doSetProperty("rowMapperFactory", rowMapperFactory);
            return this;
        }
        /**
         * Factory for creating RowMapper.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.RowMapperFactory</code> type.
         * 
         * Group: advanced
         * 
         * @param rowMapperFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder rowMapperFactory(String rowMapperFactory) {
            doSetProperty("rowMapperFactory", rowMapperFactory);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * This is a multi-value option with prefix: template.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * templateOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder templateOptions(String key, Object value) {
            doSetMultiValueProperty("templateOptions", "template." + key, value);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * This is a multi-value option with prefix: template.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * templateOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder templateOptions(Map values) {
            doSetMultiValueProperties("templateOptions", "template.", values);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param usePlaceholder the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder usePlaceholder(boolean usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param usePlaceholder the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointProducerBuilder usePlaceholder(String usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
    }

    /**
     * Builder for endpoint for the SQL component.
     */
    public interface SqlEndpointBuilder
            extends
                SqlEndpointConsumerBuilder,
                SqlEndpointProducerBuilder {
        default AdvancedSqlEndpointBuilder advanced() {
            return (AdvancedSqlEndpointBuilder) this;
        }

        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param allowNamedParameters the value to set
         * @return the dsl builder
         */
        default SqlEndpointBuilder allowNamedParameters(boolean allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param allowNamedParameters the value to set
         * @return the dsl builder
         */
        default SqlEndpointBuilder allowNamedParameters(String allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database at
         * endpoint level.
         * 
         * The option is a: <code>javax.sql.DataSource</code> type.
         * 
         * Group: common
         * 
         * @param dataSource the value to set
         * @return the dsl builder
         */
        default SqlEndpointBuilder dataSource(javax.sql.DataSource dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database at
         * endpoint level.
         * 
         * The option will be converted to a <code>javax.sql.DataSource</code>
         * type.
         * 
         * Group: common
         * 
         * @param dataSource the value to set
         * @return the dsl builder
         */
        default SqlEndpointBuilder dataSource(String dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Specify the full package and class name to use as conversion when
         * outputType=SelectOne.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param outputClass the value to set
         * @return the dsl builder
         */
        default SqlEndpointBuilder outputClass(String outputClass) {
            doSetProperty("outputClass", outputClass);
            return this;
        }
        /**
         * Store the query result in a header instead of the message body. By
         * default, outputHeader == null and the query result is stored in the
         * message body, any existing content in the message body is discarded.
         * If outputHeader is set, the value is used as the name of the header
         * to store the query result and the original message body is preserved.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param outputHeader the value to set
         * @return the dsl builder
         */
        default SqlEndpointBuilder outputHeader(String outputHeader) {
            doSetProperty("outputHeader", outputHeader);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.SqlOutputType</code> type.
         * 
         * Default: SelectList
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default SqlEndpointBuilder outputType(org.apache.camel.component.sql.SqlOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.SqlOutputType</code> type.
         * 
         * Default: SelectList
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default SqlEndpointBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option is a: <code>char</code> type.
         * 
         * Default: ,
         * Group: common
         * 
         * @param separator the value to set
         * @return the dsl builder
         */
        default SqlEndpointBuilder separator(char separator) {
            doSetProperty("separator", separator);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option will be converted to a <code>char</code> type.
         * 
         * Default: ,
         * Group: common
         * 
         * @param separator the value to set
         * @return the dsl builder
         */
        default SqlEndpointBuilder separator(String separator) {
            doSetProperty("separator", separator);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the SQL component.
     */
    public interface AdvancedSqlEndpointBuilder
            extends
                AdvancedSqlEndpointConsumerBuilder,
                AdvancedSqlEndpointProducerBuilder {
        default SqlEndpointBuilder basic() {
            return (SqlEndpointBuilder) this;
        }

        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param alwaysPopulateStatement the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointBuilder alwaysPopulateStatement(boolean alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param alwaysPopulateStatement the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointBuilder alwaysPopulateStatement(String alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * Gives the JDBC driver a hint as to the number of rows that should be
         * fetched from the database when more rows are needed for ResultSet
         * objects generated by this Statement. If the value specified is zero,
         * then the hint is ignored. The default value is zero. This is
         * important for processing large result sets: Setting this higher than
         * the default value will increase processing speed at the cost of
         * memory consumption; setting this lower can avoid transferring row
         * data that will never be read by the application.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         * 
         * @param fetchSize the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointBuilder fetchSize(int fetchSize) {
            doSetProperty("fetchSize", fetchSize);
            return this;
        }
        /**
         * Gives the JDBC driver a hint as to the number of rows that should be
         * fetched from the database when more rows are needed for ResultSet
         * objects generated by this Statement. If the value specified is zero,
         * then the hint is ignored. The default value is zero. This is
         * important for processing large result sets: Setting this higher than
         * the default value will increase processing speed at the cost of
         * memory consumption; setting this lower can avoid transferring row
         * data that will never be read by the application.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         * 
         * @param fetchSize the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointBuilder fetchSize(String fetchSize) {
            doSetProperty("fetchSize", fetchSize);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         * 
         * @param parametersCount the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointBuilder parametersCount(int parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         * 
         * @param parametersCount the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointBuilder parametersCount(String parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * Specifies a character that will be replaced to in SQL query. Notice,
         * that it is simple String.replaceAll() operation and no SQL parsing is
         * involved (quoted strings will also change).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: #
         * Group: advanced
         * 
         * @param placeholder the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointBuilder placeholder(String placeholder) {
            doSetProperty("placeholder", placeholder);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.SqlPrepareStatementStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param prepareStatementStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointBuilder prepareStatementStrategy(org.apache.camel.component.sql.SqlPrepareStatementStrategy prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.SqlPrepareStatementStrategy</code> type.
         * 
         * Group: advanced
         * 
         * @param prepareStatementStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointBuilder prepareStatementStrategy(String prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Factory for creating RowMapper.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sql.RowMapperFactory</code> type.
         * 
         * Group: advanced
         * 
         * @param rowMapperFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointBuilder rowMapperFactory(org.apache.camel.component.sql.RowMapperFactory rowMapperFactory) {
            doSetProperty("rowMapperFactory", rowMapperFactory);
            return this;
        }
        /**
         * Factory for creating RowMapper.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sql.RowMapperFactory</code> type.
         * 
         * Group: advanced
         * 
         * @param rowMapperFactory the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointBuilder rowMapperFactory(String rowMapperFactory) {
            doSetProperty("rowMapperFactory", rowMapperFactory);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * This is a multi-value option with prefix: template.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * templateOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedSqlEndpointBuilder templateOptions(String key, Object value) {
            doSetMultiValueProperty("templateOptions", "template." + key, value);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * This is a multi-value option with prefix: template.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * templateOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedSqlEndpointBuilder templateOptions(Map values) {
            doSetMultiValueProperties("templateOptions", "template.", values);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param usePlaceholder the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointBuilder usePlaceholder(boolean usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param usePlaceholder the value to set
         * @return the dsl builder
         */
        default AdvancedSqlEndpointBuilder usePlaceholder(String usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
    }

    public interface SqlBuilders {
        /**
         * SQL (camel-sql)
         * Perform SQL queries using Spring JDBC.
         * 
         * Category: database
         * Since: 1.4
         * Maven coordinates: org.apache.camel:camel-sql
         * 
         * @return the dsl builder for the headers' name.
         */
        default SqlHeaderNameBuilder sql() {
            return SqlHeaderNameBuilder.INSTANCE;
        }
        /**
         * SQL (camel-sql)
         * Perform SQL queries using Spring JDBC.
         * 
         * Category: database
         * Since: 1.4
         * Maven coordinates: org.apache.camel:camel-sql
         * 
         * Syntax: <code>sql:query</code>
         * 
         * Path parameter: query (required)
         * Sets the SQL query to perform. You can externalize the query by using
         * file: or classpath: as prefix and specify the location of the file.
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * @param path query
         * @return the dsl builder
         */
        default SqlEndpointBuilder sql(String path) {
            return SqlEndpointBuilderFactory.endpointBuilder("sql", path);
        }
        /**
         * SQL (camel-sql)
         * Perform SQL queries using Spring JDBC.
         * 
         * Category: database
         * Since: 1.4
         * Maven coordinates: org.apache.camel:camel-sql
         * 
         * Syntax: <code>sql:query</code>
         * 
         * Path parameter: query (required)
         * Sets the SQL query to perform. You can externalize the query by using
         * file: or classpath: as prefix and specify the location of the file.
         * This option can also be loaded from an existing file, by prefixing
         * with file: or classpath: followed by the location of the file.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path query
         * @return the dsl builder
         */
        default SqlEndpointBuilder sql(String componentName, String path) {
            return SqlEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the SQL component.
     */
    public static class SqlHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final SqlHeaderNameBuilder INSTANCE = new SqlHeaderNameBuilder();

        /**
         * Query to execute. This query takes precedence over the query
         * specified in the endpoint URI. Note that query parameters in the
         * header are represented by a instead of a pass:# symbol.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SqlQuery}.
         */
        public String sqlQuery() {
            return "CamelSqlQuery";
        }
        /**
         * The number of rows updated for update operations, returned as an
         * Integer object. This header is not provided when using
         * outputType=StreamList.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SqlUpdateCount}.
         */
        public String sqlUpdateCount() {
            return "CamelSqlUpdateCount";
        }
        /**
         * The number of rows returned for select operations, returned as an
         * Integer object. This header is not provided when using
         * outputType=StreamList.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SqlRowCount}.
         */
        public String sqlRowCount() {
            return "CamelSqlRowCount";
        }
        /**
         * Set its value to true to retrieve generated keys.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Default: false
         * Group: producer
         * 
         * @return the name of the header {@code SqlRetrieveGeneratedKeys}.
         */
        public String sqlRetrieveGeneratedKeys() {
            return "CamelSqlRetrieveGeneratedKeys";
        }
        /**
         * Set it to specify the expected generated columns.
         * 
         * The option is a: {@code String[] or int[]} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SqlGeneratedColumns}.
         */
        public String sqlGeneratedColumns() {
            return "CamelSqlGeneratedColumns";
        }
        /**
         * The number of rows in the header that contains generated keys.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SqlGeneratedKeysRowCount}.
         */
        public String sqlGeneratedKeysRowCount() {
            return "CamelSqlGeneratedKeysRowCount";
        }
        /**
         * Rows that contains the generated keys (a list of maps of keys).
         * 
         * The option is a: {@code List<Map<String, Object>>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SqlGeneratedKeyRows}.
         */
        public String sqlGeneratedKeyRows() {
            return "CamelSqlGeneratedKeyRows";
        }
        /**
         * The SQL parameters when using the option useMessageBodyForSql.
         * 
         * The option is a: {@code Iterator} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SqlParameters}.
         */
        public String sqlParameters() {
            return "CamelSqlParameters";
        }
        /**
         * To use a specific DataSource to operate on another database than the
         * pre configured DataSource on the component.
         * 
         * The option is a: {@code javax.sql.DataSource} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SqlDataSource}.
         */
        public String sqlDataSource() {
            return "CamelSqlDataSource";
        }
    }
    static SqlEndpointBuilder endpointBuilder(String componentName, String path) {
        class SqlEndpointBuilderImpl extends AbstractEndpointBuilder implements SqlEndpointBuilder, AdvancedSqlEndpointBuilder {
            public SqlEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SqlEndpointBuilderImpl(path);
    }
}