/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DirectoryWalkerTest {
    private static final File current = FileUtils.current();
    private static final File javaDir = new File("src/main/java");
    private static final File orgDir = new File(javaDir, "org");
    private static final File apacheDir = new File(orgDir, "apache");
    private static final File commonsDir = new File(apacheDir, "commons");
    private static final File ioDir = new File(commonsDir, "io");
    private static final File outputDir = new File(ioDir, "output");
    private static final File[] dirs = new File[]{orgDir, apacheDir, commonsDir, ioDir, outputDir};
    private static final File fileNameUtils = new File(ioDir, "FilenameUtils.java");
    private static final File ioUtils = new File(ioDir, "IOUtils.java");
    private static final File proxyWriter = new File(outputDir, "ProxyWriter.java");
    private static final File nullStream = new File(outputDir, "NullOutputStream.java");
    private static final File[] ioFiles = new File[]{fileNameUtils, ioUtils};
    private static final File[] outputFiles = new File[]{proxyWriter, nullStream};
    private static final IOFileFilter dirsFilter = DirectoryWalkerTest.createNameFilter(dirs);
    private static final IOFileFilter ioFilesFilter = DirectoryWalkerTest.createNameFilter(ioFiles);
    private static final IOFileFilter outputFilesFilter = DirectoryWalkerTest.createNameFilter(outputFiles);
    private static final IOFileFilter ioDirAndFilesFilter = dirsFilter.or(ioFilesFilter);
    private static final IOFileFilter dirsAndFilesFilter = ioDirAndFilesFilter.or(outputFilesFilter);
    private static final IOFileFilter NOT_SVN = FileFilterUtils.makeSVNAware(null);

    DirectoryWalkerTest() {
    }

    private static IOFileFilter createNameFilter(File[] files) {
        String[] names = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            names[i] = files[i].getName();
        }
        return new NameFileFilter(names);
    }

    private void checkContainsFiles(String prefix, File[] files, Collection<File> results) {
        for (int i = 0; i < files.length; ++i) {
            Assertions.assertTrue((boolean)results.contains(files[i]), (String)(prefix + "[" + i + "] " + files[i]));
        }
    }

    private void checkContainsString(String prefix, File[] files, Collection<String> results) {
        for (int i = 0; i < files.length; ++i) {
            Assertions.assertTrue((boolean)results.contains(files[i].toString()), (String)(prefix + "[" + i + "] " + files[i]));
        }
    }

    private List<File> directoriesOnly(Collection<File> results) {
        ArrayList<File> list = new ArrayList<File>(results.size());
        for (File file : results) {
            if (!file.isDirectory()) continue;
            list.add(file);
        }
        return list;
    }

    private List<File> filesOnly(Collection<File> results) {
        ArrayList<File> list = new ArrayList<File>(results.size());
        for (File file : results) {
            if (!file.isFile()) continue;
            list.add(file);
        }
        return list;
    }

    @Test
    void testCancel() {
        String cancelName = null;
        try {
            cancelName = "DirectoryWalker.java";
            new TestCancelWalker(cancelName, false).find(javaDir);
            Assertions.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            Assertions.assertEquals((Object)cancelName, (Object)cancel.getFile().getName(), (String)("File:  " + cancelName));
            Assertions.assertEquals((int)5, (int)cancel.getDepth(), (String)("Depth: " + cancelName));
        }
        catch (IOException ex) {
            Assertions.fail((String)("IOException: " + cancelName + " " + ex));
        }
        try {
            cancelName = "commons";
            new TestCancelWalker(cancelName, false).find(javaDir);
            Assertions.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            Assertions.assertEquals((Object)cancelName, (Object)cancel.getFile().getName(), (String)("File:  " + cancelName));
            Assertions.assertEquals((int)3, (int)cancel.getDepth(), (String)("Depth: " + cancelName));
        }
        catch (IOException ex) {
            Assertions.fail((String)("IOException: " + cancelName + " " + ex));
        }
        try {
            List<File> results = new TestCancelWalker(cancelName, true).find(javaDir);
            File lastFile = results.get(results.size() - 1);
            Assertions.assertEquals((Object)cancelName, (Object)lastFile.getName(), (String)("Suppress:  " + cancelName));
        }
        catch (IOException ex) {
            Assertions.fail((String)("Suppress threw " + ex));
        }
    }

    @Test
    void testFilter() {
        List<File> results = new TestFileFinder((FileFilter)dirsAndFilesFilter, -1).find(javaDir);
        Assertions.assertEquals((int)(1 + dirs.length + ioFiles.length + outputFiles.length), (int)results.size(), (String)"Result Size");
        Assertions.assertTrue((boolean)results.contains(javaDir), (String)"Start Dir");
        this.checkContainsFiles("Dir", dirs, results);
        this.checkContainsFiles("IO File", ioFiles, results);
        this.checkContainsFiles("Output File", outputFiles, results);
    }

    @Test
    void testFilterAndLimitA() {
        List<File> results = new TestFileFinder((FileFilter)NOT_SVN, 0).find(javaDir);
        Assertions.assertEquals((int)1, (int)results.size(), (String)"[A] Result Size");
        Assertions.assertTrue((boolean)results.contains(javaDir), (String)"[A] Start Dir");
    }

    @Test
    void testFilterAndLimitB() {
        List<File> results = new TestFileFinder((FileFilter)NOT_SVN, 1).find(javaDir);
        Assertions.assertEquals((int)2, (int)results.size(), (String)"[B] Result Size");
        Assertions.assertTrue((boolean)results.contains(javaDir), (String)"[B] Start Dir");
        Assertions.assertTrue((boolean)results.contains(orgDir), (String)"[B] Org Dir");
    }

    @Test
    void testFilterAndLimitC() {
        List<File> results = new TestFileFinder((FileFilter)NOT_SVN, 3).find(javaDir);
        Assertions.assertEquals((int)4, (int)results.size(), (String)"[C] Result Size");
        Assertions.assertTrue((boolean)results.contains(javaDir), (String)"[C] Start Dir");
        Assertions.assertTrue((boolean)results.contains(orgDir), (String)"[C] Org Dir");
        Assertions.assertTrue((boolean)results.contains(apacheDir), (String)"[C] Apache Dir");
        Assertions.assertTrue((boolean)results.contains(commonsDir), (String)"[C] Commons Dir");
    }

    @Test
    void testFilterAndLimitD() {
        List<File> results = new TestFileFinder((FileFilter)dirsAndFilesFilter, 5).find(javaDir);
        Assertions.assertEquals((int)(1 + dirs.length + ioFiles.length), (int)results.size(), (String)"[D] Result Size");
        Assertions.assertTrue((boolean)results.contains(javaDir), (String)"[D] Start Dir");
        this.checkContainsFiles("[D] Dir", dirs, results);
        this.checkContainsFiles("[D] File", ioFiles, results);
    }

    @Test
    void testFilterDirAndFile1() {
        List<File> results = new TestFileFinder(dirsFilter, ioFilesFilter, -1).find(javaDir);
        Assertions.assertEquals((int)(1 + dirs.length + ioFiles.length), (int)results.size(), (String)"[DirAndFile1] Result Size");
        Assertions.assertTrue((boolean)results.contains(javaDir), (String)"[DirAndFile1] Start Dir");
        this.checkContainsFiles("[DirAndFile1] Dir", dirs, results);
        this.checkContainsFiles("[DirAndFile1] File", ioFiles, results);
    }

    @Test
    void testFilterDirAndFile2() {
        List<File> results = new TestFileFinder(null, null, -1).find(javaDir);
        Assertions.assertTrue((results.size() > 1 + dirs.length + ioFiles.length ? 1 : 0) != 0, (String)"[DirAndFile2] Result Size");
        Assertions.assertTrue((boolean)results.contains(javaDir), (String)"[DirAndFile2] Start Dir");
        this.checkContainsFiles("[DirAndFile2] Dir", dirs, results);
        this.checkContainsFiles("[DirAndFile2] File", ioFiles, results);
    }

    @Test
    void testFilterDirAndFile3() {
        List<File> results = new TestFileFinder(dirsFilter, null, -1).find(javaDir);
        List<File> resultDirs = this.directoriesOnly(results);
        Assertions.assertEquals((int)(1 + dirs.length), (int)resultDirs.size(), (String)"[DirAndFile3] Result Size");
        Assertions.assertTrue((boolean)results.contains(javaDir), (String)"[DirAndFile3] Start Dir");
        this.checkContainsFiles("[DirAndFile3] Dir", dirs, resultDirs);
    }

    @Test
    void testFilterDirAndFile4() {
        List<File> results = new TestFileFinder(null, ioFilesFilter, -1).find(javaDir);
        List<File> resultFiles = this.filesOnly(results);
        Assertions.assertEquals((int)ioFiles.length, (int)resultFiles.size(), (String)"[DirAndFile4] Result Size");
        Assertions.assertTrue((boolean)results.contains(javaDir), (String)"[DirAndFile4] Start Dir");
        this.checkContainsFiles("[DirAndFile4] File", ioFiles, resultFiles);
    }

    @Test
    void testFilterString() {
        List<String> results = new TestFileFinderString((FileFilter)dirsAndFilesFilter, -1).find(javaDir);
        Assertions.assertEquals((int)results.size(), (int)(outputFiles.length + ioFiles.length), (String)"Result Size");
        this.checkContainsString("IO File", ioFiles, results);
        this.checkContainsString("Output File", outputFiles, results);
    }

    @Test
    void testHandleStartDirectoryFalse() {
        List<File> results = new TestFalseFileFinder(null, -1).find(current);
        Assertions.assertEquals((int)0, (int)results.size(), (String)"Result Size");
    }

    @Test
    void testLimitToCurrent() {
        List<File> results = new TestFileFinder(null, 0).find(current);
        Assertions.assertEquals((int)1, (int)results.size(), (String)"Result Size");
        Assertions.assertTrue((boolean)results.contains(FileUtils.current()), (String)"Current Dir");
    }

    @Test
    void testMissingStartDirectory() {
        File invalidDir = new File("invalid-dir");
        List<File> results = new TestFileFinder(null, -1).find(invalidDir);
        Assertions.assertEquals((int)1, (int)results.size(), (String)"Result Size");
        Assertions.assertTrue((boolean)results.contains(invalidDir), (String)"Current Dir");
        Assertions.assertThrows(NullPointerException.class, () -> new TestFileFinder(null, -1).find(null));
    }

    @Test
    void testMultiThreadCancel() {
        String cancelName = "DirectoryWalker.java";
        TestMultiThreadCancelWalker walker = new TestMultiThreadCancelWalker(cancelName, false);
        try {
            walker.find(javaDir);
            Assertions.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            File last = walker.results.get(walker.results.size() - 1);
            Assertions.assertEquals((Object)cancelName, (Object)last.getName());
            Assertions.assertEquals((int)5, (int)cancel.getDepth(), (String)("Depth: " + cancelName));
        }
        catch (IOException ex) {
            Assertions.fail((String)("IOException: " + cancelName + " " + ex));
        }
        try {
            cancelName = "commons";
            walker = new TestMultiThreadCancelWalker(cancelName, false);
            walker.find(javaDir);
            Assertions.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            Assertions.assertEquals((Object)cancelName, (Object)cancel.getFile().getName(), (String)("File:  " + cancelName));
            Assertions.assertEquals((int)3, (int)cancel.getDepth(), (String)("Depth: " + cancelName));
        }
        catch (IOException ex) {
            Assertions.fail((String)("IOException: " + cancelName + " " + ex));
        }
        try {
            walker = new TestMultiThreadCancelWalker(cancelName, true);
            List<File> results = walker.find(javaDir);
            File lastFile = results.get(results.size() - 1);
            Assertions.assertEquals((Object)cancelName, (Object)lastFile.getName(), (String)("Suppress:  " + cancelName));
        }
        catch (IOException ex) {
            Assertions.fail((String)("Suppress threw " + ex));
        }
    }

    static class TestCancelWalker
    extends DirectoryWalker<File> {
        private final String cancelFileName;
        private final boolean suppressCancel;

        TestCancelWalker(String cancelFileName, boolean suppressCancel) {
            this.cancelFileName = cancelFileName;
            this.suppressCancel = suppressCancel;
        }

        protected List<File> find(File startDirectory) throws IOException {
            ArrayList<File> results = new ArrayList<File>();
            this.walk(startDirectory, results);
            return results;
        }

        protected void handleCancelled(File startDirectory, Collection<File> results, DirectoryWalker.CancelException cancel) throws IOException {
            if (!this.suppressCancel) {
                super.handleCancelled(startDirectory, results, cancel);
            }
        }

        protected void handleDirectoryEnd(File directory, int depth, Collection<File> results) throws IOException {
            results.add(directory);
            if (this.cancelFileName.equals(directory.getName())) {
                throw new DirectoryWalker.CancelException(directory, depth);
            }
        }

        protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
            results.add(file);
            if (this.cancelFileName.equals(file.getName())) {
                throw new DirectoryWalker.CancelException(file, depth);
            }
        }
    }

    private static class TestFileFinder
    extends DirectoryWalker<File> {
        protected TestFileFinder(FileFilter filter, int depthLimit) {
            super(filter, depthLimit);
        }

        protected TestFileFinder(IOFileFilter dirFilter, IOFileFilter fileFilter, int depthLimit) {
            super(dirFilter, fileFilter, depthLimit);
        }

        protected List<File> find(File startDirectory) {
            ArrayList<File> results = new ArrayList<File>();
            try {
                this.walk(startDirectory, results);
            }
            catch (IOException ex) {
                Assertions.fail((String)ex.toString());
            }
            return results;
        }

        protected void handleDirectoryEnd(File directory, int depth, Collection<File> results) {
            results.add(directory);
        }

        protected void handleFile(File file, int depth, Collection<File> results) {
            results.add(file);
        }
    }

    private static final class TestFileFinderString
    extends DirectoryWalker<String> {
        protected TestFileFinderString(FileFilter filter, int depthLimit) {
            super(filter, depthLimit);
        }

        protected List<String> find(File startDirectory) {
            ArrayList<String> results = new ArrayList<String>();
            try {
                this.walk(startDirectory, results);
            }
            catch (IOException ex) {
                Assertions.fail((String)ex.toString());
            }
            return results;
        }

        protected void handleFile(File file, int depth, Collection<String> results) {
            results.add(file.toString());
        }
    }

    private static final class TestFalseFileFinder
    extends TestFileFinder {
        protected TestFalseFileFinder(FileFilter filter, int depthLimit) {
            super(filter, depthLimit);
        }

        protected boolean handleDirectory(File directory, int depth, Collection<File> results) {
            return false;
        }
    }

    static class TestMultiThreadCancelWalker
    extends DirectoryWalker<File> {
        private final String cancelFileName;
        private final boolean suppressCancel;
        private boolean cancelled;
        public List<File> results;

        TestMultiThreadCancelWalker(String cancelFileName, boolean suppressCancel) {
            this.cancelFileName = cancelFileName;
            this.suppressCancel = suppressCancel;
        }

        protected List<File> find(File startDirectory) throws IOException {
            this.results = new ArrayList<File>();
            this.walk(startDirectory, this.results);
            return this.results;
        }

        protected void handleCancelled(File startDirectory, Collection<File> results, DirectoryWalker.CancelException cancel) throws IOException {
            if (!this.suppressCancel) {
                super.handleCancelled(startDirectory, results, cancel);
            }
        }

        protected void handleDirectoryEnd(File directory, int depth, Collection<File> results) throws IOException {
            results.add(directory);
            Assertions.assertFalse((boolean)this.cancelled);
            if (this.cancelFileName.equals(directory.getName())) {
                this.cancelled = true;
            }
        }

        protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
            results.add(file);
            Assertions.assertFalse((boolean)this.cancelled);
            if (this.cancelFileName.equals(file.getName())) {
                this.cancelled = true;
            }
        }

        protected boolean handleIsCancelled(File file, int depth, Collection<File> results) throws IOException {
            return this.cancelled;
        }
    }
}

