/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import java.util.Objects;

public final class MultipartConfig {
    public static final MultipartConfig DEFAULT_CONFIG = new MultipartConfig(null, null, -1L, -1L, -1L);
    public static final MultipartConfig INVALID_CONFIG = new MultipartConfig(null, null, -1L, -1L, -1L);
    public final int multipartThreshold;
    public final String multipartLocation;
    public final long multipartMaxFileSize;
    public final long multipartMaxRequestSize;
    public final long multipartMaxFileCount;

    public MultipartConfig(Integer threshold, String location, long maxFileSize, long maxRequestSize, long maxFileCount) {
        this.multipartThreshold = threshold != null && threshold > 0 ? threshold : 10240;
        this.multipartLocation = location;
        this.multipartMaxFileSize = maxFileSize > 0L || maxFileSize == -1L ? maxFileSize : -1L;
        this.multipartMaxRequestSize = maxRequestSize > 0L || maxRequestSize == -1L ? maxRequestSize : -1L;
        this.multipartMaxFileCount = maxFileCount > 0L ? maxFileCount : 50L;
    }

    public int hashCode() {
        return Objects.hash(this.multipartThreshold, this.multipartLocation, this.multipartMaxFileSize, this.multipartMaxRequestSize, this.multipartMaxFileCount);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultipartConfig other = (MultipartConfig)obj;
        return this.multipartThreshold == other.multipartThreshold && Objects.equals(this.multipartLocation, other.multipartLocation) && this.multipartMaxFileSize == other.multipartMaxFileSize && this.multipartMaxRequestSize == other.multipartMaxRequestSize && this.multipartMaxFileCount == other.multipartMaxFileCount;
    }
}

