/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.routing;

import org.apache.hc.core5.http.impl.routing.PathPatternMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestPathPatternMatcher {
    TestPathPatternMatcher() {
    }

    @Test
    void testPathMatching() {
        PathPatternMatcher matcher = PathPatternMatcher.INSTANCE;
        Assertions.assertTrue((boolean)matcher.match("/*", "/foo/request"));
        Assertions.assertTrue((boolean)matcher.match("/foo/*", "/foo/request"));
        Assertions.assertTrue((boolean)matcher.match("/foo/req*", "/foo/request"));
        Assertions.assertTrue((boolean)matcher.match("/foo/request", "/foo/request"));
        Assertions.assertFalse((boolean)matcher.match("/foo/request", "/foo/requesta"));
        Assertions.assertFalse((boolean)matcher.match("/foo/*", "foo/request"));
        Assertions.assertFalse((boolean)matcher.match("/foo/*", "/bar/foo"));
        Assertions.assertTrue((boolean)matcher.match("*/action.do", "/xxxxx/action.do"));
        Assertions.assertTrue((boolean)matcher.match("*/foo/action.do", "/xxxxx/foo/action.do"));
        Assertions.assertFalse((boolean)matcher.match("*.do", "foo.dont"));
    }

    @Test
    void testBetterMatch() {
        PathPatternMatcher matcher = PathPatternMatcher.INSTANCE;
        Assertions.assertTrue((boolean)matcher.isBetter("/a*", "/*"));
        Assertions.assertTrue((boolean)matcher.isBetter("/a*", "*"));
        Assertions.assertTrue((boolean)matcher.isBetter("/*", "*"));
        Assertions.assertTrue((boolean)matcher.isBetter("/a/b*", "/a*"));
        Assertions.assertTrue((boolean)matcher.isBetter("/a/*", "/a/b"));
    }
}

