/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import java.util.List;
import org.apache.ignite3.configuration.ConfigurationDynamicDefaultsPatcher;
import org.apache.ignite3.configuration.ConfigurationModule;
import org.apache.ignite3.configuration.KeyIgnorer;
import org.apache.ignite3.configuration.validation.ConfigurationValidationException;
import org.apache.ignite3.internal.configuration.ConfigurationTreeGenerator;
import org.apache.ignite3.internal.configuration.SuperRoot;
import org.apache.ignite3.internal.configuration.SuperRootChangeImpl;
import org.apache.ignite3.internal.configuration.hocon.HoconConverter;
import org.apache.ignite3.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite3.internal.configuration.tree.ConverterToMapVisitor;

public class ConfigurationDynamicDefaultsPatcherImpl
implements ConfigurationDynamicDefaultsPatcher {
    private final ConfigurationModule configurationModule;
    private final ConfigurationTreeGenerator generator;

    public ConfigurationDynamicDefaultsPatcherImpl(ConfigurationModule configurationModule, ConfigurationTreeGenerator generator) {
        this.configurationModule = configurationModule;
        this.generator = generator;
    }

    @Override
    public String patchWithDynamicDefaults(String hocon) {
        SuperRoot superRoot = this.convertToSuperRoot(hocon);
        SuperRootChangeImpl rootChange = new SuperRootChangeImpl(superRoot);
        this.configurationModule.patchConfigurationWithDynamicDefaults(rootChange);
        ConverterToMapVisitor visitor = ConverterToMapVisitor.builder().includeInternal(true).includeDeprecated(true).maskSecretValues(false).skipEmptyValues(true).build();
        ConfigRenderOptions renderOptions = ConfigRenderOptions.concise().setJson(false);
        return HoconConverter.represent(superRoot, List.of(), visitor).render(renderOptions);
    }

    private SuperRoot convertToSuperRoot(String hocon) {
        try {
            Config config = ConfigFactory.parseString((String)hocon);
            KeyIgnorer keyIgnorer = KeyIgnorer.fromDeletedPrefixes(this.configurationModule.deletedPrefixes());
            ConfigurationSource hoconSource = HoconConverter.hoconSource(config.root(), keyIgnorer);
            SuperRoot superRoot = this.generator.createSuperRoot();
            hoconSource.descend(superRoot);
            return superRoot;
        }
        catch (Exception e) {
            throw new ConfigurationValidationException("Failed to parse HOCON: " + e.getMessage());
        }
    }
}

