/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeOutOfMemoryCriticalException;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.resource.ref.PipePhantomReferenceManager;
import org.apache.iotdb.db.pipe.event.ReferenceTrackableEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.TsFileInsertionPointCounter;
import org.apache.iotdb.db.pipe.event.common.tsfile.container.TsFileInsertionDataContainer;
import org.apache.iotdb.db.pipe.event.common.tsfile.container.TsFileInsertionDataContainerProvider;
import org.apache.iotdb.db.pipe.metric.overview.PipeDataNodeSinglePipeMetrics;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryManager;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResourceManager;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.assigner.PipeTsFileEpochProgressIndexKeeper;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTsFileInsertionEvent
extends EnrichedEvent
implements TsFileInsertionEvent,
ReferenceTrackableEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFileInsertionEvent.class);
    protected final TsFileResource resource;
    protected File tsFile;
    protected long extractTime = 0L;
    protected boolean isWithMod;
    protected File modFile;
    protected final boolean isLoaded;
    protected final boolean isGeneratedByPipe;
    protected final boolean isGeneratedByPipeConsensus;
    protected final boolean isGeneratedByHistoricalExtractor;
    protected final AtomicBoolean isClosed;
    protected final AtomicReference<TsFileInsertionDataContainer> dataContainer;
    protected long flushPointCount = -1L;
    protected volatile ProgressIndex overridingProgressIndex;
    private Set<String> tableNames;

    public PipeTsFileInsertionEvent(TsFileResource resource, boolean isLoaded) {
        this(resource, null, true, isLoaded, false, null, 0L, null, null, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public PipeTsFileInsertionEvent(TsFileResource resource, File tsFile, boolean isWithMod, boolean isLoaded, boolean isGeneratedByHistoricalExtractor, String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
        super(pipeName, creationTime, pipeTaskMeta, pattern, startTime, endTime);
        TsFileProcessor processor;
        this.resource = resource;
        this.tsFile = Objects.isNull(tsFile) ? resource.getTsFile() : tsFile;
        ModificationFile modFile = resource.getModFile();
        this.isWithMod = isWithMod && modFile.exists();
        this.modFile = this.isWithMod ? new File(modFile.getFilePath()) : null;
        this.isLoaded = isLoaded;
        this.isGeneratedByPipe = resource.isGeneratedByPipe();
        this.isGeneratedByPipeConsensus = resource.isGeneratedByPipeConsensus();
        this.isGeneratedByHistoricalExtractor = isGeneratedByHistoricalExtractor;
        this.tableNames = this.tableNames;
        this.dataContainer = new AtomicReference<Object>(null);
        this.isClosed = new AtomicBoolean(resource.isClosed());
        if (!this.isClosed.get() && (processor = resource.getProcessor()) != null) {
            processor.addCloseFileListener(o -> {
                AtomicBoolean atomicBoolean = this.isClosed;
                synchronized (atomicBoolean) {
                    this.isClosed.set(true);
                    this.isClosed.notifyAll();
                    this.flushPointCount = processor.getMemTableFlushPointCount();
                }
            });
        }
        this.isClosed.set(resource.isClosed());
        this.addOnCommittedHook(() -> {
            if (this.shouldReportOnCommit) {
                this.eliminateProgressIndex();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForTsFileClose() throws InterruptedException {
        if (Objects.isNull(this.resource)) {
            return true;
        }
        if (!this.isClosed.get()) {
            this.isClosed.set(this.resource.isClosed());
            AtomicBoolean atomicBoolean = this.isClosed;
            synchronized (atomicBoolean) {
                while (!this.isClosed.get()) {
                    this.isClosed.wait(100L);
                    boolean isClosedNow = this.resource.isClosed();
                    if (!isClosedNow) continue;
                    this.isClosed.set(true);
                    this.isClosed.notifyAll();
                    TsFileProcessor processor = this.resource.getProcessor();
                    if (processor == null) break;
                    this.flushPointCount = processor.getMemTableFlushPointCount();
                    break;
                }
            }
        }
        return !this.resource.isEmpty();
    }

    public File getTsFile() {
        return this.tsFile;
    }

    public File getModFile() {
        return this.modFile;
    }

    public boolean isWithMod() {
        return this.isWithMod;
    }

    public void disableMod4NonTransferPipes(boolean isWithMod) {
        this.isWithMod = isWithMod && this.isWithMod;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public long getFlushPointCount() {
        return this.flushPointCount;
    }

    public long getTimePartitionId() {
        return this.resource.getTimePartition();
    }

    public long getExtractTime() {
        return this.extractTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        this.extractTime = System.nanoTime();
        try {
            this.tsFile = PipeDataNodeResourceManager.tsfile().increaseFileReference(this.tsFile, true, this.pipeName);
            if (this.isWithMod) {
                this.modFile = PipeDataNodeResourceManager.tsfile().increaseFileReference(this.modFile, false, this.pipeName);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Increase reference count for TsFile %s or modFile %s error. Holder Message: %s", this.tsFile, this.modFile, holderMessage), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (Objects.nonNull(this.pipeName)) {
                PipeDataNodeSinglePipeMetrics.getInstance().increaseTsFileEventCount(this.pipeName, this.creationTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        boolean bl;
        try {
            PipeDataNodeResourceManager.tsfile().decreaseFileReference(this.tsFile, this.pipeName);
            if (this.isWithMod) {
                PipeDataNodeResourceManager.tsfile().decreaseFileReference(this.modFile, this.pipeName);
            }
            this.close();
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                LOGGER.warn(String.format("Decrease reference count for TsFile %s error. Holder Message: %s", this.tsFile.getPath(), holderMessage), (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                if (Objects.nonNull(this.pipeName)) {
                    PipeDataNodeSinglePipeMetrics.getInstance().decreaseTsFileEventCount(this.pipeName, this.creationTime, this.shouldReportOnCommit ? System.nanoTime() - this.extractTime : -1L);
                }
                throw throwable;
            }
            if (Objects.nonNull(this.pipeName)) {
                PipeDataNodeSinglePipeMetrics.getInstance().decreaseTsFileEventCount(this.pipeName, this.creationTime, this.shouldReportOnCommit ? System.nanoTime() - this.extractTime : -1L);
            }
            return bl2;
        }
        if (Objects.nonNull(this.pipeName)) {
            PipeDataNodeSinglePipeMetrics.getInstance().decreaseTsFileEventCount(this.pipeName, this.creationTime, this.shouldReportOnCommit ? System.nanoTime() - this.extractTime : -1L);
        }
        return bl;
    }

    public void bindProgressIndex(ProgressIndex overridingProgressIndex) {
        this.overridingProgressIndex = overridingProgressIndex;
    }

    public ProgressIndex getProgressIndex() {
        return this.resource.getMaxProgressIndex();
    }

    public ProgressIndex forceGetProgressIndex() {
        if (this.resource.isEmpty()) {
            LOGGER.warn("Skipping temporary TsFile {}'s progressIndex, will report MinimumProgressIndex", (Object)this.tsFile);
            return MinimumProgressIndex.INSTANCE;
        }
        if (Objects.nonNull(this.overridingProgressIndex)) {
            return this.overridingProgressIndex;
        }
        return this.resource.getMaxProgressIndex();
    }

    public void eliminateProgressIndex() {
        if (Objects.isNull(this.overridingProgressIndex) && Objects.nonNull(this.resource)) {
            PipeTsFileEpochProgressIndexKeeper.getInstance().eliminateProgressIndex(this.resource.getDataRegionId(), this.pipeName, this.resource.getTsFilePath());
        }
    }

    public PipeTsFileInsertionEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
        return new PipeTsFileInsertionEvent(this.resource, this.tsFile, this.isWithMod, this.isLoaded, this.isGeneratedByHistoricalExtractor, pipeName, creationTime, pipeTaskMeta, pattern, startTime, endTime);
    }

    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    public boolean mayEventTimeOverlappedWithTimeRange() {
        return Objects.isNull(this.resource) || this.startTime <= this.resource.getFileEndTime() && this.resource.getFileStartTime() <= this.endTime;
    }

    public boolean mayEventPathsOverlappedWithPattern() {
        if (Objects.isNull(this.resource) || !this.resource.isClosed()) {
            return true;
        }
        try {
            Map<IDeviceID, Boolean> deviceIsAlignedMap = PipeDataNodeResourceManager.tsfile().getDeviceIsAlignedMapFromCache(PipeTsFileResourceManager.getHardlinkOrCopiedFileInPipeDir(this.resource.getTsFile(), this.pipeName), false);
            Set<IDeviceID> deviceSet = Objects.nonNull(deviceIsAlignedMap) ? deviceIsAlignedMap.keySet() : this.resource.getDevices();
            return deviceSet.stream().anyMatch(deviceID -> this.pipePattern.mayOverlapWithDevice(((PlainDeviceID)deviceID).toStringID()));
        }
        catch (Exception e) {
            LOGGER.info("Pipe {}: failed to get devices from TsFile {}, extract it anyway", new Object[]{this.pipeName, this.resource.getTsFilePath(), e});
            return true;
        }
    }

    public void consumeTabletInsertionEventsWithRetry(TabletInsertionEventConsumer consumer, String callerName) throws PipeException {
        Iterable<TabletInsertionEvent> iterable = this.toTabletInsertionEvents();
        Iterator<TabletInsertionEvent> iterator = iterable.iterator();
        int tabletEventCount = 0;
        block2: while (iterator.hasNext()) {
            TabletInsertionEvent parsedEvent = iterator.next();
            ++tabletEventCount;
            int retryCount = 0;
            while (true) {
                try {
                    consumer.consume((PipeRawTabletInsertionEvent)parsedEvent);
                    continue block2;
                }
                catch (PipeRuntimeOutOfMemoryCriticalException e) {
                    if (retryCount++ % 100 == 0) {
                        LOGGER.warn("{}: failed to allocate memory for parsing TsFile {}, tablet event no. {}, retry count is {}, will keep retrying.", new Object[]{callerName, this.getTsFile(), tabletEventCount, retryCount, e});
                        continue;
                    }
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("{}: failed to allocate memory for parsing TsFile {}, tablet event no. {}, retry count is {}, will keep retrying.", new Object[]{callerName, this.getTsFile(), tabletEventCount, retryCount, e});
                    continue;
                }
                break;
            }
        }
    }

    public Iterable<TabletInsertionEvent> toTabletInsertionEvents() throws PipeException {
        return this.toTabletInsertionEvents((long)((1.0 + Math.random()) * 20.0 * 1000.0));
    }

    public Iterable<TabletInsertionEvent> toTabletInsertionEvents(long timeoutMs) throws PipeException {
        try {
            if (!this.waitForTsFileClose()) {
                LOGGER.warn("Pipe skipping temporary TsFile's parsing which shouldn't be transferred: {}", (Object)this.tsFile);
                return Collections.emptyList();
            }
            this.waitForResourceEnough4Parsing(timeoutMs);
            return this.initDataContainer().toTabletInsertionEvents();
        }
        catch (Exception e) {
            this.close();
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            String errorMsg = e instanceof InterruptedException ? String.format("Interrupted when waiting for closing TsFile %s.", this.resource.getTsFilePath()) : String.format("Parse TsFile %s error. Because: %s", this.resource.getTsFilePath(), e.getMessage());
            LOGGER.warn(errorMsg, (Throwable)e);
            throw new PipeException(errorMsg);
        }
    }

    private void waitForResourceEnough4Parsing(long timeoutMs) throws InterruptedException {
        long currentTime;
        long startTime;
        PipeMemoryManager memoryManager = PipeDataNodeResourceManager.memory();
        if (memoryManager.isEnough4TabletParsing()) {
            return;
        }
        long lastRecordTime = startTime = System.currentTimeMillis();
        long memoryCheckIntervalMs = PipeConfig.getInstance().getPipeCheckMemoryEnoughIntervalMs();
        while (!memoryManager.isEnough4TabletParsing()) {
            Thread.sleep(memoryCheckIntervalMs);
            currentTime = System.currentTimeMillis();
            double elapsedRecordTimeSeconds = (double)(currentTime - lastRecordTime) / 1000.0;
            double waitTimeSeconds = (double)(currentTime - startTime) / 1000.0;
            if (elapsedRecordTimeSeconds > 10.0) {
                LOGGER.info("Wait for resource enough for parsing {} for {} seconds.", (Object)(this.resource != null ? this.resource.getTsFilePath() : "tsfile"), (Object)waitTimeSeconds);
                lastRecordTime = currentTime;
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Wait for resource enough for parsing {} for {} seconds.", (Object)(this.resource != null ? this.resource.getTsFilePath() : "tsfile"), (Object)waitTimeSeconds);
            }
            if (!(waitTimeSeconds * 1000.0 > (double)timeoutMs)) continue;
            throw new PipeException(String.format("TimeoutException: Waited %s seconds", waitTimeSeconds));
        }
        currentTime = System.currentTimeMillis();
        double waitTimeSeconds = (double)(currentTime - startTime) / 1000.0;
        LOGGER.info("Wait for resource enough for parsing {} for {} seconds.", (Object)(this.resource != null ? this.resource.getTsFilePath() : "tsfile"), (Object)waitTimeSeconds);
    }

    public boolean isGeneratedByPipeConsensus() {
        return this.isGeneratedByPipeConsensus;
    }

    public boolean isGeneratedByHistoricalExtractor() {
        return this.isGeneratedByHistoricalExtractor;
    }

    private TsFileInsertionDataContainer initDataContainer() {
        try {
            this.dataContainer.compareAndSet(null, new TsFileInsertionDataContainerProvider(this.pipeName, this.creationTime, this.tsFile, this.pipePattern, this.startTime, this.endTime, this.pipeTaskMeta, this).provide(this.isWithMod));
            return this.dataContainer.get();
        }
        catch (IOException e) {
            this.close();
            String errorMsg = String.format("Read TsFile %s error.", this.tsFile.getPath());
            LOGGER.warn(errorMsg, (Throwable)e);
            throw new PipeException(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(boolean skipReportOnCommit) throws IOException {
        AtomicLong count = new AtomicLong();
        if (this.shouldParseTime()) {
            try {
                this.consumeTabletInsertionEventsWithRetry(event -> {
                    count.addAndGet(event.count());
                    if (skipReportOnCommit) {
                        event.skipReportOnCommit();
                    }
                }, "PipeTsFileInsertionEvent::count");
                long l = count.get();
                return l;
            }
            finally {
                this.close();
            }
        }
        try (TsFileInsertionPointCounter counter = new TsFileInsertionPointCounter(this.tsFile, this.pipePattern);){
            long l = counter.count();
            return l;
        }
    }

    public void close() {
        this.dataContainer.getAndUpdate(container -> {
            if (Objects.nonNull(container)) {
                container.close();
            }
            return null;
        });
    }

    public String toString() {
        return String.format("PipeTsFileInsertionEvent{resource=%s, tsFile=%s, isLoaded=%s, isGeneratedByPipe=%s, dataContainer=%s}", this.resource, this.tsFile, this.isLoaded, this.isGeneratedByPipe, this.dataContainer) + " - " + super.toString();
    }

    public String coreReportMessage() {
        return String.format("PipeTsFileInsertionEvent{resource=%s, tsFile=%s, isLoaded=%s, isGeneratedByPipe=%s}", this.resource, this.tsFile, this.isLoaded, this.isGeneratedByPipe) + " - " + super.coreReportMessage();
    }

    public void trackResource() {
        PipeDataNodeResourceManager.ref().trackPipeEventResource((EnrichedEvent)this, this.eventResourceBuilder());
    }

    @Override
    public PipePhantomReferenceManager.PipeEventResource eventResourceBuilder() {
        return new PipeTsFileInsertionEventResource(this.isReleased, this.referenceCount, this.pipeName, this.tsFile, this.isWithMod, this.modFile, this.dataContainer);
    }

    @FunctionalInterface
    public static interface TabletInsertionEventConsumer {
        public void consume(PipeRawTabletInsertionEvent var1);
    }

    private static class PipeTsFileInsertionEventResource
    extends PipePhantomReferenceManager.PipeEventResource {
        private final File tsFile;
        private final boolean isWithMod;
        private final File modFile;
        private final AtomicReference<TsFileInsertionDataContainer> dataContainer;
        private final String pipeName;

        private PipeTsFileInsertionEventResource(AtomicBoolean isReleased, AtomicInteger referenceCount, String pipeName, File tsFile, boolean isWithMod, File modFile, AtomicReference<TsFileInsertionDataContainer> dataContainer) {
            super(isReleased, referenceCount);
            this.pipeName = pipeName;
            this.tsFile = tsFile;
            this.isWithMod = isWithMod;
            this.modFile = modFile;
            this.dataContainer = dataContainer;
        }

        protected void finalizeResource() {
            try {
                PipeDataNodeResourceManager.tsfile().decreaseFileReference(this.tsFile, this.pipeName);
                if (this.isWithMod) {
                    PipeDataNodeResourceManager.tsfile().decreaseFileReference(this.modFile, this.pipeName);
                }
                this.dataContainer.getAndUpdate(container -> {
                    if (Objects.nonNull(container)) {
                        container.close();
                    }
                    return null;
                });
            }
            catch (Exception e) {
                LOGGER.warn("Decrease reference count for TsFile {} error.", (Object)this.tsFile.getPath(), (Object)e);
            }
        }
    }
}

