/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.iotdb.db.utils.datastructure.MergeSortKey;
import org.apache.iotdb.db.utils.datastructure.SortKey;

public class MergeSortHeap {
    private final MergeSortKey[] heap;
    private int heapSize;
    private final Comparator<SortKey> comparator;

    public MergeSortHeap(int childNum, Comparator<SortKey> comparator) {
        this.heap = new MergeSortKey[childNum];
        this.heapSize = 0;
        this.comparator = comparator;
    }

    public boolean isEmpty() {
        return this.heapSize == 0;
    }

    public void push(MergeSortKey mergeSortKey) {
        if (this.heapSize == 0) {
            this.heap[0] = mergeSortKey;
        }
        this.shiftUp(this.heapSize, mergeSortKey);
        ++this.heapSize;
    }

    public MergeSortKey poll() {
        MergeSortKey res = this.heap[0];
        this.heap[0] = this.heap[this.heapSize - 1];
        this.shiftDown(0, this.heap[0]);
        --this.heapSize;
        return res;
    }

    public MergeSortKey peek() {
        return this.heap[0];
    }

    public String toString() {
        return Arrays.toString(this.heap);
    }

    private int getSmallerChildIndex(int index) {
        int leftChildIndex = (index << 1) + 1;
        int rightChildIndex = (index << 1) + 2;
        int smallerChildIndex = this.heapSize <= leftChildIndex ? -1 : (this.heapSize <= rightChildIndex ? leftChildIndex : (this.comparator.compare(this.heap[leftChildIndex], this.heap[rightChildIndex]) > 0 ? rightChildIndex : leftChildIndex));
        return smallerChildIndex;
    }

    private void shiftDown(int parentIndex, MergeSortKey parent) {
        MergeSortKey child;
        if (parentIndex == this.heapSize - 1) {
            return;
        }
        int childIndex = this.getSmallerChildIndex(parentIndex);
        if (childIndex != -1 && this.comparator.compare(parent, child = this.heap[childIndex]) > 0) {
            this.heap[parentIndex] = child;
            this.heap[childIndex] = parent;
            this.shiftDown(childIndex, parent);
        }
    }

    private void shiftUp(int childIndex, MergeSortKey child) {
        if (childIndex == 0) {
            return;
        }
        int parentIndex = childIndex - 1 >>> 1;
        MergeSortKey parent = this.heap[parentIndex];
        if (this.comparator.compare(parent, child) > 0) {
            this.heap[parentIndex] = child;
            this.heap[childIndex] = parent;
            this.shiftUp(parentIndex, child);
        } else {
            this.heap[childIndex] = child;
        }
    }

    public int getHeapSize() {
        return this.heapSize;
    }
}

