/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.shiro;

import jakarta.servlet.ServletContext;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.mod.shiro.ShiroEnvironmentLoaderListener;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.lang.io.ResourceUtils;

class FusekiShiroLib {
    private static final String fileShiroPrefix = "file:";
    private static final int fileShiroPrefixLength = "file:".length();

    FusekiShiroLib() {
    }

    static void shiroEnvironment(ServletContext servletContext, List<String> possibleShiroIniFiles) {
        ShiroEnvironmentLoaderListener shiroListener = new ShiroEnvironmentLoaderListener(possibleShiroIniFiles);
        try {
            shiroListener.initEnvironment(servletContext);
        }
        catch (ConfigurationException ex) {
            ShiroEnvironmentLoaderListener.shiroConfigLog.error("Failed to initialize Shiro: " + ex.getMessage());
            throw new FusekiConfigException(ex.getMessage(), ex);
        }
    }

    static String huntForShiroIni(List<String> locations) {
        for (String loc : locations) {
            String fn;
            Path p;
            if (!(loc.startsWith(fileShiroPrefix) ? Files.exists(p = Path.of(fn = loc.substring(fileShiroPrefixLength), new String[0]), new LinkOption[0]) : ResourceUtils.resourceExists(loc))) continue;
            return loc;
        }
        return null;
    }

    public static String withResourcePrefix(String shiroFileName) {
        if (shiroFileName.startsWith(fileShiroPrefix)) {
            return shiroFileName;
        }
        return fileShiroPrefix + shiroFileName;
    }

    public static String removeResourcePrefix(String shiroFileResource) {
        if (shiroFileResource.startsWith(fileShiroPrefix)) {
            String fn = shiroFileResource.substring(fileShiroPrefixLength);
            return fn;
        }
        return shiroFileResource;
    }
}

