/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateTimeUtils {
    private static final DateTimeFormatter dateTimeFmt_display = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss zz");
    private static final DateTimeFormatter dateFmt_yyyymmdd = DateTimeFormatter.ofPattern("yyyy-MM-ddxxx");
    private static final DateTimeFormatter dateTimeFmt_XSD_ms0 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssxxx");
    private static final DateTimeFormatter dateTimeFmt_XSD_ms = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSxxx");
    private static final DateTimeFormatter timeFmt_XSD_ms0 = DateTimeFormatter.ofPattern("HH:mm:ssxxx");
    private static final DateTimeFormatter timeFmt_XSD_ms = DateTimeFormatter.ofPattern("HH:mm:ss.SSSxxx");
    private static ZoneId tzUTC = ZoneId.of("UTC");

    public static String nowUTC() {
        ZonedDateTime zdt = ZonedDateTime.now(tzUTC);
        return DateTimeUtils.asXSDDateTimeString(zdt);
    }

    public static String asXSDDateTimeString(ZonedDateTime zdt) {
        DateTimeFormatter fmt = DateTimeUtils.chooseFormatter(zdt);
        return zdt.format(fmt);
    }

    private static boolean hasZeroMilliSeconds(ZonedDateTime zdt) {
        return zdt.getNano() == 0;
    }

    private static DateTimeFormatter chooseFormatter(ZonedDateTime zdt) {
        DateTimeFormatter fmt = DateTimeUtils.hasZeroMilliSeconds(zdt) ? dateTimeFmt_XSD_ms0 : dateTimeFmt_XSD_ms;
        return fmt;
    }

    public static String nowAsXSDDateTimeString() {
        return DateTimeUtils.calendarToXSDDateTimeString(new GregorianCalendar());
    }

    public static String todayAsXSDDateString() {
        return DateTimeUtils.calendarToXSDDateString(new GregorianCalendar());
    }

    public static String nowAsString() {
        return DateTimeUtils.nowAsString(dateTimeFmt_display);
    }

    public static String nowAsString(String formatString) {
        FastDateFormat df = FastDateFormat.getInstance(formatString);
        return df.format(new Date());
    }

    public static String nowAsString(DateTimeFormatter dateFormat) {
        ZonedDateTime now2 = ZonedDateTime.now();
        return dateFormat.format(now2);
    }

    private static boolean hasZeroMilliSeconds(Calendar cal) {
        return !cal.isSet(14) || cal.get(14) == 0;
    }

    public static String calendarToXSDDateTimeString(Calendar cal) {
        DateTimeFormatter fmt = DateTimeUtils.hasZeroMilliSeconds(cal) ? dateTimeFmt_XSD_ms0 : dateTimeFmt_XSD_ms;
        return DateTimeUtils.calendarToXSDString(cal, fmt);
    }

    public static String calendarToXSDDateString(Calendar cal) {
        Object x = DateTimeUtils.calendarToXSDString(cal, dateFmt_yyyymmdd);
        if (((String)x).endsWith("Z")) {
            x = ((String)x).substring(0, ((String)x).length() - 1) + "+00:00";
        }
        return x;
    }

    public static String calendarToXSDTimeString(Calendar cal) {
        DateTimeFormatter fmt = DateTimeUtils.hasZeroMilliSeconds(cal) ? timeFmt_XSD_ms0 : timeFmt_XSD_ms;
        return DateTimeUtils.calendarToXSDString(cal, fmt);
    }

    private static String calendarToXSDString(Calendar cal, DateTimeFormatter fmt) {
        ZonedDateTime zdt = ((GregorianCalendar)cal).toZonedDateTime();
        String lex = fmt.format(zdt);
        return lex;
    }
}

