/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.atlas.iterator.IteratorWrapper;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.sparql.engine.iterator.Abortable;

public class IterAbortable<T>
extends IteratorWrapper<T>
implements Abortable,
IteratorCloseable<T> {
    private AtomicBoolean cancelSignal;

    public IterAbortable(Iterator<T> iterator) {
        this(iterator, null);
    }

    protected IterAbortable(Iterator<T> iterator, AtomicBoolean cancelSignal) {
        super(iterator);
        this.cancelSignal = cancelSignal != null ? cancelSignal : new AtomicBoolean(false);
    }

    public static <T> IterAbortable<T> wrap(Iterator<T> it, AtomicBoolean cancelSignal) {
        return new IterAbortable<T>(it, cancelSignal);
    }

    private boolean isAborted() {
        return this.cancelSignal.get() || Thread.currentThread().isInterrupted();
    }

    private void checkAbort() {
        if (this.isAborted()) {
            throw new QueryCancelledException();
        }
    }

    @Override
    public void abort() {
        this.cancelSignal.set(true);
    }

    @Override
    public boolean hasNext() {
        this.checkAbort();
        return this.get().hasNext();
    }

    @Override
    public T next() {
        this.checkAbort();
        return this.get().next();
    }

    @Override
    public void remove() {
        this.checkAbort();
        this.get().remove();
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.get().forEachRemaining((? super E item) -> {
            this.checkAbort();
            action.accept(item);
        });
    }
}

