/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;

public class HotSwapHandler
extends Handler.AbstractContainer
implements Handler.Singleton {
    private volatile Handler _handler;

    public HotSwapHandler() {
        super(true);
    }

    @Override
    public Handler getHandler() {
        return this._handler;
    }

    @Override
    public void setHandler(Handler handler) {
        Handler.Container container2;
        Server server1 = this.getServer();
        if (server1 != null && server1.isStarted() && handler != null && server1.getInvocationType() != Invocable.combine(server1.getInvocationType(), handler.getInvocationType())) {
            throw new IllegalArgumentException("Cannot change invocation type of started server");
        }
        if (handler == this || handler instanceof Handler.Container && (container2 = (Handler.Container)handler).getDescendants().contains(this)) {
            throw new IllegalStateException("setHandler loop");
        }
        try {
            Server server = this.getServer();
            if (handler == this._handler) {
                return;
            }
            Handler oldHandler = this._handler;
            if (handler != null) {
                handler.setServer(server);
                this.addManaged(handler);
            }
            this._handler = handler;
            if (oldHandler != null) {
                this.removeBean(oldHandler);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Handler next = this._handler;
        return next != null && next.handle(request, response, callback);
    }

    @Override
    public Invocable.InvocationType getInvocationType() {
        return Handler.Singleton.super.getInvocationType();
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler child = this.getHandler();
        if (child != null) {
            this.setHandler((Handler)null);
            child.destroy();
        }
        super.destroy();
    }
}

