/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.resources;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.dto.html5.Form;
import org.apache.juneau.dto.html5.HtmlBuilder;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.http.exception.NotFound;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.rest.BasicRestServlet;
import org.apache.juneau.rest.annotation.MethodSwagger;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestMethod;

@Rest(path="/config", title={"Configuration"}, description={"Contents of configuration file."})
@HtmlDocConfig(navlinks={"up: request:/..", "options: servlet:/?method=OPTIONS", "stats: servlet:/stats", "edit: servlet:/edit"})
public class ConfigResource
extends BasicRestServlet {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="GET", path="/", summary="Get config file contents", description={"Show contents of config file as an OMap."}, swagger=@MethodSwagger(responses={"200:{ description:'Config file as a map of map of objects.', 'x-example':{'':{defaultKey:'defaultValue'},'Section1':{key1:'val1',key2:123}}}"}))
    public OMap getConfig() {
        return this.getServletConfig().getConfig().toMap();
    }

    @RestMethod(name="GET", path="/edit", summary="Render form entry page for editing config file", description={"Renders a form entry page for editing the raw text of a config file."})
    public Form getConfigEditForm() {
        return HtmlBuilder.form().id("form").action("servlet:/").method("POST").enctype("application/x-www-form-urlencoded").children(new Object[]{HtmlBuilder.div()._class("data").children(new Object[]{HtmlBuilder.table((Object[])new Object[]{HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.td().style("text-align:right").children(new Object[]{HtmlBuilder.button((String)"submit", (Object[])new Object[]{"Submit"}), HtmlBuilder.button((String)"reset", (Object[])new Object[]{"Reset"})})}), HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th().child((Object)"Contents")}), HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th().child((Object)HtmlBuilder.textarea().name("contents").rows((Number)40).cols((Object)120).style("white-space:pre;word-wrap:normal;overflow-x:scroll;font-family:monospace;").text((Object)this.getServletConfig().getConfig().toString()))})})})});
    }

    @RestMethod(name="GET", path="/{section}", summary="Get config file section contents", description={"Show contents of config file section as an OMap."}, swagger=@MethodSwagger(responses={"200:{ description:'Config file section as a map of objects.', 'x-example':{key1:'val1',key2:123}}"}))
    public OMap getConfigSection(@Path(n="section", d={"Section name in config file."}, ex={"REST"}) String section) throws SectionNotFound, BadConfig {
        return this.getSection(section);
    }

    @RestMethod(name="GET", path="/{section}/{key}", summary="Get config file entry value", description={"Show value of config file entry as a simple string."}, swagger=@MethodSwagger(responses={"200:{ description:'Entry value.', 'x-example':'servlet:/htdocs/themes/dark.css'}"}))
    public String getConfigEntry(@Path(n="section", d={"Section name in config file."}, ex={"REST"}) String section, @Path(n="key", d={"Key name in section."}, ex={"theme"}) String key) throws SectionNotFound, BadConfig {
        return this.getSection(section).getString(key);
    }

    @RestMethod(name="POST", path="/", summary="Update config file contents", description={"Update the contents of the config file from a FORM post."}, swagger=@MethodSwagger(responses={"200:{ description:'Config file section as a map of objects.', 'x-example':{key1:'val1',key2:123}}"}))
    public OMap setConfigContentsFormPost(@FormData(n="contents", d={"New contents in INI file format."}) String contents) throws Exception {
        return this.setConfigContents(new StringReader(contents));
    }

    @RestMethod(name="PUT", path="/", summary="Update config file contents", description={"Update the contents of the config file from raw text."}, swagger=@MethodSwagger(responses={"200:{ description:'Config file section as a map of objects.', 'x-example':{key1:'val1',key2:123}}"}))
    public OMap setConfigContents(@Body(d={"New contents in INI file format."}) Reader contents) throws Exception {
        return this.getServletConfig().getConfig().load(contents, true).toMap();
    }

    @RestMethod(name="PUT", path="/{section}", summary="Update config section contents", description={"Add or overwrite a config file section."}, swagger=@MethodSwagger(responses={"200:{ description:'Config file section as a map of objects.', 'x-example':{key1:'val1',key2:123}}"}))
    public OMap setConfigSection(@Path(n="section", d={"Section name in config file."}, ex={"REST"}) String section, @Body(d={"New contents of config section as a simple map of key/value pairs."}, ex={"{theme:'servlet:/htdocs/themes/dark.css'}"}) Map<String, Object> contents) throws Exception {
        this.getServletConfig().getConfig().setSection(section, null, contents);
        return this.getSection(section);
    }

    @RestMethod(name="PUT", path="/{section}/{key}", summary="Update config entry value", description={"Add or overwrite a config file entry."}, swagger=@MethodSwagger(responses={"200:{ description:'The updated value.', 'x-example':'servlet:/htdocs/themes/dark.css'}"}))
    public String setConfigValue(@Path(n="section", d={"Section name in config file."}, ex={"REST"}) String section, @Path(n="key", d={"Key name in section."}, ex={"theme"}) String key, @Body(d={"New value for entry."}, ex={"servlet:/htdocs/themes/dark.css"}) String value) throws SectionNotFound, BadConfig {
        this.getServletConfig().getConfig().set(section + '/' + key, value);
        return this.getSection(section).getString(key);
    }

    private OMap getSection(String name) throws SectionNotFound, BadConfig {
        OMap m;
        try {
            m = this.getServletConfig().getConfig().getSectionAsMap(name);
        }
        catch (ParseException e) {
            throw new BadConfig((Exception)((Object)e));
        }
        if (m == null) {
            throw new SectionNotFound();
        }
        return m;
    }

    @Response(description={"The configuration file contained syntax errors and could not be parsed."})
    private class BadConfig
    extends InternalServerError {
        private static final long serialVersionUID = 1L;

        BadConfig(Exception e) {
            super((Throwable)e, "The configuration file contained syntax errors and could not be parsed.", new Object[0]);
        }
    }

    @Response(description={"Section not found."})
    private class SectionNotFound
    extends NotFound {
        private static final long serialVersionUID = 1L;

        SectionNotFound() {
            super("Section not found.");
        }
    }
}

