/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.juneau.assertions.ArrayAssertion;
import org.apache.juneau.assertions.BooleanAssertion;
import org.apache.juneau.assertions.ByteArrayAssertion;
import org.apache.juneau.assertions.CollectionAssertion;
import org.apache.juneau.assertions.ComparableAssertion;
import org.apache.juneau.assertions.DateAssertion;
import org.apache.juneau.assertions.IntegerAssertion;
import org.apache.juneau.assertions.ListAssertion;
import org.apache.juneau.assertions.LongAssertion;
import org.apache.juneau.assertions.ObjectAssertion;
import org.apache.juneau.assertions.Snippet;
import org.apache.juneau.assertions.StringAssertion;
import org.apache.juneau.assertions.ThrowableAssertion;
import org.apache.juneau.assertions.ZonedDateTimeAssertion;
import org.apache.juneau.internal.IOUtils;

public class Assertions {
    public static DateAssertion assertDate(Date value) {
        return new DateAssertion(value);
    }

    public static ZonedDateTimeAssertion assertZonedDateTimeAssertion(ZonedDateTime value) {
        return new ZonedDateTimeAssertion(value);
    }

    public static IntegerAssertion assertInteger(Integer value) {
        return new IntegerAssertion(value);
    }

    public static LongAssertion assertLong(Long value) {
        return new LongAssertion(value);
    }

    public static ComparableAssertion assertComparable(Comparable<?> value) {
        return new ComparableAssertion(value);
    }

    public static ObjectAssertion assertObject(Object value) {
        return new ObjectAssertion(value);
    }

    public static StringAssertion assertString(Object value) {
        return new StringAssertion(value);
    }

    public static BooleanAssertion assertBoolean(Boolean value) {
        return new BooleanAssertion(value);
    }

    public static ThrowableAssertion assertThrowable(Throwable value) {
        return new ThrowableAssertion(value);
    }

    public static ArrayAssertion assertArray(Object value) {
        return new ArrayAssertion(value);
    }

    public static CollectionAssertion assertCollection(Collection<?> value) {
        return new CollectionAssertion(value);
    }

    public static ListAssertion assertList(List<?> value) {
        return new ListAssertion(value);
    }

    public static ThrowableAssertion assertThrown(Snippet snippet) {
        try {
            snippet.run();
        }
        catch (Throwable e) {
            return Assertions.assertThrowable(e);
        }
        return Assertions.assertThrowable(null);
    }

    public static ByteArrayAssertion assertStream(InputStream is) throws IOException {
        return new ByteArrayAssertion(is == null ? null : IOUtils.readBytes(is));
    }

    public static ByteArrayAssertion assertBytes(byte[] bytes) {
        return new ByteArrayAssertion(bytes);
    }

    public static StringAssertion assertReader(Reader r) throws IOException {
        return new StringAssertion(r == null ? null : IOUtils.read(r));
    }
}

