/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.List;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ExtendedBeanPropertyMeta;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfMetaProvider;
import org.apache.juneau.jena.RdfUtils;
import org.apache.juneau.jena.annotation.Rdf;
import org.apache.juneau.jena.annotation.RdfSchema;
import org.apache.juneau.xml.Namespace;

public class RdfBeanPropertyMeta
extends ExtendedBeanPropertyMeta {
    public static final RdfBeanPropertyMeta DEFAULT = new RdfBeanPropertyMeta();
    private RdfCollectionFormat collectionFormat = RdfCollectionFormat.DEFAULT;
    private Namespace namespace = null;
    private boolean isBeanUri;

    public RdfBeanPropertyMeta(BeanPropertyMeta bpm, RdfMetaProvider mp) {
        super(bpm);
        List rdfs = bpm.getAllAnnotationsParentFirst(Rdf.class);
        List schemas = bpm.getAllAnnotationsParentFirst(RdfSchema.class);
        rdfs.forEach(x -> {
            if (x.collectionFormat() != RdfCollectionFormat.DEFAULT) {
                this.collectionFormat = x.collectionFormat();
            }
            if (x.beanUri()) {
                this.isBeanUri = true;
            }
        });
        this.namespace = RdfUtils.findNamespace(rdfs, schemas);
    }

    private RdfBeanPropertyMeta() {
        super(null);
    }

    protected RdfCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public boolean isBeanUri() {
        return this.isBeanUri;
    }
}

