/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.entity.HttpEntityBuilder;
import org.apache.juneau.internal.IOUtils;

public class FileEntity
extends BasicHttpEntity {
    private final File content = this.contentOrElse(null);
    private final byte[] cache;

    public static HttpEntityBuilder<FileEntity> create() {
        return new HttpEntityBuilder<Class<FileEntity>>(FileEntity.class);
    }

    public FileEntity(HttpEntityBuilder<?> builder) throws IOException {
        super(builder);
        this.cache = builder.cached ? IOUtils.readBytes(this.content) : null;
    }

    public HttpEntityBuilder<FileEntity> copy() {
        return new HttpEntityBuilder<FileEntity>(this);
    }

    @Override
    public String asString() throws IOException {
        return IOUtils.read(this.content);
    }

    @Override
    public byte[] asBytes() throws IOException {
        return this.cache == null ? IOUtils.readBytes(this.content) : this.cache;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return this.content == null ? 0L : this.content.length();
    }

    @Override
    public InputStream getContent() throws IOException {
        return this.cache == null ? new FileInputStream(this.content) : new ByteArrayInputStream(this.cache);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        Assertions.assertArgNotNull("out", out);
        if (this.cache != null) {
            out.write(this.cache);
        } else {
            try (InputStream is = this.getContent();){
                IOUtils.pipe(is, out);
            }
        }
    }
}

