/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.StringUtils;

@Bean(properties="name,namespace,prefix,attribute,wrapped,*")
@FluentSetters
public class Xml
extends SwaggerElement {
    private String name;
    private String namespace;
    private String prefix;
    private Boolean attribute;
    private Boolean wrapped;

    public Xml() {
    }

    public Xml(Xml copyFrom) {
        super(copyFrom);
        this.attribute = copyFrom.attribute;
        this.name = copyFrom.name;
        this.namespace = copyFrom.namespace;
        this.prefix = copyFrom.prefix;
        this.wrapped = copyFrom.wrapped;
    }

    public Xml copy() {
        return new Xml(this);
    }

    public Boolean getAttribute() {
        return this.attribute;
    }

    public Xml setAttribute(Boolean value) {
        this.attribute = value;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Xml setName(String value) {
        this.name = value;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Xml setNamespace(String value) {
        this.namespace = value;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Xml setPrefix(String value) {
        this.prefix = value;
        return this;
    }

    public Boolean getWrapped() {
        return this.wrapped;
    }

    public Xml setWrapped(Boolean value) {
        this.wrapped = value;
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "attribute": {
                return ConverterUtils.toType(this.getAttribute(), type);
            }
            case "name": {
                return ConverterUtils.toType(this.getName(), type);
            }
            case "namespace": {
                return ConverterUtils.toType(this.getNamespace(), type);
            }
            case "prefix": {
                return ConverterUtils.toType(this.getPrefix(), type);
            }
            case "wrapped": {
                return ConverterUtils.toType(this.getWrapped(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Xml set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "attribute": {
                return this.setAttribute(ConverterUtils.toBoolean(value));
            }
            case "name": {
                return this.setName(StringUtils.stringify(value));
            }
            case "namespace": {
                return this.setNamespace(StringUtils.stringify(value));
            }
            case "prefix": {
                return this.setPrefix(StringUtils.stringify(value));
            }
            case "wrapped": {
                return this.setWrapped(ConverterUtils.toBoolean(value));
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.attribute != null, "attribute").addIf(this.name != null, "name").addIf(this.namespace != null, "namespace").addIf(this.prefix != null, "prefix").addIf(this.wrapped != null, "wrapped").build();
        return new MultiSet<String>(s, super.keySet());
    }
}

