/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Form;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.client.AccessClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.impl.AbstractJerseyClient;
import org.apache.nifi.toolkit.client.impl.request.BearerTokenRequestConfig;

public class JerseyAccessClient
extends AbstractJerseyClient
implements AccessClient {
    private final WebTarget accessTarget;

    public JerseyAccessClient(WebTarget baseTarget) {
        super(null);
        this.accessTarget = baseTarget.path("/access");
    }

    @Override
    public String getToken(String username, String password) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException("Username is required");
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("Password is required");
        }
        return this.executeAction("Error performing login", () -> {
            WebTarget target = this.accessTarget.path("token");
            Form form = new Form();
            form.param("username", username);
            form.param("password", password);
            return (String)this.getRequestBuilder(target).post(Entity.form((Form)form), String.class);
        });
    }

    @Override
    public String getTokenFromKerberosTicket() throws NiFiClientException, IOException {
        return this.executeAction("Error performing kerberos login", () -> {
            WebTarget target = this.accessTarget.path("kerberos");
            return (String)this.getRequestBuilder(target).post(Entity.text(null), String.class);
        });
    }

    @Override
    public void logout(String token) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new IllegalArgumentException("Token is required");
        }
        this.executeAction("Error performing logout", () -> {
            WebTarget target = this.accessTarget.path("logout");
            Invocation.Builder requestBuilder = this.getRequestBuilder(target);
            BearerTokenRequestConfig tokenConfig = new BearerTokenRequestConfig(token);
            Map<String, String> bearerHeaders = tokenConfig.getHeaders();
            bearerHeaders.entrySet().stream().forEach(e -> requestBuilder.header((String)e.getKey(), e.getValue()));
            requestBuilder.delete();
            return null;
        });
    }
}

