/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.bucket;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.client.BucketClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;

public class CreateBucket
extends AbstractNiFiRegistryCommand<StringResult> {
    public CreateBucket() {
        super("create-bucket", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates a bucket using the given name and description.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.BUCKET_NAME.createOption());
        this.addOption(CommandOption.BUCKET_DESC.createOption());
    }

    @Override
    public StringResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, MissingOptionException {
        String bucketName = this.getRequiredArg(properties, CommandOption.BUCKET_NAME);
        String bucketDesc = this.getArg(properties, CommandOption.BUCKET_DESC);
        Bucket bucket = new Bucket();
        bucket.setName(bucketName);
        bucket.setDescription(bucketDesc);
        BucketClient bucketClient = client.getBucketClient();
        Bucket createdBucket = bucketClient.create(bucket);
        return new StringResult(createdBucket.getIdentifier(), this.getContext().isInteractive());
    }
}

