/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotManager;

public class DiffListByArrayList<T extends Comparable<Integer>>
implements DiffList<T> {
    private final List<T> list;

    DiffListByArrayList(List<T> list) {
        this.list = list;
    }

    public DiffListByArrayList(int initialCapacity) {
        this(new ArrayList(initialCapacity));
    }

    @Override
    public T get(int i) {
        return (T)((Comparable)this.list.get(i));
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public T remove(int i) {
        assert (!SnapshotManager.isDeletionOrdered() || i == 0);
        return (T)((Comparable)this.list.remove(i));
    }

    @Override
    public boolean addLast(T t) {
        return this.list.add(t);
    }

    @Override
    public void addFirst(T t) {
        this.list.add(0, t);
    }

    @Override
    public int binarySearch(int i) {
        return Collections.binarySearch(this.list, i);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public List<T> getMinListForRange(int startIndex, int endIndex, INodeDirectory dir) {
        return this.list.subList(startIndex, endIndex);
    }
}

