/*
 * Decompiled with CFR 0.152.
 */
package org.archive.extract;

import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.archive.extract.ExtractorOutput;
import org.archive.resource.Resource;
import org.archive.util.StreamCopy;
import org.json.JSONException;

public class DumpingExtractorOutput
implements ExtractorOutput {
    private static final Logger LOG = Logger.getLogger(DumpingExtractorOutput.class.getName());
    private PrintStream out;

    public DumpingExtractorOutput(OutputStream out) {
        try {
            this.out = new PrintStream(out, false, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public void output(Resource resource) throws IOException {
        OutputStream nullo = ByteStreams.nullOutputStream();
        CountingOutputStream co = new CountingOutputStream(nullo);
        StreamCopy.copy(resource.getInputStream(), (OutputStream)co);
        long bytes = co.getCount();
        if (bytes > 0L) {
            LOG.info(bytes + " unconsumed bytes in Resource InputStream.");
        }
        try {
            this.out.println(resource.getMetaData().getTopMetaData().toString(1));
        }
        catch (JSONException e) {
            LOG.warning(e.getMessage());
        }
    }
}

