/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.retriever;

import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.query.engine.retriever.ConfiguredObjectRetriever;
import org.apache.qpid.server.query.engine.retriever.EntityRetriever;
import org.apache.qpid.server.security.CertificateDetails;

public class CertificateRetriever<C extends ConfiguredObject<?>>
extends ConfiguredObjectRetriever<C>
implements EntityRetriever<C> {
    private final Class<C> _keyStoreType = KeyStore.class;
    private final Class<C> _trustStoreType = TrustStore.class;
    private final List<String> _fieldNames = Stream.of("store", "alias", "issuerName", "serialNumber", "hexSerialNumber", "signatureAlgorithm", "subjectAltNames", "subjectName", "validFrom", "validUntil", "version").collect(Collectors.toList());
    private final BiFunction<ConfiguredObject<?>, CertificateDetails, Map<String, Object>> certificateMapping = (parent, certificate) -> {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this._fieldNames.get(0), parent.getName());
        map.put(this._fieldNames.get(1), certificate.getAlias() == null ? "null" : certificate.getAlias());
        map.put(this._fieldNames.get(2), certificate.getIssuerName());
        map.put(this._fieldNames.get(3), certificate.getSerialNumber());
        map.put(this._fieldNames.get(4), this.toHex(certificate.getSerialNumber()));
        map.put(this._fieldNames.get(5), certificate.getSignatureAlgorithm());
        map.put(this._fieldNames.get(6), certificate.getSubjectAltNames());
        map.put(this._fieldNames.get(7), certificate.getSubjectName());
        map.put(this._fieldNames.get(8), certificate.getValidFrom());
        map.put(this._fieldNames.get(9), certificate.getValidUntil());
        map.put(this._fieldNames.get(10), certificate.getVersion());
        return Collections.unmodifiableMap(map);
    };

    @Override
    public Stream<Map<String, ?>> retrieve(C broker) {
        Stream<KeyStore> keyStoreStream = this.retrieve(broker, this._keyStoreType).map(keystore -> (KeyStore)keystore);
        Stream<TrustStore> trustStoreStream = this.retrieve(broker, this._trustStoreType).map(truststore -> (TrustStore)truststore);
        return Stream.concat(keyStoreStream.flatMap(keyStore -> keyStore.getCertificateDetails().stream().map(certificate -> this.certificateMapping.apply((ConfiguredObject<?>)keyStore, (CertificateDetails)certificate))), trustStoreStream.flatMap(trustStore -> trustStore.getCertificateDetails().stream().map(certificate -> this.certificateMapping.apply((ConfiguredObject<?>)trustStore, (CertificateDetails)certificate))));
    }

    @Override
    public List<String> getFieldNames() {
        return this._fieldNames;
    }

    private String toHex(String serialNumber) {
        try {
            if (serialNumber.contains(":")) {
                return this.format(new BigInteger(serialNumber.replace(":", ""), 16));
            }
            return this.format(new BigInteger(serialNumber));
        }
        catch (NumberFormatException e) {
            return serialNumber;
        }
    }

    private String format(BigInteger serialNumber) {
        return "0x" + serialNumber.toString(16);
    }
}

