/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc.hikaricp;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.security.FileKeyStore;
import org.apache.qpid.server.security.FileTrustStore;
import org.apache.qpid.server.store.jdbc.ConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariCPConnectionProvider
implements ConnectionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariCPConnectionProvider.class);
    private static final String ADDING_DATASOURCE_PROPERTY = "Adding dataSource property '{}' with value '{}'";
    public static final int DEFAULT_MINIMUM_IDLE = 20;
    public static final int DEFAULT_MAXIMUM_POOLSIZE = 40;
    private final HikariDataSource _dataSource;

    public HikariCPConnectionProvider(String connectionUrl, String username, String password, KeyStore<?> keyStore, String keyStorePathPropertyName, String keyStorePasswordPropertyName, TrustStore<?> trustStore, String trustStorePathPropertyName, String trustStorePasswordPropertyName, Map<String, String> providerAttributes) {
        HikariConfig config = HikariCPConnectionProvider.createHikariCPConfig(connectionUrl, username, password, keyStore, keyStorePathPropertyName, keyStorePasswordPropertyName, trustStore, trustStorePathPropertyName, trustStorePasswordPropertyName, providerAttributes);
        this._dataSource = new HikariDataSource(config);
    }

    static HikariConfig createHikariCPConfig(String connectionUrl, String username, String password, KeyStore<?> keyStore, String keyStorePathPropertyName, String keyStorePasswordPropertyName, TrustStore<?> trustStore, String trustStorePathPropertyName, String trustStorePasswordPropertyName, Map<String, String> providerAttributes) {
        HashMap<String, String> attributes = new HashMap<String, String>(providerAttributes);
        attributes.putIfAbsent("qpid.jdbcstore.hikaricp.minimumIdle", String.valueOf(20));
        attributes.putIfAbsent("qpid.jdbcstore.hikaricp.maximumPoolSize", String.valueOf(40));
        int prefixLength = "qpid.jdbcstore.hikaricp.".length();
        Map<String, String> propertiesMap = attributes.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(prefixLength), Map.Entry::getValue));
        Properties properties = new Properties();
        properties.putAll(propertiesMap);
        try {
            String pwd;
            String path;
            HikariConfig config = new HikariConfig(properties);
            config.setJdbcUrl(connectionUrl);
            if (username != null) {
                config.setUsername(username);
            }
            if (password != null) {
                config.setPassword(password);
            }
            if (keyStore instanceof FileKeyStore) {
                if (keyStorePathPropertyName != null) {
                    path = ((FileKeyStore)keyStore).getPath();
                    LOGGER.debug(ADDING_DATASOURCE_PROPERTY, (Object)keyStorePathPropertyName, (Object)path);
                    config.addDataSourceProperty(keyStorePathPropertyName, (Object)path);
                }
                if (keyStorePasswordPropertyName != null) {
                    pwd = ((FileKeyStore)keyStore).getPassword() == null ? "null" : "******";
                    LOGGER.debug(ADDING_DATASOURCE_PROPERTY, (Object)keyStorePasswordPropertyName, (Object)pwd);
                    config.addDataSourceProperty(keyStorePasswordPropertyName, (Object)((FileKeyStore)keyStore).getPassword());
                }
            }
            if (trustStore instanceof FileTrustStore) {
                if (trustStorePathPropertyName != null) {
                    path = ((FileTrustStore)trustStore).getPath();
                    LOGGER.debug(ADDING_DATASOURCE_PROPERTY, (Object)trustStorePathPropertyName, (Object)path);
                    config.addDataSourceProperty(trustStorePathPropertyName, (Object)((FileTrustStore)trustStore).getPath());
                }
                if (trustStorePasswordPropertyName != null) {
                    pwd = ((FileTrustStore)trustStore).getPassword() == null ? "null" : "******";
                    LOGGER.debug(ADDING_DATASOURCE_PROPERTY, (Object)trustStorePasswordPropertyName, (Object)pwd);
                    config.addDataSourceProperty(trustStorePasswordPropertyName, (Object)((FileTrustStore)trustStore).getPassword());
                }
            }
            return config;
        }
        catch (Exception e) {
            throw new IllegalConfigurationException("Unexpected exception on applying HikariCP configuration", (Throwable)e);
        }
    }

    public Connection getConnection() throws SQLException {
        return this._dataSource.getConnection();
    }

    public void close() {
        this._dataSource.close();
    }
}

