/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.consumer.ConsumerOption;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.filter.JMSSelectorFilter;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.filter.SelectorParsingException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.Outcome;
import org.apache.qpid.server.logging.messages.SubscriptionMessages;
import org.apache.qpid.server.logging.subjects.QueueLogSubject;
import org.apache.qpid.server.message.MessageContainer;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.protocol.MessageConverterRegistry;
import org.apache.qpid.server.queue.AbstractQueue;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.queue.QueueConsumerNode;
import org.apache.qpid.server.queue.QueueContext;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.util.StateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueueConsumerImpl<T extends ConsumerTarget>
extends AbstractConfiguredObject<QueueConsumerImpl<T>>
implements QueueConsumer<QueueConsumerImpl<T>, T>,
LogSubject {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueConsumerImpl.class);
    private final AtomicBoolean _closed = new AtomicBoolean(false);
    private final long _consumerNumber;
    private final long _createTime = System.currentTimeMillis();
    private final MessageInstance.StealableConsumerAcquiredState<QueueConsumerImpl<T>> _owningState = new MessageInstance.StealableConsumerAcquiredState<QueueConsumerImpl>(this);
    private final WaitingOnCreditMessageListener _waitingOnCreditMessageListener = new WaitingOnCreditMessageListener();
    private final boolean _acquires;
    private final boolean _seesRequeues;
    private final boolean _isTransient;
    private final AtomicLong _deliveredCount = new AtomicLong(0L);
    private final AtomicLong _deliveredBytes = new AtomicLong(0L);
    private final FilterManager _filters;
    private final Class<? extends ServerMessage> _messageClass;
    private final Object _sessionReference;
    private final AbstractQueue _queue;
    private final T _target;
    private volatile QueueContext _queueContext;
    @ManagedAttributeField
    private boolean _exclusive;
    @ManagedAttributeField
    private boolean _noLocal;
    @ManagedAttributeField
    private String _distributionMode;
    @ManagedAttributeField
    private String _settlementMode;
    @ManagedAttributeField
    private String _selector;
    @ManagedAttributeField
    private int _priority;
    private final String _linkName;
    private volatile QueueConsumerNode _queueConsumerNode;
    private volatile boolean _nonLive;

    QueueConsumerImpl(AbstractQueue<?> queue, T target, String consumerName, FilterManager filters, Class<? extends ServerMessage> messageClass, EnumSet<ConsumerOption> optionSet, Integer priority) {
        super(queue, QueueConsumerImpl.createAttributeMap(target.getSession(), consumerName, filters, optionSet, priority));
        this._messageClass = messageClass;
        this._sessionReference = target.getSession().getConnectionReference();
        this._consumerNumber = CONSUMER_NUMBER_GENERATOR.getAndIncrement();
        this._filters = filters;
        this._acquires = optionSet.contains((Object)ConsumerOption.ACQUIRES);
        this._seesRequeues = optionSet.contains((Object)ConsumerOption.SEES_REQUEUES);
        this._isTransient = optionSet.contains((Object)ConsumerOption.TRANSIENT);
        this._target = target;
        this._queue = queue;
        this._linkName = consumerName;
        this.authorise(Operation.CREATE);
        this.open();
        this.setupLogging();
    }

    private static Map<String, Object> createAttributeMap(AMQPSession<?, ?> session, String linkName, FilterManager filters, EnumSet<ConsumerOption> optionSet, Integer priority) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("id", UUID.randomUUID());
        String name = session.getAMQPConnection().getConnectionId() + "|" + session.getChannelId() + "|" + linkName;
        attributes.put("name", name);
        attributes.put("exclusive", optionSet.contains((Object)ConsumerOption.EXCLUSIVE));
        attributes.put("noLocal", optionSet.contains((Object)ConsumerOption.NO_LOCAL));
        attributes.put("distributionMode", optionSet.contains((Object)ConsumerOption.ACQUIRES) ? "MOVE" : "COPY");
        attributes.put("durable", optionSet.contains((Object)ConsumerOption.DURABLE));
        attributes.put("lifetimePolicy", (Object)LifetimePolicy.DELETE_ON_SESSION_END);
        if (priority != null) {
            attributes.put("priority", priority);
        }
        if (filters != null) {
            Iterator<MessageFilter> iter = filters.filters();
            while (iter.hasNext()) {
                MessageFilter filter = iter.next();
                if (!(filter instanceof JMSSelectorFilter)) continue;
                attributes.put("selector", ((JMSSelectorFilter)filter).getSelector());
                break;
            }
        }
        return attributes;
    }

    @Override
    public T getTarget() {
        return this._target;
    }

    @Override
    public String getLinkName() {
        return this._linkName;
    }

    @Override
    public void awaitCredit(QueueEntry node) {
        this._waitingOnCreditMessageListener.update(node);
    }

    @Override
    public boolean isNotifyWorkDesired() {
        return !this.isNonLive() && this._target.isNotifyWorkDesired();
    }

    @Override
    public void externalStateChange() {
        this._target.notifyWork();
    }

    @Override
    public long getUnacknowledgedBytes() {
        return this._target.getUnacknowledgedBytes();
    }

    @Override
    public long getUnacknowledgedMessages() {
        return this._target.getUnacknowledgedMessages();
    }

    @Override
    public AMQPSession<?, ?> getSession() {
        return this._target.getSession();
    }

    @Override
    public Object getIdentifier() {
        return this.getConsumerNumber();
    }

    @Override
    public boolean isSuspended() {
        return this._target.isSuspended();
    }

    @Override
    protected CompletableFuture<Void> onClose() {
        if (this._closed.compareAndSet(false, true)) {
            this.getEventLogger().message(this.getLogSubject(), SubscriptionMessages.CLOSE());
            this._waitingOnCreditMessageListener.remove();
            return ((CompletableFuture)this._target.consumerRemoved(this).thenRunAsync(() -> this._queue.unregisterConsumer(this), this.getTaskExecutor())).thenRunAsync(() -> this.deleteNoChecks(), this.getTaskExecutor());
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    @Override
    public void flushBatched() {
        this._target.flushBatched();
    }

    @Override
    public void notifyWork() {
        this._target.notifyWork();
    }

    @Override
    public void setQueueConsumerNode(QueueConsumerNode node) {
        this._queueConsumerNode = node;
    }

    @Override
    public QueueConsumerNode getQueueConsumerNode() {
        return this._queueConsumerNode;
    }

    @Override
    public void queueDeleted() {
        this._target.queueDeleted(this.getQueue(), this);
    }

    @Override
    public boolean allocateCredit(QueueEntry msg) {
        return this._target.allocateCredit(msg.getMessage());
    }

    @Override
    public void restoreCredit(QueueEntry queueEntry) {
        this._target.restoreCredit(queueEntry.getMessage());
    }

    @Override
    public void noMessagesAvailable() {
        this._target.noMessagesAvailable();
    }

    @Override
    protected void logOperation(String operation) {
        this.getEventLogger().message(SubscriptionMessages.OPERATION(operation));
    }

    @Override
    public final Queue<?> getQueue() {
        return this._queue;
    }

    private void setupLogging() {
        String filterLogString = this.getFilterLogString();
        this.getEventLogger().message(this, SubscriptionMessages.CREATE(filterLogString, this._queue.isDurable() && this._exclusive, filterLogString.length() > 0));
    }

    protected final LogSubject getLogSubject() {
        return this;
    }

    @Override
    public MessageContainer pullMessage() {
        MessageContainer messageContainer = this._queue.deliverSingleMessage(this);
        if (messageContainer != null) {
            this._deliveredCount.incrementAndGet();
            this._deliveredBytes.addAndGet(messageContainer.getMessageInstance().getMessage().getSizeIncludingHeader());
        }
        return messageContainer;
    }

    @Override
    public void setNotifyWorkDesired(boolean desired) {
        this._queue.setNotifyWorkDesired(this, desired);
    }

    @Override
    public final long getConsumerNumber() {
        return this._consumerNumber;
    }

    @Override
    public final QueueContext getQueueContext() {
        return this._queueContext;
    }

    final void setQueueContext(QueueContext queueContext) {
        this._queueContext = queueContext;
    }

    @Override
    public final boolean isActive() {
        return this._target.getState() == ConsumerTarget.State.OPEN;
    }

    @Override
    public final boolean isClosed() {
        return this._target.getState() == ConsumerTarget.State.CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasInterest(QueueEntry entry) {
        Object connectionRef;
        if (entry.isRejectedBy(this) || entry.checkHeld(System.currentTimeMillis())) {
            return false;
        }
        if (entry.getMessage().getClass() == this._messageClass ? this._noLocal && (connectionRef = entry.getMessage().getConnectionReference()) != null && connectionRef == this._sessionReference : this._messageClass != null && MessageConverterRegistry.getConverter(entry.getMessage().getClass(), this._messageClass) == null) {
            return false;
        }
        if (this._filters == null) {
            return true;
        }
        MessageReference ref = entry.newMessageReference();
        if (ref != null) {
            try {
                Filterable msg = entry.asFilterable();
                try {
                    boolean bl = this._filters.allAllow(msg);
                    return bl;
                }
                catch (SelectorParsingException e) {
                    LOGGER.info(String.valueOf(this) + " could not evaluate filter [" + String.valueOf(this._filters) + "]  against message " + String.valueOf(msg) + ". Error was : " + e.getMessage());
                    boolean bl = false;
                    ref.release();
                    return bl;
                }
            }
            finally {
                ref.release();
            }
        }
        return false;
    }

    protected String getFilterLogString() {
        StringBuilder filterLogString = new StringBuilder();
        String delimiter = ", ";
        boolean hasEntries = false;
        if (this._filters != null && this._filters.hasFilters()) {
            filterLogString.append(this._filters.toString());
            hasEntries = true;
        }
        if (!this.acquires()) {
            if (hasEntries) {
                filterLogString.append(delimiter);
            }
            filterLogString.append("Browser");
        }
        return filterLogString.toString();
    }

    public final long getCreateTime() {
        return this._createTime;
    }

    @Override
    public final MessageInstance.StealableConsumerAcquiredState<QueueConsumerImpl<T>> getOwningState() {
        return this._owningState;
    }

    @Override
    public final boolean acquires() {
        return this._acquires;
    }

    @Override
    public final boolean seesRequeues() {
        return this._seesRequeues;
    }

    public final boolean isTransient() {
        return this._isTransient;
    }

    @Override
    public final long getBytesOut() {
        return this._deliveredBytes.longValue();
    }

    @Override
    public final long getMessagesOut() {
        return this._deliveredCount.longValue();
    }

    @Override
    public void resetStatistics() {
        this._deliveredBytes.set(0L);
        this._deliveredCount.set(0L);
        this._target.resetStatistics();
    }

    @Override
    public void acquisitionRemoved(QueueEntry node) {
        this._target.acquisitionRemoved(node);
    }

    @Override
    public String getDistributionMode() {
        return this._distributionMode;
    }

    @Override
    public String getSettlementMode() {
        return this._settlementMode;
    }

    @Override
    public boolean isExclusive() {
        return this._exclusive;
    }

    @Override
    public boolean isNoLocal() {
        return this._noLocal;
    }

    @Override
    public String getSelector() {
        return this._selector;
    }

    @Override
    public boolean isNonLive() {
        return this._nonLive;
    }

    public void setNonLive(boolean nonLive) {
        this._nonLive = nonLive;
    }

    @Override
    public String toLogString() {
        String logString;
        if (this._queue == null) {
            logString = "[" + MessageFormat.format("sub:{0}", this.getConsumerNumber()) + "(UNKNOWN)] ";
        } else {
            String queueString = new QueueLogSubject(this.getName(), this.getName()).toLogString();
            logString = "[" + MessageFormat.format("sub:{0}", this.getConsumerNumber()) + "(" + queueString.substring(1, queueString.length() - 3) + ")] ";
        }
        return logString;
    }

    private EventLogger getEventLogger() {
        return this._queue.getEventLogger();
    }

    @Override
    protected void logCreated(Map<String, Object> attributes, Outcome outcome) {
        LOGGER.debug("{} : {} ({}) : Create : {}", new Object[]{LogMessage.getActor(), this.getCategoryClass().getSimpleName(), this.getName(), outcome});
    }

    @Override
    protected void logDeleted(Outcome outcome) {
        LOGGER.debug("{} : {} ({}) : Delete : {}", new Object[]{LogMessage.getActor(), this.getCategoryClass().getSimpleName(), this.getName(), outcome});
    }

    public class WaitingOnCreditMessageListener
    implements StateChangeListener<MessageInstance, MessageInstance.EntryState> {
        private final AtomicReference<MessageInstance> _entry = new AtomicReference();

        public void update(MessageInstance entry) {
            this.remove();
            this._entry.set(entry);
            entry.addStateChangeListener(this);
            if (!entry.isAvailable()) {
                QueueConsumerImpl.this._target.notifyWork();
                this.remove();
            }
        }

        public void remove() {
            MessageInstance instance = this._entry.getAndSet(null);
            if (instance != null) {
                instance.removeStateChangeListener(this);
            }
        }

        @Override
        public void stateChanged(MessageInstance entry, MessageInstance.EntryState oldState, MessageInstance.EntryState newState) {
            entry.removeStateChangeListener(this);
            this._entry.compareAndSet(entry, null);
            QueueConsumerImpl.this._target.notifyWork();
        }
    }
}

