/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Map;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.queue.OutOfOrderQueue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.SortedQueue;
import org.apache.qpid.server.queue.SortedQueueEntryList;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

public class SortedQueueImpl
extends OutOfOrderQueue<SortedQueueImpl>
implements SortedQueue<SortedQueueImpl> {
    private final Object _sortedQueueLock = new Object();
    @ManagedAttributeField
    private String _sortKey;
    private SortedQueueEntryList _entries;

    @ManagedObjectFactoryConstructor
    public SortedQueueImpl(Map<String, Object> attributes, QueueManagingVirtualHost<?> virtualHost) {
        super(attributes, virtualHost);
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this._entries = new SortedQueueEntryList(this, this.getQueueStatistics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected QueueEntry doEnqueue(ServerMessage message, Action<? super MessageInstance> action, MessageEnqueueRecord record) {
        Object object = this._sortedQueueLock;
        synchronized (object) {
            return super.doEnqueue(message, action, record);
        }
    }

    @Override
    SortedQueueEntryList getEntries() {
        return this._entries;
    }

    @Override
    public String getSortKey() {
        return this._sortKey;
    }
}

