/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.stats;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.util.Strings;

public class FormattingStatisticsResolver
implements Strings.Resolver {
    private final Map<String, Object> _statistics;
    static final String BYTEUNIT = "byteunit";
    static final String DURATION = "duration";
    static final String DATETIME = "datetime";

    FormattingStatisticsResolver(ConfiguredObject<?> object) {
        this._statistics = object.getStatistics();
    }

    @Override
    public String resolve(String statNameWithFormatSpecifier, Strings.Resolver unused) {
        String[] split = statNameWithFormatSpecifier.split(":", 2);
        String statName = split[0];
        Object statisticValue = this._statistics.get(statName);
        if (split.length > 1) {
            String formatterName = split[1].toLowerCase();
            if (statisticValue instanceof Number) {
                long value = ((Number)statisticValue).longValue();
                switch (formatterName.toLowerCase()) {
                    case "byteunit": {
                        statisticValue = FormattingStatisticsResolver.toIEC80000BinaryPrefixedValue(value);
                        break;
                    }
                    case "duration": {
                        statisticValue = value < 0L ? "-" : Duration.ofMillis(value);
                        break;
                    }
                    case "datetime": {
                        statisticValue = value < 0L ? "-" : Instant.ofEpochMilli(value).toString();
                    }
                }
            } else if (statisticValue instanceof Date) {
                switch (formatterName.toLowerCase()) {
                    case "datetime": {
                        long time = ((Date)statisticValue).getTime();
                        statisticValue = time < 0L ? "-" : Instant.ofEpochMilli(time).toString();
                    }
                }
            }
        }
        return statisticValue == null ? null : String.valueOf(statisticValue);
    }

    private static String toIEC80000BinaryPrefixedValue(long value) {
        if (value > -1023L && value < 1024L) {
            return value + " B";
        }
        int exp = (int)(Math.log(Math.abs(value)) / Math.log(1024.0));
        char binaryPrefixInitialChar = "KMGTPEZY".charAt(exp - 1);
        return String.format("%.1f %siB", (double)value / Math.pow(1024.0, exp), Character.valueOf(binaryPrefixInitialChar));
    }
}

