/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.center.client;

import com.google.common.eventbus.EventBus;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.config.center.client.ConfigCenterAddressManager;
import org.apache.servicecomb.config.center.client.ConfigCenterClient;
import org.apache.servicecomb.config.center.client.model.ConfigCenterConfiguration;
import org.apache.servicecomb.config.center.client.model.QueryConfigurationsRequest;
import org.apache.servicecomb.config.center.client.model.QueryConfigurationsResponse;
import org.apache.servicecomb.config.common.ConfigConverter;
import org.apache.servicecomb.config.common.ConfigurationChangedEvent;
import org.apache.servicecomb.http.client.task.AbstractTask;
import org.apache.servicecomb.http.client.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCenterManager
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigCenterManager.class);
    private final ConfigCenterClient configCenterClient;
    private final EventBus eventBus;
    private QueryConfigurationsRequest queryConfigurationsRequest;
    private final ConfigConverter configConverter;
    private final ConfigCenterConfiguration configCenterConfiguration;
    private final ConfigCenterAddressManager configCenterAddressManager;

    public ConfigCenterManager(ConfigCenterClient configCenterClient, EventBus eventBus, ConfigConverter configConverter, ConfigCenterConfiguration configCenterConfiguration, ConfigCenterAddressManager configCenterAddressManager) {
        super("config-center-configuration-task");
        this.configCenterClient = configCenterClient;
        this.eventBus = eventBus;
        this.configConverter = configConverter;
        this.configCenterConfiguration = configCenterConfiguration;
        this.configCenterAddressManager = configCenterAddressManager;
    }

    public void setQueryConfigurationsRequest(QueryConfigurationsRequest queryConfigurationsRequest) {
        this.queryConfigurationsRequest = queryConfigurationsRequest;
    }

    public void startConfigCenterManager() {
        this.startTask(new PollConfigurationTask(0));
        this.schedulerCheckAddressAvailable("cc-addr-check", new CheckConfigCenterAddressTask(), this.configCenterConfiguration.getRefreshIntervalInMillis());
    }

    class PollConfigurationTask
    implements Task {
        int failCount;

        public PollConfigurationTask(int failCount) {
            this.failCount = failCount;
        }

        public void execute() {
            try {
                QueryConfigurationsResponse response = ConfigCenterManager.this.configCenterClient.queryConfigurations(ConfigCenterManager.this.queryConfigurationsRequest, ConfigCenterManager.this.configCenterAddressManager.address());
                if (response.isChanged()) {
                    ConfigCenterManager.this.queryConfigurationsRequest.setRevision(response.getRevision());
                    Map lastData = ConfigCenterManager.this.configConverter.updateData(response.getConfigurations());
                    ConfigurationChangedEvent event = ConfigurationChangedEvent.createIncremental((Map)ConfigCenterManager.this.configConverter.getCurrentData(), (Map)lastData);
                    ConfigCenterManager.this.eventBus.post((Object)event);
                }
                ConfigCenterManager.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ConfigCenterManager.this, ConfigCenterManager.this.configCenterConfiguration.getRefreshIntervalInMillis(), (Task)new PollConfigurationTask(0)));
            }
            catch (Exception e) {
                LOGGER.warn("get configurations from ConfigCenter failed, and will try again, cause message: {}. current fail does not affect the obtained historical configuration.", (Object)e.getMessage());
                ConfigCenterManager.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)ConfigCenterManager.this, this.failCount + 1, (Task)new PollConfigurationTask(this.failCount + 1)));
            }
        }
    }

    class CheckConfigCenterAddressTask
    implements Runnable {
        CheckConfigCenterAddressTask() {
        }

        @Override
        public void run() {
            List isolationAddresses = ConfigCenterManager.this.configCenterAddressManager.getIsolationAddresses();
            if (isolationAddresses.isEmpty()) {
                return;
            }
            for (String address : isolationAddresses) {
                ConfigCenterManager.this.configCenterClient.checkAddressAvailable(address);
            }
        }
    }
}

