/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client;

import io.vertx.core.Vertx;
import java.util.List;
import org.apache.servicecomb.common.rest.filter.HttpClientFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClients;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.transport.rest.client.http.RestClientInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestTransportClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTransportClient.class);
    private List<HttpClientFilter> httpClientFilters;

    public void init(Vertx vertx) throws Exception {
        this.httpClientFilters = SPIServiceUtils.getSortedService(HttpClientFilter.class);
    }

    public void send(Invocation invocation, AsyncResponse asyncResp) {
        HttpClientWithContext httpClientWithContext = this.findHttpClientPool(invocation);
        RestClientInvocation restClientInvocation = new RestClientInvocation(httpClientWithContext, this.httpClientFilters);
        try {
            restClientInvocation.invoke(invocation, asyncResp);
        }
        catch (Throwable e) {
            asyncResp.fail(invocation.getInvocationType(), e);
            LOGGER.error("vertx rest transport send error.", e);
        }
    }

    protected HttpClientWithContext findHttpClientPool(Invocation invocation) {
        URIEndpointObject endpoint = (URIEndpointObject)invocation.getEndpoint().getAddress();
        HttpClientWithContext httpClientWithContext = endpoint.isHttp2Enabled() ? HttpClients.getClient((String)"http2-transport-client", (boolean)invocation.isSync()) : HttpClients.getClient((String)"http-transport-client", (boolean)invocation.isSync());
        return httpClientWithContext;
    }
}

