/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.extent.AbstractGeographicExtent;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.GeographicDescription;
import org.opengis.metadata.extent.GeographicExtent;

@XmlType(name="EX_GeographicDescription_Type")
@XmlRootElement(name="EX_GeographicDescription")
public class DefaultGeographicDescription
extends AbstractGeographicExtent
implements GeographicDescription {
    private static final long serialVersionUID = 7876194854687370299L;
    private Identifier geographicIdentifier;

    public DefaultGeographicDescription() {
    }

    public DefaultGeographicDescription(Identifier value) {
        this.geographicIdentifier = value;
    }

    public DefaultGeographicDescription(Citation authority, String code) {
        super(true);
        if (authority != null || code != null) {
            this.geographicIdentifier = new DefaultIdentifier(authority, code);
        }
    }

    public DefaultGeographicDescription(GeographicDescription object) {
        super((GeographicExtent)object);
        if (object != null) {
            this.geographicIdentifier = object.getGeographicIdentifier();
        }
    }

    public static DefaultGeographicDescription castOrCopy(GeographicDescription object) {
        if (object == null || object instanceof DefaultGeographicDescription) {
            return (DefaultGeographicDescription)object;
        }
        return new DefaultGeographicDescription(object);
    }

    @XmlElement(name="geographicIdentifier", required=true)
    public Identifier getGeographicIdentifier() {
        return this.geographicIdentifier;
    }

    public void setGeographicIdentifier(Identifier newValue) {
        this.checkWritePermission(this.geographicIdentifier);
        this.geographicIdentifier = newValue;
    }
}

