/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.filter.InvalidXPathException;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

public final class XPath {
    public static final char SEPARATOR = '/';
    private static final char BRACED_URI_PREFIX = 'Q';
    private static final char OPEN = '{';
    private static final char CLOSE = '}';
    public List<String> path;
    public String tip;
    public boolean isAbsolute;

    private XPath() {
    }

    public XPath(String xpath) {
        String namespace;
        int length = xpath.length();
        int start = CharSequences.skipLeadingWhitespaces((CharSequence)xpath, (int)0, (int)length);
        if (start >= length) {
            throw new IllegalArgumentException(Errors.format((short)44, (Object)"xpath"));
        }
        if (xpath.charAt(start) == '/') {
            start = CharSequences.skipLeadingWhitespaces((CharSequence)xpath, (int)(start + 1), (int)length);
            this.isAbsolute = true;
        }
        while (true) {
            int next;
            namespace = null;
            int open = xpath.indexOf(123, start);
            if (open >= 0) {
                int close;
                int before = CharSequences.skipLeadingWhitespaces((CharSequence)xpath, (int)start, (int)open);
                if (before != open && (before != open - 1 || xpath.charAt(before) != 'Q')) {
                    throw new IllegalArgumentException(Errors.format((short)201, (Object)xpath.substring(before)));
                }
                if ((close = xpath.indexOf(125, ++open)) < 0) {
                    throw new IllegalArgumentException(Errors.format((short)105, (Object)xpath.substring(before), (Object)Character.valueOf('}')));
                }
                namespace = CharSequences.trimWhitespaces((CharSequence)xpath, (int)open, (int)close).toString();
                if (namespace.indexOf(123) >= 0) {
                    throw new IllegalArgumentException(Errors.format((short)63, (Object)namespace, (Object)Character.valueOf('{')));
                }
                start = close + 1;
            }
            if ((next = xpath.indexOf(47, start)) < 0) break;
            if (this.path == null) {
                this.path = new ArrayList<String>(4);
            }
            this.path.add(XPath.toQualifiedName(namespace, xpath, start, next));
            start = next + 1;
        }
        this.tip = XPath.toQualifiedName(namespace, xpath, start, length);
        if (this.tip.isEmpty() || this.path != null && this.path.stream().anyMatch(String::isEmpty)) {
            throw new IllegalArgumentException(Errors.format((short)201, (Object)xpath));
        }
    }

    private static String toQualifiedName(String namespace, String xpath, int start, int end) {
        Object name = CharSequences.trimWhitespaces((CharSequence)xpath, (int)start, (int)end).toString();
        if (namespace != null) {
            name = namespace + ":" + (String)name;
        }
        return name;
    }

    private static StringBuilder toBracedURI(String component, StringBuilder sb) {
        int end = component.lastIndexOf(58);
        if (end >= 0 && component.lastIndexOf(47, end) >= 0) {
            return sb.append('Q').append('{').append(component, 0, end).append('}').append(component, end + 1, component.length());
        }
        return sb.append(component);
    }

    private StringBuilder toString(StringBuilder sb) {
        if (this.isAbsolute) {
            sb.append('/');
        }
        if (this.path != null) {
            for (String component : this.path) {
                XPath.toBracedURI(component, sb).append('/');
            }
        }
        return XPath.toBracedURI(this.tip, sb);
    }

    public String toString() {
        if (!this.isAbsolute && this.path == null && this.tip.indexOf(47) < 0) {
            return this.tip;
        }
        return this.toString(new StringBuilder(this.tip.length() + 10)).toString();
    }

    public static String toString(String prefix, String[] path, String tip) {
        XPath x = new XPath();
        if (path != null) {
            x.path = Arrays.asList(path);
        }
        x.tip = tip;
        if (prefix != null) {
            return x.toString(new StringBuilder(tip.length() + 10).append(prefix)).toString();
        }
        return x.toString();
    }

    public static String fromPropertyName(String name) {
        return XPath.toString(null, null, name);
    }

    public static String toPropertyName(String xpath) {
        XPath x = new XPath(xpath);
        if (x.path == null) {
            return x.tip;
        }
        throw new InvalidXPathException(Resources.format((short)89, xpath));
    }
}

