/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.util;

import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.validation.ConstraintTarget;
import jakarta.validation.Payload;
import jakarta.validation.Valid;
import jakarta.validation.ValidationException;
import jakarta.validation.groups.ConvertGroup;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.apache.bval.cdi.EmptyAnnotationLiteral;
import org.apache.bval.jsr.ConstraintAnnotationAttributes;
import org.apache.bval.jsr.util.AnnotationProxy;
import org.apache.bval.jsr.util.AnnotationsManager;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
public final class AnnotationProxyBuilder<A extends Annotation> {
    private final Class<A> type;
    private final Map<String, Object> elements = new HashMap<String, Object>();
    private final Method[] methods;
    private boolean changed;

    AnnotationProxyBuilder(Class<A> annotationType, ConcurrentMap<Class<?>, Method[]> cache) {
        this.type = Validate.notNull(annotationType, "annotationType", new Object[0]);
        this.methods = Validate.notNull(cache, "cache", new Object[0]).computeIfAbsent(annotationType, Reflection::getDeclaredMethods);
    }

    AnnotationProxyBuilder(A annot, ConcurrentMap<Class<?>, Method[]> cache) {
        this(annot.annotationType(), cache);
        this.elements.putAll(AnnotationsManager.readAttributes(annot));
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public boolean setValue(String elementName, Object value) {
        boolean result = !Objects.equals(this.elements.put(elementName, value), value);
        this.changed |= result;
        return result;
    }

    public Object getValue(String elementName) {
        return this.elements.get(elementName);
    }

    public boolean contains(String elementName) {
        return this.elements.containsKey(elementName);
    }

    public int size() {
        return this.elements.size();
    }

    public Class<A> getType() {
        return this.type;
    }

    public boolean setMessage(String message) {
        return this.setValue(ConstraintAnnotationAttributes.MESSAGE.getAttributeName(), message);
    }

    public boolean setGroups(Class<?>[] groups) {
        return this.setValue(ConstraintAnnotationAttributes.GROUPS.getAttributeName(), groups);
    }

    public boolean setPayload(Class<? extends Payload>[] payload) {
        return this.setValue(ConstraintAnnotationAttributes.PAYLOAD.getAttributeName(), payload);
    }

    public boolean setValidationAppliesTo(ConstraintTarget constraintTarget) {
        return this.setValue(ConstraintAnnotationAttributes.VALIDATION_APPLIES_TO.getAttributeName(), constraintTarget);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public A createAnnotation() {
        ClassLoader classLoader = Reflection.loaderFromClassOrThread(this.getType());
        Class<?> proxyClass = Proxy.getProxyClass(classLoader, this.getType());
        return (A)this.doCreateAnnotation(proxyClass, new AnnotationProxy(this));
    }

    @Privileged
    private A doCreateAnnotation(Class<A> proxyClass, InvocationHandler handler) {
        try {
            Constructor<A> constructor = proxyClass.getConstructor(InvocationHandler.class);
            Reflection.makeAccessible(constructor);
            return (A)((Annotation)constructor.newInstance(handler));
        }
        catch (Exception e) {
            throw new ValidationException("Unable to create annotation for configured constraint", (Throwable)e);
        }
    }

    public static final class ConvertGroupAnnotation
    extends AnnotationLiteral<ConvertGroup>
    implements ConvertGroup {
        private static final long serialVersionUID = 1L;
        private final Class<?> from;
        private final Class<?> to;

        public ConvertGroupAnnotation(Class<?> from, Class<?> to) {
            this.from = from;
            this.to = to;
        }

        public Class<?> from() {
            return this.from;
        }

        public Class<?> to() {
            return this.to;
        }
    }

    public static final class ValidAnnotation
    extends EmptyAnnotationLiteral<Valid>
    implements Valid {
        private static final long serialVersionUID = 1L;
        public static final ValidAnnotation INSTANCE = new ValidAnnotation();
    }
}

