/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.Name;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class Global {
    private Name name;
    private int index;
    private static Global[] allGlobals = new Global[0];
    private static Map<String, Global> globalsByName = new HashMap<String, Global>();
    private static Map<String, Global> globalsByCanonicName = new HashMap<String, Global>();
    public static final Global ground = Global.newGlobal("gnd");
    public static final Global power = Global.newGlobal("vdd");

    private Global(Name name) {
        this.name = name;
        this.index = allGlobals.length;
        Global[] newGlobals = new Global[this.index + 1];
        for (int i = 0; i < this.index; ++i) {
            newGlobals[i] = allGlobals[i];
        }
        newGlobals[this.index] = this;
        allGlobals = newGlobals;
        globalsByName.put(name.toString(), this);
        if (globalsByCanonicName.containsKey(name.canonicString())) {
            System.out.println("!!! " + globalsByCanonicName.get(name.canonicString()) + " and " + this + " are not connected now !!!");
        }
        globalsByCanonicName.put(name.canonicString(), this);
    }

    public String getName() {
        return this.name.toString();
    }

    public Name getNameKey() {
        return this.name;
    }

    public String toString() {
        return "Global " + this.name;
    }

    public static Global newGlobal(String name) {
        Name nameKey = Name.findName(name);
        Global g = globalsByName.get(nameKey.toString());
        if (g == null) {
            g = new Global(nameKey);
        }
        return g;
    }

    public static class Buf {
        private PortCharacteristic[] buf = new PortCharacteristic[Global.access$000().length];

        Buf() {
        }

        Buf(Set set) {
            this.buf = (PortCharacteristic[])set.elemMap.clone();
        }

        String addToBuf(Global g, PortCharacteristic characteristic) {
            PortCharacteristic oldCharacteristic;
            String errorMsg = null;
            if (this.buf.length <= g.index) {
                PortCharacteristic[] newBuf = new PortCharacteristic[g.index + 1];
                System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
                this.buf = newBuf;
            }
            if ((oldCharacteristic = this.buf[g.index]) == null) {
                this.buf[((Global)g).index] = characteristic;
            } else if (oldCharacteristic != characteristic) {
                errorMsg = g.getName() + "(" + oldCharacteristic.getName() + "->" + characteristic.getName() + ")";
            }
            return errorMsg;
        }

        String addToBuf(Set set) {
            String errorMsg = null;
            for (int i = 0; i < set.elems.length; ++i) {
                int index = set.elems[i].index;
                String msg = this.addToBuf(allGlobals[index], set.elemMap[index]);
                if (msg == null) continue;
                if (errorMsg != null) {
                    errorMsg = errorMsg + " ";
                }
                errorMsg = errorMsg + msg;
            }
            return errorMsg;
        }

        Set getBuf() {
            return Set.newSet(this.buf);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Set
    implements Comparable<Set> {
        private PortCharacteristic[] elemMap;
        private Global[] elems;
        private int[] indexOf;
        private static Map<Set, Set> allSets = new TreeMap<Set, Set>();
        private static Set fakeSet = new Set(new PortCharacteristic[0]);
        public static final Set empty = Set.newSet(new PortCharacteristic[0]);

        private Set(PortCharacteristic[] elemMap) {
            int maxElem = -1;
            int numElem = 0;
            for (int i = 0; i < elemMap.length; ++i) {
                if (elemMap[i] == null) continue;
                maxElem = i;
                ++numElem;
            }
            this.elemMap = new PortCharacteristic[maxElem + 1];
            this.elems = new Global[numElem];
            this.indexOf = new int[maxElem + 1];
            Arrays.fill(this.indexOf, -1);
            int local = 0;
            for (int i = 0; i < elemMap.length; ++i) {
                if (elemMap[i] == null) continue;
                this.elemMap[i] = elemMap[i];
                this.elems[local] = allGlobals[i];
                this.indexOf[i] = local++;
            }
        }

        public final boolean contains(Global global) {
            return global.index < this.elemMap.length && this.elemMap[global.index] != null;
        }

        public PortCharacteristic getCharacteristic(Global global) {
            return global.index < this.elemMap.length ? this.elemMap[global.index] : null;
        }

        public final int size() {
            return this.elems.length;
        }

        public final Global get(int i) {
            return this.elems[i];
        }

        public final int indexOf(Global g) {
            return g.index < this.indexOf.length ? this.indexOf[g.index] : -1;
        }

        public final int maxElement() {
            return this.elemMap.length - 1;
        }

        @Override
        public int compareTo(Set set) {
            int i;
            int minLen = Math.min(this.elemMap.length, set.elemMap.length);
            for (i = 0; i < minLen && this.elemMap[i] == set.elemMap[i]; ++i) {
            }
            if (i < minLen) {
                if (this.elemMap[i] == null) {
                    return -1;
                }
                if (set.elemMap[i] == null) {
                    return 1;
                }
                return this.elemMap[i].getOrder() - set.elemMap[i].getOrder();
            }
            while (i < this.elemMap.length) {
                if (this.elemMap[i] != null) {
                    return 1;
                }
                ++i;
            }
            while (i < set.elemMap.length) {
                if (set.elemMap[i] != null) {
                    return -1;
                }
                ++i;
            }
            return 0;
        }

        public String toString() {
            String s = "Global.Set {";
            for (int i = 0; i < this.elemMap.length; ++i) {
                if (this.elemMap[i] == null) continue;
                s = s + " " + allGlobals[i] + ":" + this.elemMap[i].getName();
            }
            s = s + "}";
            return s;
        }

        public Set remove(Iterator<Global> gs) {
            Buf buf = new Buf(this);
            while (gs.hasNext()) {
                Global g = gs.next();
                if (g.index >= buf.buf.length) continue;
                ((Buf)buf).buf[((Global)g).index] = null;
            }
            return buf.getBuf();
        }

        private static Set newSet(PortCharacteristic[] elemMap) {
            Set.fakeSet.elemMap = elemMap;
            Set set = allSets.get(fakeSet);
            Set.fakeSet.elemMap = null;
            if (set == null) {
                set = new Set(elemMap);
                allSets.put(set, set);
            }
            return set;
        }
    }
}

