/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.CellTree;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.network.NetCell;
import com.sun.electric.database.network.NetSchem;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.Name;
import com.sun.electric.util.TextUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;

public class NetlistImpl
extends Netlist {
    private static final String[] NULL_STRING_ARRAY = new String[0];
    private String[][] names;
    private BitSet isUsernamed = new BitSet();
    private int[] exportedNamesCount;
    private int[] equivPortIndexByNetIndex;

    NetlistImpl(NetCell netCell, int numExternals, int[] map2) {
        super(netCell, Netlist.ShortResistors.NO, numExternals, map2);
        if (netCell instanceof NetSchem) {
            this.expectedSnapshot = new WeakReference<Snapshot>(netCell.database.backup());
        } else {
            this.expectedCellTree = new WeakReference<CellTree>(netCell.cell.tree());
        }
        this.exportedNamesCount = new int[this.numExternalNets];
        this.equivPortIndexByNetIndex = new int[this.numExternalNets];
        Arrays.fill(this.equivPortIndexByNetIndex, -1);
        this.names = new String[this.getNumNetworks()][];
        Arrays.fill((Object[])this.names, NULL_STRING_ARRAY);
    }

    void setEquivPortIndexByNetIndex(int equivIndex, int netIndex) {
        this.equivPortIndexByNetIndex[netIndex] = equivIndex;
    }

    @Override
    Iterator<String> getNames(int netIndex) {
        return ArrayIterator.iterator(this.names[netIndex]);
    }

    @Override
    Iterator<String> getExportedNames(int netIndex) {
        int exportedNamesCount = netIndex < this.numExternalNets ? this.exportedNamesCount[netIndex] : 0;
        return ArrayIterator.iterator(this.names[netIndex], 0, exportedNamesCount);
    }

    @Override
    String getName(int netIndex) {
        return this.names[netIndex][0];
    }

    @Override
    boolean hasName(int netIndex, String nm) {
        String[] theseNames = this.names[netIndex];
        for (int i = 0; i < theseNames.length; ++i) {
            if (!theseNames[i].equals(nm)) continue;
            return true;
        }
        return false;
    }

    @Override
    void fillNames(int netIndex, Collection<String> exportedNames, Collection<String> privateNames) {
        int i;
        if (!this.isUsernamed(netIndex)) {
            return;
        }
        String[] names = this.names[netIndex];
        int exportedNamesCount = netIndex < this.numExternalNets ? this.exportedNamesCount[netIndex] : 0;
        for (i = 0; i < exportedNamesCount; ++i) {
            exportedNames.add(names[i]);
        }
        if (privateNames != null) {
            for (i = exportedNamesCount; i < names.length; ++i) {
                privateNames.add(names[i]);
            }
        }
    }

    @Override
    boolean isUsernamed(int netIndex) {
        return this.isUsernamed.get(netIndex);
    }

    boolean hasNames(int netIndex) {
        return this.names[netIndex].length > 0;
    }

    @Override
    int getEquivPortIndexByNetIndex(int netIndex) {
        return this.equivPortIndexByNetIndex[netIndex];
    }

    void addUserName(int netIndex, Name nameKey, boolean exported) {
        int i;
        int exportedCount;
        assert (!nameKey.isTempname());
        String name = nameKey.toString();
        String[] theseNames = this.names[netIndex];
        int n = exportedCount = netIndex < this.numExternalNets ? this.exportedNamesCount[netIndex] : 0;
        if (exported) assert (exportedCount == theseNames.length);
        for (i = 0; i < theseNames.length; ++i) {
            String n2 = this.names[netIndex][i];
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(name, n2);
            if (cmp == 0) {
                return;
            }
            if (cmp < 0 && (exported || i >= exportedCount)) break;
        }
        if (theseNames.length == 0) {
            this.names[netIndex] = new String[]{name};
        } else {
            String[] newNames = new String[theseNames.length + 1];
            System.arraycopy(theseNames, 0, newNames, 0, i);
            newNames[i] = name;
            System.arraycopy(theseNames, i, newNames, i + 1, theseNames.length - i);
            this.names[netIndex] = newNames;
        }
        if (exported) {
            int n3 = netIndex;
            this.exportedNamesCount[n3] = this.exportedNamesCount[n3] + 1;
        }
        this.isUsernamed.set(netIndex);
    }

    void addTempName(int netIndex, String name) {
        assert (this.names[netIndex].length == 0);
        this.names[netIndex] = new String[]{name};
    }
}

