/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.util.TextUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Sim
extends Output {
    private Map<Integer, String> globalNetNames;
    private int globalNetVDD;
    private int globalNetGND;
    private int globalNetPhi1H;
    private int globalNetPhi1L;
    private int globalNetPhi2H;
    private int globalNetPhi2L;
    private static final Variable.Key COSMOS_ATTRIBUTE_KEY = Variable.newKey("SIM_cosmos_attribute");
    private SimPreferences localPrefs;

    Sim(SimPreferences sp2) {
        this.localPrefs = sp2;
    }

    private void init(Cell cell, String netfile, FileType format2) {
        this.globalNetNames = new HashMap<Integer, String>();
        this.printWriter.println("| Cell " + cell.describe(false));
        this.emitCopyright("| ", "");
        if (this.localPrefs.includeDateAndVersionInOutput) {
            this.printWriter.println("| Cell created " + TextUtils.formatDate(cell.getCreationDate()));
            this.printWriter.println("| Version " + cell.getVersion() + " last revised " + TextUtils.formatDate(cell.getRevisionDate()));
        }
        if (format2 == FileType.COSMOS) {
            this.printWriter.println("| [e | d | p | n] gate source drain length width xpos ypos {[gsd]=attrs}");
            this.printWriter.println("| N node D-area D-perim P-area P-perim M-area M-perim");
            this.printWriter.println("| A node attrs");
            this.printWriter.println("|  attrs = [Sim:[In | Out | 1 | 2 | 3 | Z | U]]");
        } else {
            this.printWriter.println("| [epd] gate source drain length width r xpos ypos area");
            this.printWriter.println("| N node xpos ypos M-area P-area D-area D-perim");
        }
    }

    private void writeCellContents(HierarchyEnumerator.CellInfo ci, FileType format2) {
        ArcInst ai;
        Cell cell = ci.getCell();
        Technology tech = cell.getTechnology();
        boolean top = ci.isRootCell();
        Netlist netList = ci.getNetlist();
        if (format2 == FileType.COSMOS) {
            this.printWriter.println("| cell " + cell.getName());
        }
        if (top) {
            this.globalNetPhi2L = -1;
            this.globalNetPhi2H = -1;
            this.globalNetPhi1L = -1;
            this.globalNetPhi1H = -1;
            this.globalNetGND = -1;
            this.globalNetVDD = -1;
            Iterator<PortProto> it = cell.getPorts();
            while (it.hasNext()) {
                Export e = (Export)it.next();
                Network net = netList.getNetwork(e, 0);
                int globalNetNum = ci.getNetID(net);
                this.globalNetNames.put(new Integer(globalNetNum), e.getName());
                if (e.isPower()) {
                    this.globalNetVDD = globalNetNum;
                }
                if (e.isGround()) {
                    this.globalNetGND = globalNetNum;
                }
                if (e.getCharacteristic() == PortCharacteristic.C1 || e.getName().startsWith("clk1") || e.getName().startsWith("phi1h")) {
                    this.globalNetPhi1H = globalNetNum;
                }
                if (e.getCharacteristic() == PortCharacteristic.C2 || e.getName().startsWith("phi1l")) {
                    this.globalNetPhi1L = globalNetNum;
                }
                if (e.getCharacteristic() == PortCharacteristic.C3 || e.getName().startsWith("clk2") || e.getName().startsWith("phi2h")) {
                    this.globalNetPhi2H = globalNetNum;
                }
                if (e.getCharacteristic() != PortCharacteristic.C4 && !e.getName().startsWith("phi2l")) continue;
                this.globalNetPhi2L = globalNetNum;
            }
            if (this.globalNetVDD < 0) {
                this.reportWarning("Warning: no power export in this cell");
            }
            if (this.globalNetGND < 0) {
                this.reportWarning("Warning: no ground export in this cell");
            }
        }
        HashSet<Network> netsSeen = new HashSet<Network>();
        Iterator<Geometric> it = cell.getArcs();
        while (it.hasNext()) {
            ai = it.next();
            Network net = netList.getNetwork(ai, 0);
            if (netsSeen.contains(net)) continue;
            netsSeen.add(net);
            int globalNetNum = ci.getNetID(net);
            double darea = 0.0;
            double dperim = 0.0;
            double parea = 0.0;
            double pperim = 0.0;
            double marea = 0.0;
            double mperim = 0.0;
            Iterator<ArcInst> oIt = cell.getArcs();
            while (oIt.hasNext()) {
                ArcProto.Function fun;
                ArcInst oAi = oIt.next();
                Network oNet = netList.getNetwork(oAi, 0);
                if (oNet != net) continue;
                double width = oAi.getLambdaBaseWidth();
                double length = oAi.getLambdaLength();
                if (oAi.isHeadExtended()) {
                    length += width / 2.0;
                }
                if (oAi.isTailExtended()) {
                    length += width / 2.0;
                }
                if (format2 != FileType.COSMOS) {
                    width = TextUtils.convertDistance(width, tech, TextUtils.UnitScale.MICRO);
                    length = TextUtils.convertDistance(length, tech, TextUtils.UnitScale.MICRO);
                }
                if ((fun = oAi.getProto().getFunction()).isMetal()) {
                    marea += length * width;
                    mperim += 2.0 * (length + width);
                    continue;
                }
                if (fun.isPoly()) {
                    parea += length * width;
                    pperim += 2.0 * (length + width);
                    continue;
                }
                if (!fun.isDiffusion()) continue;
                darea += length * width;
                dperim += 2.0 * (length + width);
            }
            if (globalNetNum == this.globalNetVDD || globalNetNum == this.globalNetGND || marea == 0.0 && parea == 0.0 && darea == 0.0) continue;
            if (format2 == FileType.COSMOS) {
                this.printWriter.println("N " + this.makeNodeName(globalNetNum, format2) + " " + TextUtils.formatDouble(darea) + " " + TextUtils.formatDouble(dperim) + " " + TextUtils.formatDouble(parea) + " " + TextUtils.formatDouble(pperim) + " " + TextUtils.formatDouble(marea) + " " + TextUtils.formatDouble(mperim));
                continue;
            }
            this.printWriter.println("N " + this.makeNodeName(globalNetNum, format2) + " 0 0 " + TextUtils.formatDouble(marea) + " " + TextUtils.formatDouble(parea) + " " + TextUtils.formatDouble(darea) + " " + TextUtils.formatDouble(dperim));
        }
        if (format2 == FileType.COSMOS) {
            it = cell.getArcs();
            while (it.hasNext()) {
                ai = (ArcInst)it.next();
                Variable var = ai.getVar(COSMOS_ATTRIBUTE_KEY);
                if (var == null) continue;
                Network net = netList.getNetwork(ai, 0);
                int globalNetNum = ci.getNetID(net);
                this.printWriter.println("A " + this.makeNodeName(globalNetNum, format2) + " Sim:" + var.getPureValue(-1));
            }
        }
        it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            PrimitiveNode.Function fun = ni.getFunction();
            if (!fun.isFET()) continue;
            Network gateNet = netList.getNetwork(ni.getTransistorGatePort());
            int gate = ci.getNetID(gateNet);
            Network sourceNet = netList.getNetwork(ni.getTransistorSourcePort());
            int source = ci.getNetID(sourceNet);
            Network drainNet = netList.getNetwork(ni.getTransistorDrainPort());
            int drain = ci.getNetID(drainNet);
            String tType = "U";
            tType = fun.isNTypeTransistor() ? "e" : (fun.isPTypeTransistor() ? "p" : "d");
            TransistorSize size2 = ni.getTransistorSize(ci.getContext());
            double length = 0.0;
            double width = 0.0;
            if (size2.getDoubleWidth() > 0.0) {
                width = size2.getDoubleWidth();
            }
            if (size2.getDoubleLength() > 0.0) {
                length = size2.getDoubleLength();
            }
            if (format2 == FileType.COSMOS) {
                String extra = "";
                Variable var = ni.getVar(COSMOS_ATTRIBUTE_KEY);
                if (var != null) {
                    extra = " g=Sim:" + var.getPureValue(-1);
                }
                extra = extra + " " + TextUtils.formatDouble(ni.getAnchorCenterX()) + " " + TextUtils.formatDouble(ni.getAnchorCenterY());
                this.printWriter.println(tType + " " + this.makeNodeName(gate, format2) + " " + this.makeNodeName(source, format2) + " " + this.makeNodeName(drain, format2) + " " + TextUtils.formatDouble(length) + " " + TextUtils.formatDouble(width) + extra);
                this.printWriter.println("N " + this.makeNodeName(source, format2) + " " + TextUtils.formatDouble(length * width) + " " + TextUtils.formatDouble(width) + " 0 0 0 0");
                this.printWriter.println("N " + this.makeNodeName(drain, format2) + " " + TextUtils.formatDouble(length * width) + " " + TextUtils.formatDouble(width) + " 0 0 0 0");
                continue;
            }
            width = TextUtils.convertDistance(width, tech, TextUtils.UnitScale.MICRO);
            length = TextUtils.convertDistance(length, tech, TextUtils.UnitScale.MICRO);
            this.printWriter.println(tType + " " + this.makeNodeName(gate, format2) + " " + this.makeNodeName(source, format2) + " " + this.makeNodeName(drain, format2) + " " + TextUtils.formatDouble(length) + " " + TextUtils.formatDouble(width) + " r 0 0 " + TextUtils.formatDouble(length * width));
            this.printWriter.println("N " + this.makeNodeName(source, format2) + " 0 0 0 0 " + TextUtils.formatDouble(length * width) + " " + TextUtils.formatDouble(width));
            this.printWriter.println("N " + this.makeNodeName(drain, format2) + " 0 0 0 0 " + TextUtils.formatDouble(length * width) + " " + TextUtils.formatDouble(width));
        }
    }

    private String makeNodeName(int globalNetNum, FileType format2) {
        if (globalNetNum == this.globalNetVDD) {
            return "vdd";
        }
        if (globalNetNum == this.globalNetGND) {
            return "gnd";
        }
        if (globalNetNum == this.globalNetPhi1H) {
            if (format2 == FileType.RSIM) {
                return "phi1h";
            }
            return "clk1";
        }
        if (globalNetNum == this.globalNetPhi1L) {
            return "phi1l";
        }
        if (globalNetNum == this.globalNetPhi2H) {
            if (format2 == FileType.RSIM) {
                return "phi2h";
            }
            return "clk2";
        }
        if (globalNetNum == this.globalNetPhi2L) {
            return "phi2l";
        }
        String name = this.globalNetNames.get(new Integer(globalNetNum));
        if (name == null) {
            name = Integer.toString(globalNetNum);
        }
        return name;
    }

    private static class Visitor
    extends HierarchyEnumerator.Visitor {
        private Sim generator;
        private FileType type;

        public Visitor(Sim generator, FileType type) {
            this.generator = generator;
            this.type = type;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            this.generator.writeCellContents(info, this.type);
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            return true;
        }
    }

    public static class SimPreferences
    extends Output.OutputPreferences {
        private FileType type;

        SimPreferences(boolean factory, FileType type) {
            super(factory);
            this.type = type;
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            Sim out = new Sim(this);
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            out.init(cell, filePath, this.type);
            HierarchyEnumerator.enumerateCell(cell, context, (HierarchyEnumerator.Visitor)new Visitor(out, this.type), Netlist.ShortResistors.ALL);
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            return out.finishWrite();
        }
    }
}

