/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.UsageCollector;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.Variable;
import java.util.BitSet;
import java.util.Map;
import java.util.TreeMap;

class CellUsageInfo {
    final int instCount;
    final BitSet usedExports;
    final int usedExportsLength;
    final TreeMap<Variable.AttrKey, AbstractTextDescriptor.Unit> usedAttributes;

    CellUsageInfo(int instCount, BitSet usedExports, TreeMap<Variable.AttrKey, AbstractTextDescriptor.Unit> usedAttributes) {
        this.instCount = instCount;
        this.usedExportsLength = usedExports.length();
        this.usedExports = this.usedExportsLength > 0 ? usedExports : CellRevision.EMPTY_BITSET;
        this.usedAttributes = usedAttributes;
    }

    CellUsageInfo with(int instCount, BitSet usedExports, TreeMap<Variable.AttrKey, AbstractTextDescriptor.Unit> usedAttributes) {
        usedExports = UsageCollector.bitSetWith(this.usedExports, usedExports);
        usedAttributes = UsageCollector.usedAttributesWith(this.usedAttributes, usedAttributes);
        if (this.instCount == instCount && this.usedExports == usedExports && this.usedAttributes == usedAttributes) {
            return this;
        }
        return new CellUsageInfo(instCount, usedExports, usedAttributes);
    }

    void checkUsage(CellRevision subCellRevision) {
        if (subCellRevision == null) {
            throw new IllegalArgumentException("subCell deleted");
        }
        if (subCellRevision.definedExportsLength < this.usedExportsLength || subCellRevision.deletedExports.intersects(this.usedExports)) {
            throw new IllegalArgumentException("exportUsages");
        }
        if (this.isIcon()) {
            for (Map.Entry<Variable.AttrKey, AbstractTextDescriptor.Unit> e : this.usedAttributes.entrySet()) {
                Variable.AttrKey paramKey = e.getKey();
                Variable param2 = subCellRevision.d.getParameter(paramKey);
                AbstractTextDescriptor.Unit unit = e.getValue();
                if (!(unit != null ? param2 == null || param2.getUnit() != unit : param2 != null)) continue;
                throw new IllegalArgumentException("param " + paramKey);
            }
        }
    }

    private boolean isIcon() {
        return this.usedAttributes != null;
    }

    void check(CellUsage u) {
        assert (this.instCount > 0);
        assert (this.usedExportsLength == this.usedExports.length());
        if (this.usedExportsLength == 0) assert (this.usedExports == CellRevision.EMPTY_BITSET);
        assert (this.isIcon() == u.protoId.isIcon());
        assert (!u.parentId.isIcon());
    }

    public boolean equals(Object o) {
        if (o instanceof CellUsageInfo) {
            CellUsageInfo that = (CellUsageInfo)o;
            return this.instCount == that.instCount && this.usedExports == that.usedExports && this.usedExportsLength == that.usedExportsLength && (this.usedAttributes == null && that.usedAttributes == null || this.usedAttributes.equals(that.usedAttributes));
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.instCount;
        hash = 41 * hash + this.usedExportsLength;
        return hash;
    }
}

