/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import java.awt.Color;
import java.util.Collections;
import java.util.Iterator;

public class Generic
extends Technology {
    private final Layer universalLay;
    public final Layer glyphLay;
    public final Layer drcLay;
    public final Layer routeLay;
    public final Layer afgLay;
    public final Layer simProbeLay;
    public final PrimitiveNode universalPinNode;
    public final PrimitiveNode invisiblePinNode;
    public final PrimitiveNode unroutedPinNode;
    public final PrimitiveNode cellCenterNode;
    public final PrimitiveNode portNode;
    public final PrimitiveNode drcNode;
    public final PrimitiveNode routeNode;
    public final PrimitiveNode afgNode;
    public final PrimitiveNode essentialBoundsNode;
    public final PrimitiveNode simProbeNode;
    public final ArcProto universal_arc;
    public final ArcProto invisible_arc;
    public final ArcProto unrouted_arc;
    public static final Variable.Key ROUTING_EXCLUSION = Variable.newKey("GEN_routing_exclusion");

    public static Generic tech() {
        return TechPool.getThreadTechPool().getGeneric();
    }

    public static Generic newInstance(IdManager idManager) {
        Generic generic = new Generic(idManager);
        generic.setup();
        return generic;
    }

    private Generic(IdManager idManager) {
        super(idManager, null, TechFactory.getGenericFactory(), Collections.emptyMap(), Foundry.Type.NONE, 0);
        this.setTechShortName("Generic");
        this.setTechDesc("Useful primitives");
        this.setNonStandard();
        this.setFactoryScale(1000.0, false);
        this.universalLay = Layer.newInstance(this, "Universal", new EGraphics(false, false, null, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.universalLay.setFunction(Layer.Function.UNKNOWN);
        Layer invisible_lay = Layer.newInstance(this, "Invisible", new EGraphics(false, false, null, 0, 180, 180, 180, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        invisible_lay.setFunction(Layer.Function.UNKNOWN, 8192);
        Layer unrouted_lay = Layer.newInstance(this, "Unrouted", new EGraphics(false, false, null, 0, 100, 100, 100, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        unrouted_lay.setFunction(Layer.Function.UNKNOWN);
        this.glyphLay = Layer.newInstance(this, "Glyph", new EGraphics(false, false, null, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.glyphLay.setFunction(Layer.Function.ART, 8192);
        this.drcLay = Layer.newInstance(this, "DRC", new EGraphics(false, false, null, 0, 255, 190, 6, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.drcLay.setFunction(Layer.Function.ART, 8192);
        this.routeLay = Layer.newInstance(this, "Route", new EGraphics(true, true, null, 0, 255, 86, 6, 0.8, true, new int[]{34952, 8738, 34952, 8738, 34952, 8738, 34952, 8738, 34952, 8738, 34952, 8738, 34952, 8738, 34952, 8738}));
        this.routeLay.setFunction(Layer.Function.ART, 8192);
        this.afgLay = Layer.newInstance(this, "AFG", new EGraphics(false, false, null, 0, 255, 6, 190, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.afgLay.setFunction(Layer.Function.ART, 8192);
        this.simProbeLay = Layer.newInstance(this, "Sim-Probe", new EGraphics(false, false, null, 0, 0, 255, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.simProbeLay.setFunction(Layer.Function.ART, 8192);
        this.universal_arc = this.newArcProto("Universal", 0.0, 0.0, ArcProto.Function.UNKNOWN, new Technology.ArcLayer(this.universalLay, 0.0, Poly.Type.FILLED));
        this.universal_arc.setFactoryFixedAngle(true);
        this.universal_arc.setFactoryAngleIncrement(45);
        this.invisible_arc = this.newArcProto("Invisible", 0.0, 0.0, ArcProto.Function.NONELEC, new Technology.ArcLayer(invisible_lay, 0.0, Poly.Type.FILLED));
        this.invisible_arc.setFactoryFixedAngle(true);
        this.invisible_arc.setFactoryAngleIncrement(45);
        this.unrouted_arc = this.newArcProto("Unrouted", 0.0, 0.0, ArcProto.Function.UNROUTED, new Technology.ArcLayer(unrouted_lay, 0.0, Poly.Type.FILLED));
        this.unrouted_arc.setFactoryFixedAngle(false);
        this.unrouted_arc.setFactoryAngleIncrement(0);
        this.universalPinNode = PrimitiveNode.newInstance("Universal-Pin", this, 1.0, 1.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.universalLay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.c(0.0), EdgeV.c(0.0)), new Technology.TechPoint(EdgeH.r(0.5), EdgeV.c(0.0))})});
        PrimitivePort univPinPort = PrimitivePort.single(this.universalPinNode, new ArcProto[]{this.universal_arc}, "univ", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.l(-0.5), EdgeV.b(-0.5), EdgeH.r(0.5), EdgeV.t(0.5));
        this.universalPinNode.addPrimitivePorts(univPinPort);
        this.universalPinNode.setFunction(PrimitiveNode.Function.PIN);
        this.universalPinNode.setWipeOn1or2();
        this.universalPinNode.setCanBeZeroSize();
        this.invisiblePinNode = new InvisiblePin(invisible_lay);
        this.unroutedPinNode = PrimitiveNode.newInstance("Unrouted-Pin", this, 1.0, 1.0, new Technology.NodeLayer[]{new Technology.NodeLayer(unrouted_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.c(0.0), EdgeV.c(0.0)), new Technology.TechPoint(EdgeH.r(0.5), EdgeV.c(0.0))})});
        this.unroutedPinNode.addPrimitivePorts(PrimitivePort.single(this.unroutedPinNode, new ArcProto[]{this.unrouted_arc, this.invisible_arc, this.universal_arc}, "unrouted", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.c(0.0), EdgeV.c(0.0), EdgeH.c(0.0), EdgeV.c(0.0)));
        this.unroutedPinNode.setFunction(PrimitiveNode.Function.PIN);
        this.unroutedPinNode.setWipeOn1or2();
        this.unroutedPinNode.setCanBeZeroSize();
        this.cellCenterNode = PrimitiveNode.newInstance("Facet-Center", this, 0.0, 0.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.glyphLay, 0, Poly.Type.CLOSED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.l(0.0), EdgeV.b(0.0)), new Technology.TechPoint(EdgeH.r(0.0), EdgeV.t(0.0))}), new Technology.NodeLayer(this.glyphLay, 0, Poly.Type.BIGCROSS, 0, Technology.TechPoint.makeCenterBox())});
        this.cellCenterNode.addPrimitivePorts(PrimitivePort.single(this.cellCenterNode, new ArcProto[]{this.invisible_arc, this.universal_arc}, "center", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.l(0.0), EdgeV.b(0.0), EdgeH.r(0.0), EdgeV.t(0.0)));
        this.cellCenterNode.setFunction(PrimitiveNode.Function.ART);
        this.cellCenterNode.setCanBeZeroSize();
        this.portNode = PrimitiveNode.newInstance("Port", this, 6.0, 6.0, ERectangle.fromLambda(-1.0, -1.0, 2.0, 2.0), new Technology.NodeLayer[]{new Technology.NodeLayer(this.glyphLay, 0, Poly.Type.CLOSED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.l(-1.0), EdgeV.b(-1.0)), new Technology.TechPoint(EdgeH.r(1.0), EdgeV.t(1.0))})});
        this.portNode.addPrimitivePorts(PrimitivePort.single(this.portNode, new ArcProto[]{this.invisible_arc, this.universal_arc}, "center", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.c(0.0), EdgeV.c(0.0), EdgeH.c(0.0), EdgeV.c(0.0)));
        this.portNode.setFunction(PrimitiveNode.Function.ART);
        this.portNode.setCanBeZeroSize();
        this.essentialBoundsNode = PrimitiveNode.newInstance("Essential-Bounds", this, 0.0, 0.0, new Technology.NodeLayer[]{new Technology.NodeLayer(this.glyphLay, 0, Poly.Type.OPENED, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.c(-1.0), EdgeV.c(0.0)), new Technology.TechPoint(EdgeH.c(0.0), EdgeV.c(0.0)), new Technology.TechPoint(EdgeH.c(0.0), EdgeV.c(-1.0))})});
        this.essentialBoundsNode.addPrimitivePorts(PrimitivePort.single(this.essentialBoundsNode, new ArcProto[]{this.invisible_arc, this.universal_arc}, "center", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.l(0.0), EdgeV.b(0.0), EdgeH.r(0.0), EdgeV.t(0.0)));
        this.essentialBoundsNode.setFunction(PrimitiveNode.Function.ART);
        this.essentialBoundsNode.setCanBeZeroSize();
        this.drcNode = this.drcLay.makePureLayerNode("DRC-Node", 2.0, Poly.Type.FILLED, "center", this.invisible_arc, this.universal_arc);
        this.routeNode = this.routeLay.makePureLayerNode("Route-Node", 2.0, Poly.Type.FILLED, "center", this.invisible_arc, this.universal_arc);
        this.afgNode = this.afgLay.makePureLayerNode("AFG-Node", 2.0, Poly.Type.FILLED, "center", this.invisible_arc, this.universal_arc);
        this.simProbeNode = this.simProbeLay.makePureLayerNode("Simulation-Probe", 10.0, Poly.Type.FILLED, "center", this.invisible_arc, this.universal_arc);
        this.newFoundry(Foundry.Type.NONE, null, new String[0]);
        this.oldNodeNames.put("Cell-Center", this.cellCenterNode);
    }

    public void setBackgroudColor(Color c) {
        this.universalLay.setGraphics(this.universalLay.getGraphics().withColor(c));
        this.glyphLay.setGraphics(this.universalLay.getGraphics().withColor(c));
    }

    @Override
    public boolean isUniversalConnectivityPort(PrimitivePort pp) {
        PrimitiveNode pn = pp.getParent();
        return pn == this.universalPinNode || pn == this.invisiblePinNode || pn == this.simProbeNode;
    }

    public static boolean isSpecialGenericNode(NodeInst ni) {
        if (ni.isCellInstance()) {
            return false;
        }
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        if (!(np.getTechnology() instanceof Generic)) {
            return false;
        }
        Generic tech = (Generic)np.getTechnology();
        return np == tech.cellCenterNode || np == tech.drcNode || np == tech.routeNode || np == tech.essentialBoundsNode || np == tech.afgNode;
    }

    public static boolean isCellCenter(NodeInst ni) {
        return ni.getProto() == Generic.tech().cellCenterNode;
    }

    public static boolean isEssentialBnd(NodeInst ni) {
        return ni.getProto() == Generic.tech().essentialBoundsNode;
    }

    public static boolean isCellCenterOrEssentialBnd(NodeInst ni) {
        return Generic.isCellCenter(ni) || Generic.isEssentialBnd(ni);
    }

    private class InvisiblePin
    extends PrimitiveNode {
        InvisiblePin(Layer invisible_lay) {
            super("Invisible-Pin", Generic.this, EPoint.ORIGIN, 1.0, 1.0, ERectangle.ORIGIN, new Technology.NodeLayer[]{new Technology.NodeLayer(invisible_lay, 0, Poly.Type.CLOSED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.l(0.0), EdgeV.b(0.0)), new Technology.TechPoint(EdgeH.r(0.0), EdgeV.t(0.0))})});
            this.addPrimitivePorts(PrimitivePort.single(this, new ArcProto[]{Generic.this.invisible_arc, Generic.this.universal_arc}, "center", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.c(0.0), EdgeV.c(0.0), EdgeH.c(0.0), EdgeV.c(0.0)));
            this.setFunction(PrimitiveNode.Function.PIN);
            this.setWipeOn1or2();
            this.setCanBeZeroSize();
        }

        @Override
        public void genShape(AbstractShapeBuilder b, ImmutableNodeInst n) {
            assert (n.protoId == this.getId());
            if (b.isWipePins() && b.pinUseCount(n)) {
                return;
            }
            Technology.NodeLayer[] primLayers = this.getNodeLayers();
            boolean hasDisplayVars = false;
            Iterator<Variable> it = n.getVariables();
            while (it.hasNext()) {
                Variable var = it.next();
                if (!var.isDisplay()) continue;
                hasDisplayVars = true;
            }
            if (hasDisplayVars || n.isUsernamed() || b.hasExportsOnNode(n)) {
                return;
            }
            b.genShapeOfNode(n, this, primLayers, null);
        }
    }
}

