/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableIconInst;
import com.sun.electric.database.ImmutableLibrary;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.ImmutablePortInst;
import com.sun.electric.database.LibraryBackup;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.ELIBConstants;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.io.output.ReadableDump;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class ELIB
extends Output {
    Snapshot snapshot;
    IdManager idManager;
    TechPool techPool;
    LibId theLibId;
    HashMap<Object, Integer> objInfo;
    final ArrayList<Technology> technologies = new ArrayList();
    private int[] faceMap = new int[AbstractTextDescriptor.ActiveFont.getMaxIndex() + 1];
    private TreeMap<String, Short> nameSpace;
    private double irrelevantScale;
    private HashMap<CellId, CellId> cellInSameGroup = new HashMap();
    private boolean compatibleWith6;
    private TreeMap<String, Integer> cellIndexMap = new TreeMap(TextUtils.STRING_NUMBER_ORDER);
    private HashMap<Setting, Object> projectSettings = new HashMap();
    private HashMap<TechId, Technology.SizeCorrector> sizeCorrectors = new HashMap();
    private LinkedHashMap<CellId, Integer> cellOrdering = new LinkedHashMap();
    int[] nodeIndexByNodeId;
    ArrayList<CellRevision> localCells = new ArrayList();
    ArrayList<CellRevision> externalCells = new ArrayList();
    int nodeIndex = 0;
    int portProtoIndex = 0;
    int nodeProtoIndex = 0;
    int arcIndex = 0;
    int primNodeProtoIndex = 0;
    int primPortProtoIndex = 0;
    int arcProtoIndex = 0;
    int toolCount = 0;
    int[] primNodeCounts;
    int[] primArcCounts;
    int[] groupRenumber;

    ELIB() {
    }

    public void write6Compatible() {
        this.compatibleWith6 = true;
    }

    protected boolean writeLib(Snapshot snapshot, LibId theLibId) {
        String protoName;
        this.snapshot = snapshot;
        this.idManager = snapshot.idManager;
        this.techPool = snapshot.techPool;
        this.theLibId = theLibId;
        this.objInfo = new HashMap();
        this.nameSpace = new TreeMap(TextUtils.STRING_NUMBER_ORDER);
        for (CellBackup cellBackup : snapshot.cellBackups) {
            if (cellBackup == null) continue;
            CellRevision cellRevision = cellBackup.cellRevision;
            CellId cellId = cellRevision.d.cellId;
            if (cellId.libId != theLibId) continue;
            this.gatherCell(cellRevision.d.cellId);
            for (ImmutableNodeInst n : cellRevision.nodes) {
                NodeProtoId np = n.protoId;
                if (np instanceof CellId) {
                    this.gatherCell((CellId)np);
                } else {
                    this.gatherObj(np);
                    this.gatherTech(((PrimitiveNodeId)np).techId);
                }
                if (n.hasPortInstVariables()) {
                    Iterator<PortProtoId> it = n.getPortsWithVariables();
                    while (it.hasNext()) {
                        PortProtoId portId = it.next();
                        this.gatherVariables(portId.getName(snapshot), n.getPortInst(portId));
                    }
                }
                this.gatherVariables(null, n);
                this.gatherFont(n.nameDescriptor);
                this.gatherFont(n.protoDescriptor);
            }
            for (ImmutableArcInst a : cellRevision.arcs) {
                ArcProtoId apId = a.protoId;
                this.gatherObj(apId);
                this.gatherTech(apId.techId);
                this.gatherVariables(null, a);
                this.gatherFont(a.nameDescriptor);
            }
            for (ImmutableExport e : cellRevision.exports) {
                this.gatherVariables(null, e);
                this.gatherFont(e.nameDescriptor);
            }
            this.gatherVariables(null, cellRevision.d);
        }
        this.gatherVariables(null, snapshot.getLib((LibId)theLibId).d);
        Iterator<Comparable> it = Tool.getTools();
        while (it.hasNext()) {
            this.gatherSettings(it.next());
        }
        it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = (Technology)it.next();
            TechId techId = tech.getId();
            if (!this.objInfo.containsKey(techId)) continue;
            this.technologies.add(tech);
            this.gatherSettings(tech);
        }
        this.putNameSpace(Library.FONT_ASSOCIATIONS.getName());
        this.putNameSpace(NodeInst.NODE_NAME.getName());
        this.putNameSpace(ArcInst.ARC_NAME.getName());
        short varIndex = 0;
        for (Map.Entry<String, Short> e : this.nameSpace.entrySet()) {
            short s2 = varIndex;
            varIndex = (short)(varIndex + 1);
            e.setValue(new Short(s2));
        }
        for (Technology tech : this.technologies) {
            if (tech.isScaleRelevant() || tech == Generic.tech()) continue;
            this.irrelevantScale = Math.max(this.irrelevantScale, tech.getScale());
        }
        TreeMap<String, LibId> sortedLibIds = new TreeMap<String, LibId>(TextUtils.STRING_NUMBER_ORDER);
        HashMap<LibId, TreeMap<CellName, CellId>> sortedCellIds = new HashMap<LibId, TreeMap<CellName, CellId>>();
        for (CellBackup cellBackup : snapshot.cellBackups) {
            CellId cellId;
            if (cellBackup == null || !this.objInfo.containsKey(cellId = cellBackup.cellRevision.d.cellId)) continue;
            LibId libId = cellId.libId;
            sortedLibIds.put(libId.libName, libId);
            TreeMap<CellName, CellId> sortedCellIdsInLibrary = (TreeMap<CellName, CellId>)sortedCellIds.get(libId);
            if (sortedCellIdsInLibrary == null) {
                sortedCellIdsInLibrary = new TreeMap<CellName, CellId>();
                sortedCellIds.put(libId, sortedCellIdsInLibrary);
            }
            sortedCellIdsInLibrary.put(cellId.cellName, cellId);
        }
        for (CellId cellId : ((TreeMap)sortedCellIds.get(theLibId)).values()) {
            this.localCells.add(snapshot.getCellRevision(cellId));
        }
        int maxGroup = -1;
        ArrayList cellGroups_ = new ArrayList();
        for (CellRevision cellRevision : this.localCells) {
            maxGroup = Math.max(maxGroup, snapshot.getCellGroupIndex(cellRevision.d.cellId));
        }
        this.groupRenumber = new int[maxGroup + 1];
        for (CellRevision cellRevision : this.localCells) {
            CellId cellId = cellRevision.d.cellId;
            this.cellOrdering.put(cellId, new Integer(this.nodeProtoIndex));
            this.putObjIndex(cellId, this.nodeProtoIndex++);
            for (ImmutableExport e : cellRevision.exports) {
                this.putObjIndex(e.exportId, this.portProtoIndex++);
            }
            this.nodeIndex += cellRevision.nodes.size();
            this.arcIndex += cellRevision.arcs.size();
            int snapshotGroup = snapshot.getCellGroupIndex(cellId);
            int elibGroup = this.groupRenumber[snapshotGroup];
            if (elibGroup == 0) {
                cellGroups_.add(new TreeMap());
                this.groupRenumber[snapshotGroup] = elibGroup = cellGroups_.size();
            }
            ((TreeMap)cellGroups_.get(elibGroup - 1)).put(cellId.cellName, cellId);
            if (!this.compatibleWith6 || this.cellIndexMap.containsKey(protoName = cellId.cellName.getName())) continue;
            this.cellIndexMap.put(protoName, null);
        }
        for (int i = 0; i < cellGroups_.size(); ++i) {
            CellId firstCellInGroup;
            TreeMap cellGroup_ = (TreeMap)cellGroups_.get(i);
            Iterator git = cellGroup_.values().iterator();
            CellId lastCellInGroup = firstCellInGroup = (CellId)git.next();
            while (git.hasNext()) {
                CellId cellInGroup = (CellId)git.next();
                this.cellInSameGroup.put(lastCellInGroup, cellInGroup);
                lastCellInGroup = cellInGroup;
            }
            this.cellInSameGroup.put(lastCellInGroup, firstCellInGroup);
        }
        for (LibId libId : sortedLibIds.values()) {
            if (libId == theLibId) continue;
            for (CellId cellId : ((TreeMap)sortedCellIds.get(libId)).values()) {
                assert (this.objInfo.containsKey(cellId));
                CellRevision cellRevision = snapshot.getCellRevision(cellId);
                this.externalCells.add(cellRevision);
                this.putObjIndex(cellId, this.nodeProtoIndex++);
                for (ImmutableExport e : cellRevision.exports) {
                    this.putObjIndex(e.exportId, this.portProtoIndex++);
                }
                if (!this.compatibleWith6 || this.cellIndexMap.containsKey(protoName = cellId.cellName.getName())) continue;
                this.cellIndexMap.put(protoName, null);
            }
        }
        this.primNodeCounts = new int[this.technologies.size()];
        this.primArcCounts = new int[this.technologies.size()];
        for (int techCount = 0; techCount < this.technologies.size(); ++techCount) {
            Technology tech = this.technologies.get(techCount);
            TechId techId = tech.getId();
            this.putObjIndex(techId, techCount);
            int primNodeStart = this.primNodeProtoIndex;
            Iterator<PrimitiveNode> nit = tech.getNodes();
            while (nit.hasNext()) {
                PrimitiveNode np = nit.next();
                if (!this.objInfo.containsKey(np.getId())) continue;
                this.putObjIndex(np.getId(), -2 - this.primNodeProtoIndex++);
                Iterator<PortProto> pit = np.getPorts();
                while (pit.hasNext()) {
                    PrimitivePort pp = (PrimitivePort)pit.next();
                    this.putObjIndex(pp.getId(), -2 - this.primPortProtoIndex++);
                }
            }
            this.primNodeCounts[techCount] = this.primNodeProtoIndex - primNodeStart;
            int primArcStart = this.arcProtoIndex;
            Iterator<ArcProto> ait = tech.getArcs();
            while (ait.hasNext()) {
                ArcProtoId apId = ait.next().getId();
                if (!this.objInfo.containsKey(apId)) continue;
                this.putObjIndex(apId, -2 - this.arcProtoIndex++);
            }
            this.primArcCounts[techCount] = this.arcProtoIndex - primArcStart;
        }
        Iterator<Tool> it2 = Tool.getTools();
        while (it2.hasNext()) {
            Tool tool = it2.next();
            if (!this.objInfo.containsKey(tool)) continue;
            ++this.toolCount;
        }
        try {
            return this.writeTheLibrary();
        }
        catch (IOException e) {
            System.out.println("End of file reached while writing " + this.filePath);
            return true;
        }
    }

    boolean writeTheLibrary() throws IOException {
        CellRevision cellRevision;
        Tool tool;
        int magic = -1597;
        if (this.compatibleWith6) {
            magic = -1593;
        }
        this.writeBigInteger(magic);
        this.writeByte((byte)2);
        this.writeByte((byte)4);
        this.writeByte((byte)1);
        this.writeBigInteger(this.toolCount);
        this.writeBigInteger(this.technologies.size());
        this.writeBigInteger(this.primNodeProtoIndex);
        this.writeBigInteger(this.primPortProtoIndex);
        this.writeBigInteger(this.arcProtoIndex);
        this.writeBigInteger(this.nodeProtoIndex);
        this.writeBigInteger(this.nodeIndex);
        this.writeBigInteger(this.portProtoIndex);
        this.writeBigInteger(this.arcIndex);
        this.writeBigInteger(0);
        int cellCount = 0;
        if (this.compatibleWith6) {
            for (Map.Entry<String, Integer> e : this.cellIndexMap.entrySet()) {
                e.setValue(new Integer(cellCount++));
            }
            this.writeBigInteger(cellCount);
        }
        this.writeObj(null);
        this.writeString(Version.getVersion().toOldStyleString());
        this.putObjIndex(View.UNKNOWN, -1);
        this.putObjIndex(View.LAYOUT, -2);
        this.putObjIndex(View.SCHEMATIC, -3);
        this.putObjIndex(View.ICON, -4);
        this.putObjIndex(View.DOCWAVE, -5);
        this.putObjIndex(View.LAYOUTSKEL, -6);
        this.putObjIndex(View.VHDL, -7);
        this.putObjIndex(View.NETLIST, -8);
        this.putObjIndex(View.DOC, -9);
        this.putObjIndex(View.NETLISTNETLISP, -10);
        this.putObjIndex(View.NETLISTALS, -11);
        this.putObjIndex(View.NETLISTQUISC, -12);
        this.putObjIndex(View.NETLISTRSIM, -13);
        this.putObjIndex(View.NETLISTSILOS, -14);
        this.putObjIndex(View.VERILOG, -15);
        ArrayList<View> viewsToSave = new ArrayList<View>();
        Iterator<View> it = View.getViews();
        while (it.hasNext()) {
            View view = it.next();
            if (this.objInfo.get(view) != null || !this.objInfo.containsKey(view)) continue;
            viewsToSave.add(view);
            this.putObjIndex(view, viewsToSave.size());
        }
        this.writeBigInteger(viewsToSave.size());
        for (View view : viewsToSave) {
            this.writeString(view.getFullName());
            this.writeString(view.getAbbreviation());
        }
        for (CellId cellId : this.cellOrdering.keySet()) {
            CellRevision cellRevision2 = this.snapshot.getCellRevision(cellId);
            this.writeBigInteger(cellRevision2.arcs.size());
            this.writeBigInteger(cellRevision2.nodes.size());
            this.writeBigInteger(cellRevision2.exports.size());
        }
        for (CellRevision cellRevision3 : this.externalCells) {
            CellId cellId = cellRevision3.d.cellId;
            if (!this.objInfo.containsKey(cellId)) continue;
            this.writeBigInteger(-1);
            this.writeBigInteger(-1);
            this.writeBigInteger(cellRevision3.exports.size());
        }
        for (int techCount = 0; techCount < this.technologies.size(); ++techCount) {
            Technology tech = this.technologies.get(techCount);
            this.writeString(tech.getTechName());
            this.writeBigInteger(this.primNodeCounts[techCount]);
            Iterator<PrimitiveNode> nit = tech.getNodes();
            while (nit.hasNext()) {
                PrimitiveNode np = nit.next();
                if (!this.objInfo.containsKey(np.getId())) continue;
                this.writeString(np.getName());
                this.writeBigInteger(np.getNumPorts());
                Iterator<PortProto> pit = np.getPorts();
                while (pit.hasNext()) {
                    PrimitivePort pp = (PrimitivePort)pit.next();
                    this.writeString(pp.getName());
                }
            }
            this.writeBigInteger(this.primArcCounts[techCount]);
            Iterator<ArcProto> ait = tech.getArcs();
            while (ait.hasNext()) {
                ArcProtoId apId = ait.next().getId();
                if (!this.objInfo.containsKey(apId)) continue;
                this.writeString(apId.name);
            }
        }
        Iterator<Tool> it2 = Tool.getTools();
        while (it2.hasNext()) {
            tool = it2.next();
            if (!this.objInfo.containsKey(tool)) continue;
            this.writeString(tool.getName());
        }
        this.writeBigInteger(0);
        for (Technology tech : this.technologies) {
            this.writeBigInteger(this.gridCoordToElib(tech, 400.0));
        }
        this.writeNameSpace();
        this.writeVariables(this.snapshot.getLib((LibId)this.theLibId).d);
        it2 = Tool.getTools();
        while (it2.hasNext()) {
            tool = it2.next();
            if (!this.objInfo.containsKey(tool)) continue;
            this.writeMeaningPrefs(tool);
        }
        for (Technology tech : this.technologies) {
            this.writeMeaningPrefs(tech);
        }
        int numDummyVariables = this.arcProtoIndex + this.primNodeProtoIndex + this.primPortProtoIndex;
        for (int i = 0; i < numDummyVariables; ++i) {
            this.writeNoVariables();
        }
        this.writeBigInteger(0);
        if (this.compatibleWith6) {
            for (String cellName : this.cellIndexMap.keySet()) {
                this.writeString(cellName);
                this.writeNoVariables();
            }
        }
        this.nodeIndex = 0;
        for (CellId cellId : this.cellOrdering.keySet()) {
            cellRevision = this.snapshot.getCellRevision(cellId);
            this.startCell(cellRevision, this.nodeIndex);
            this.writeNodeProto(cellRevision);
            this.nodeIndex += cellRevision.nodes.size();
        }
        this.writeExternalCells();
        this.nodeIndex = 0;
        this.arcIndex = 0;
        for (CellId cellId : this.cellOrdering.keySet()) {
            cellRevision = this.snapshot.getCellRevision(cellId);
            this.startCell(cellRevision, this.nodeIndex);
            this.writeArcs(cellRevision);
            this.writeNodes(this.snapshot.getCell(cellId), this.arcIndex);
            this.nodeIndex += cellRevision.nodes.size();
            this.arcIndex += cellRevision.arcs.size();
        }
        return false;
    }

    private void gatherVariables(String portName, ImmutableElectricObject d) {
        Variable param2;
        Iterator<Variable> it;
        if (d instanceof ImmutableCell) {
            it = ((ImmutableCell)d).getParameters();
            while (it.hasNext()) {
                param2 = it.next();
                this.gatherVariable(portName, param2);
            }
        } else if (d instanceof ImmutableIconInst) {
            it = ((ImmutableIconInst)d).getDefinedParameters();
            while (it.hasNext()) {
                param2 = it.next();
                this.gatherVariable(portName, param2);
            }
        }
        it = d.getVariables();
        while (it.hasNext()) {
            Variable var = it.next();
            this.gatherVariable(portName, var);
        }
    }

    private void gatherVariable(String portName, Variable var) {
        Object value = var.getObject();
        if (this.nameSpace != null) {
            this.putNameSpace(this.diskName(portName, var));
        }
        this.gatherFont(var.getTextDescriptor());
        int length = value instanceof Object[] ? ((Object[])value).length : 1;
        for (int i = 0; i < length; ++i) {
            ExportId exportId;
            CellRevision cellRevision;
            Object v;
            Object object = v = value instanceof Object[] ? ((Object[])value)[i] : value;
            if (v == null) continue;
            if (v instanceof TechId || v instanceof Tool) {
                this.gatherObj(v);
                continue;
            }
            if (v instanceof PrimitiveNodeId) {
                this.gatherObj(v);
                this.gatherTech(((PrimitiveNodeId)v).techId);
                continue;
            }
            if (v instanceof PrimitivePort) {
                PrimitiveNode pn = ((PrimitivePort)v).getParent();
                this.gatherObj(pn.getId());
                this.gatherTech(pn.getTechnology().getId());
                continue;
            }
            if (v instanceof ArcProto) {
                this.gatherObj(v);
                this.gatherTech(((ArcProto)v).getId().techId);
                continue;
            }
            if (v instanceof CellId) {
                CellId cellId = (CellId)v;
                if (this.snapshot.getCell(cellId) == null) continue;
                this.gatherCell(cellId);
                continue;
            }
            if (!(v instanceof ExportId) || (cellRevision = this.snapshot.getCellRevision((exportId = (ExportId)v).getParentId())) == null || cellRevision.getExport(exportId) == null) continue;
            this.gatherObj(exportId);
            this.gatherCell(exportId.getParentId());
        }
    }

    private void gatherSettings(Object obj) {
        Setting.Group group = null;
        if (obj instanceof Tool) {
            group = ((Tool)obj).getProjectSettings();
        } else if (obj instanceof Technology) {
            group = ((Technology)obj).getProjectSettings();
        }
        for (Setting setting : group.getDiskSettings(this.snapshot.getSettings()).keySet()) {
            this.gatherObj(obj);
            String name = setting.getPrefName();
            if (this.nameSpace == null) continue;
            this.putNameSpace(name);
        }
    }

    private void gatherTech(TechId techId) {
        this.gatherObj(techId);
    }

    private void gatherCell(CellId cellId) {
        this.gatherObj(cellId);
        this.gatherObj(cellId.libId);
        this.gatherObj(cellId.cellName.getView());
    }

    private void gatherObj(Object obj) {
        this.objInfo.put(obj, null);
    }

    private void putObjIndex(Object obj, int index) {
        this.objInfo.put(obj, new Integer(index));
    }

    private void putNameSpace(String name) {
        this.nameSpace.put(name, null);
    }

    private void gatherFont(TextDescriptor td) {
        int face = td.getFace();
        this.faceMap[face] = -1;
    }

    String[] createFontAssociation() {
        TreeMap<String, AbstractTextDescriptor.ActiveFont> sortedFonts = new TreeMap<String, AbstractTextDescriptor.ActiveFont>();
        for (int face = 1; face < this.faceMap.length; ++face) {
            if (this.faceMap[face] == 0) continue;
            AbstractTextDescriptor.ActiveFont af = AbstractTextDescriptor.ActiveFont.findActiveFont(face);
            sortedFonts.put(af.getName(), af);
        }
        if (sortedFonts.size() == 0) {
            return null;
        }
        String[] fontAssociation = new String[sortedFonts.size()];
        int elibFace = 0;
        for (AbstractTextDescriptor.ActiveFont af : sortedFonts.values()) {
            this.faceMap[af.getIndex()] = ++elibFace;
            fontAssociation[elibFace - 1] = elibFace + "/" + af.getName();
        }
        return fontAssociation;
    }

    void startCell(CellRevision cellRevision, int baseNodeIndex) {
        int maxNodeId = -1;
        for (ImmutableNodeInst n : cellRevision.nodes) {
            maxNodeId = Math.max(maxNodeId, n.nodeId);
        }
        this.nodeIndexByNodeId = new int[maxNodeId + 1];
        for (int nodeIndex = 0; nodeIndex < cellRevision.nodes.size(); ++nodeIndex) {
            ImmutableNodeInst n;
            n = cellRevision.nodes.get(nodeIndex);
            this.nodeIndexByNodeId[n.nodeId] = nodeIndex + baseNodeIndex;
        }
    }

    void writeExternalCells() throws IOException {
        for (int i = 0; i < this.externalCells.size(); ++i) {
            CellRevision cellRevision = this.externalCells.get(i);
            CellId cellId = cellRevision.d.cellId;
            this.writeTxt("***cell: " + i);
            this.writeCellInfo(cellRevision);
            LibraryBackup libBackup = this.snapshot.getLib(cellId.libId);
            URL fileUrl = libBackup.d.libFile;
            String filePath = fileUrl != null ? fileUrl.getPath() : libBackup.d.libId.libName;
            this.writeTxt("externallibrary: \"" + filePath + "\"");
            if (this instanceof ReadableDump) continue;
            this.writeString(filePath);
            this.writeBigInteger(cellRevision.exports.size());
            for (ImmutableExport e : cellRevision.exports) {
                this.writeString(e.name.toString());
            }
        }
    }

    void writeCellInfo(CellRevision cellRevision) throws IOException {
        CellId cellId = cellRevision.d.cellId;
        if (this instanceof ReadableDump) {
            this.writeTxt("name: " + cellId.cellName.getName() + cellId.cellName.getView().getAbbreviationExtension());
        } else {
            if (this.compatibleWith6) {
                Integer cellIndex = this.cellIndexMap.get(cellId.cellName.getName());
                this.writeBigInteger(cellIndex);
            } else {
                this.writeString(cellId.cellName.getName());
                this.writeObj(this.cellInSameGroup.get(cellId));
                this.writeObj(null);
            }
            this.writeObj(cellId.cellName.getView());
        }
        this.writeInt("version: ", cellId.cellName.getVersion());
        this.writeInt("creationdate: ", (int)(cellRevision.d.creationDate / 1000L));
        this.writeInt("revisiondate: ", (int)(cellRevision.d.revisionDate / 1000L));
        ERectangle bounds = this.snapshot.getCellBounds(cellId);
        this.writeGridCoord(cellRevision, "lowx: ", (double)bounds.getGridMinX());
        this.writeGridCoord(cellRevision, "highx: ", (double)bounds.getGridMaxX());
        this.writeGridCoord(cellRevision, "lowy: ", (double)bounds.getGridMinY());
        this.writeGridCoord(cellRevision, "highy: ", (double)bounds.getGridMaxY());
    }

    private void writeNodeProto(CellRevision cellRevision) throws IOException {
        this.writeCellInfo(cellRevision);
        this.writeExports(cellRevision);
        this.writeBigInteger(0);
        this.writeBigInteger(cellRevision.d.flags & 0xF00002);
        this.writeVariables(cellRevision.d);
    }

    void writeNodes(CellBackup cellBackup, int arcBase) throws IOException {
        CellRevision cellRevision = cellBackup.cellRevision;
        for (int nodeIndex = 0; nodeIndex < cellRevision.nodes.size(); ++nodeIndex) {
            int rotation;
            double ySize;
            double xSize;
            double trueCenterY;
            double trueCenterX;
            ImmutableNodeInst n = cellRevision.nodes.get(nodeIndex);
            this.writeTxt("**node: " + nodeIndex);
            NodeProtoId protoId = n.protoId;
            this.writeObj(protoId);
            if (protoId instanceof CellId) {
                this.writeTxt("type: [" + this.objInfo.get(protoId) + "]");
                ERectangle bounds = this.snapshot.getCellBounds((CellId)protoId);
                Rectangle2D.Double dstBounds = new Rectangle2D.Double();
                n.orient.rectangleBounds(bounds.getGridMinX(), bounds.getGridMinY(), bounds.getGridMaxX(), bounds.getGridMaxY(), n.anchor.getGridX(), n.anchor.getGridY(), dstBounds);
                trueCenterX = dstBounds.getCenterX();
                trueCenterY = dstBounds.getCenterY();
                xSize = bounds.getGridWidth();
                ySize = bounds.getGridHeight();
            } else {
                PrimitiveNodeId pn = (PrimitiveNodeId)protoId;
                trueCenterX = n.anchor.getGridX();
                trueCenterY = n.anchor.getGridY();
                EPoint size2 = this.getSizeCorrector(pn.techId).getSizeToDisk(n);
                xSize = size2.getGridX();
                ySize = size2.getGridY();
                this.writeTxt("type: " + pn.fullName);
            }
            this.writeGridCoord(cellRevision, "lowx: ", trueCenterX - xSize * 0.5);
            this.writeGridCoord(cellRevision, "lowy: ", trueCenterY - ySize * 0.5);
            this.writeGridCoord(cellRevision, "highx: ", trueCenterX + xSize * 0.5);
            this.writeGridCoord(cellRevision, "highy: ", trueCenterY + ySize * 0.5);
            if (protoId instanceof CellId && !this.compatibleWith6) {
                this.writeGridCoord(cellRevision, null, (double)n.anchor.getGridX());
                this.writeGridCoord(cellRevision, null, (double)n.anchor.getGridY());
            }
            Orientation or = n.orient;
            int transpose2 = 0;
            if (this.compatibleWith6) {
                rotation = or.getCAngle();
                transpose2 = or.isCTranspose() ? 1 : 0;
            } else {
                rotation = or.getAngle();
                if (or.isXMirrored()) {
                    transpose2 |= 2;
                }
                if (or.isYMirrored()) {
                    transpose2 |= 4;
                }
            }
            this.writeOrientation(rotation, transpose2);
            TextDescriptor td = protoId instanceof CellId ? n.protoDescriptor : null;
            this.writeTextDescriptor(-1, td);
            if (this instanceof ReadableDump) {
                this.writeInt("userbits: ", n.getElibBits());
                this.writeVariables(n);
                this.writeConnectionsAndReExports(cellBackup, arcBase, n);
                continue;
            }
            this.writeConnectionsAndReExports(cellBackup, arcBase, n);
            this.writeBigInteger(n.getElibBits());
            this.writeVariables(n);
        }
    }

    private void writeConnectionsAndReExports(CellBackup cellBackup, int arcBase, ImmutableNodeInst n) throws IOException {
        CellRevision cellRevision = cellBackup.cellRevision;
        TreeSet<ElibConnection> sortedConnections = new TreeSet<ElibConnection>();
        BitSet headEnds = new BitSet();
        List<ImmutableArcInst> arcs = cellRevision.getConnectionsOnNode(headEnds, n);
        for (int i = 0; i < arcs.size(); ++i) {
            ImmutableArcInst a = arcs.get(i);
            boolean isHead = headEnds.get(i);
            PortProtoId portId = isHead ? a.headPortId : a.tailPortId;
            sortedConnections.add(new ElibConnection(portId, a.arcId, isHead, cellRevision.getArcIndexByArcId(a.arcId)));
        }
        assert (sortedConnections.size() == arcs.size());
        this.writeBigInteger(sortedConnections.size());
        for (ElibConnection c : sortedConnections) {
            this.writeConnection(c.portId, arcBase + c.arcIndex, c.isHead ? 1 : 0);
        }
        int numExports = cellRevision.getNumExportsOnNode(n);
        this.writeBigInteger(numExports);
        if (numExports > 0) {
            TreeMap<String, ImmutableExport> sortedExports = new TreeMap<String, ImmutableExport>();
            Iterator<ImmutableExport> it = cellRevision.getExportsOnNode(n);
            while (it.hasNext()) {
                ImmutableExport e = it.next();
                sortedExports.put(e.exportId.externalId, e);
            }
            for (ImmutableExport e : sortedExports.values()) {
                this.writeReExport(e);
            }
        }
    }

    void writeArcs(CellRevision cellRevision) throws IOException {
        for (int arcIndex = 0; arcIndex < cellRevision.arcs.size(); ++arcIndex) {
            ImmutableArcInst a = cellRevision.arcs.get(arcIndex);
            this.writeTxt("**arc: " + arcIndex);
            this.writeObj(a.protoId);
            this.writeTxt("type: " + a.protoId.fullName);
            int userBits = a.getElibBits();
            long arcWidth = this.getSizeCorrector(a.protoId.techId).getWidthToDisk(a);
            this.writeGridCoord(cellRevision, "width: ", (double)arcWidth);
            this.writeTxt("length: " + (int)Math.round(a.getGridLength() * this.getScale(cellRevision.d.techId) * 2.0 / 400.0));
            this.writeTxt("userbits: " + userBits);
            this.writeTxt("*end: 0");
            this.writeGridCoord(cellRevision, "xpos: ", (double)a.tailLocation.getGridX());
            this.writeGridCoord(cellRevision, "ypos: ", (double)a.tailLocation.getGridY());
            this.writeInt("node: ", this.nodeIndexByNodeId[a.tailNodeId]);
            this.writeTxt("nodeport: " + a.tailPortId.getName(this.snapshot));
            this.writeTxt("*end: 1");
            this.writeGridCoord(cellRevision, "xpos: ", (double)a.headLocation.getGridX());
            this.writeGridCoord(cellRevision, "ypos: ", (double)a.headLocation.getGridY());
            this.writeInt("node: ", this.nodeIndexByNodeId[a.headNodeId]);
            this.writeTxt("nodeport: " + a.headPortId.getName(this.snapshot));
            this.writeBigInteger(userBits);
            this.writeVariables(a);
        }
    }

    void writeExports(CellRevision cellRevision) throws IOException {
        this.writeBigInteger(cellRevision.exports.size());
        for (int exportIndex = 0; exportIndex < cellRevision.exports.size(); ++exportIndex) {
            ImmutableExport e = cellRevision.exports.get(exportIndex);
            this.writeTxt("**porttype: " + exportIndex);
            this.writeInt("subnode: ", this.nodeIndexByNodeId[e.originalNodeId]);
            this.writeObj(e.originalPortId);
            this.writeTxt("subport: " + e.originalPortId.getName(this.snapshot));
            if (!(this instanceof ReadableDump)) {
                this.writeString(e.name.toString());
            }
            this.writeTxt("name: " + e.name.toString());
            this.writeTextDescriptor(-1, e.nameDescriptor);
            this.writeInt("userbits: ", e.getElibBits());
            this.writeVariables(e);
        }
    }

    void writeOrientation(int angle, int transpose2) throws IOException {
        this.writeBigInteger(transpose2);
        this.writeBigInteger(angle);
    }

    void writeConnection(PortProtoId portId, int arcIndex, int connIndex) throws IOException {
        this.writeBigInteger(arcIndex << 1 | connIndex);
        this.writeObj(portId);
        this.writeNoVariables();
    }

    void writeReExport(ImmutableExport e) throws IOException {
        this.writeObj(e.exportId);
        this.writeObj(e.originalPortId);
        this.writeNoVariables();
    }

    private void writeNameSpace() throws IOException {
        if (this.nameSpace.size() > Short.MAX_VALUE) {
            Job.getUserInterface().showErrorMessage("ERROR! Too many unique variable names\nThe ELIB format cannot handle this many unique variables names\nEither delete the excess variables, or save to a readable dump", "Error saving ELIB file");
            throw new IOException("Variable.Key index too large");
        }
        this.writeBigInteger(this.nameSpace.size());
        for (String str : this.nameSpace.keySet()) {
            this.writeString(str);
        }
    }

    private void writeNoVariables() throws IOException {
        this.writeBigInteger(0);
    }

    void writeVariables(ImmutableElectricObject d) throws IOException {
        Variable var;
        Iterator<Variable> it;
        String[] fontAssociation;
        ImmutableNodeInst n;
        int count2 = d.getNumVariables();
        if (d instanceof ImmutableCell) {
            count2 += ((ImmutableCell)d).getNumParameters();
        } else if (d instanceof ImmutableIconInst) {
            count2 += ((ImmutableIconInst)d).getNumDefinedParameters();
        }
        Variable.Key additionalVarKey = null;
        int additionalVarType = 4;
        TextDescriptor additionalTextDescriptor = null;
        String[] additionalVarValue = null;
        if (d instanceof ImmutableNodeInst) {
            n = (ImmutableNodeInst)d;
            Iterator<PortProtoId> pit = n.getPortsWithVariables();
            while (pit.hasNext()) {
                PortProtoId portId = pit.next();
                count2 += n.getPortInst(portId).getNumVariables();
            }
            additionalVarKey = NodeInst.NODE_NAME;
            if (n.isUsernamed()) {
                additionalVarType |= 0x40;
                additionalTextDescriptor = n.nameDescriptor;
            }
            additionalVarValue = n.name.toString();
        } else if (d instanceof ImmutableArcInst) {
            ImmutableArcInst a = (ImmutableArcInst)d;
            additionalVarKey = ArcInst.ARC_NAME;
            if (a.isUsernamed()) {
                additionalVarType |= 0x40;
                additionalTextDescriptor = a.nameDescriptor;
            }
            additionalVarValue = a.name.toString();
        } else if (d instanceof ImmutableLibrary && (fontAssociation = this.createFontAssociation()) != null) {
            additionalVarKey = Library.FONT_ASSOCIATIONS;
            additionalVarType |= 0x80 | fontAssociation.length << 9;
            additionalVarValue = fontAssociation;
        }
        if (additionalVarKey != null) {
            ++count2;
        }
        this.writeInt("variables: ", count2);
        if (d instanceof ImmutableCell) {
            it = ((ImmutableCell)d).getParameters();
            while (it.hasNext()) {
                var = it.next();
                this.writeVariable(null, var);
            }
        } else if (d instanceof ImmutableIconInst) {
            it = ((ImmutableIconInst)d).getDefinedParameters();
            while (it.hasNext()) {
                var = it.next();
                this.writeVariable(null, var);
            }
        }
        it = d.getVariables();
        while (it.hasNext()) {
            var = it.next();
            this.writeVariable(null, var);
        }
        if (d instanceof ImmutableNodeInst && (n = (ImmutableNodeInst)d).hasPortInstVariables()) {
            TreeMap<String, ImmutablePortInst> portVars = new TreeMap<String, ImmutablePortInst>(TextUtils.STRING_NUMBER_ORDER);
            Iterator<PortProtoId> pit = n.getPortsWithVariables();
            while (pit.hasNext()) {
                PortProtoId portId = pit.next();
                portVars.put(portId.getName(this.snapshot), n.getPortInst(portId));
            }
            for (Map.Entry e : portVars.entrySet()) {
                String portName = e.getKey();
                ImmutablePortInst p = (ImmutablePortInst)e.getValue();
                Iterator<Variable> it2 = p.getVariables();
                while (it2.hasNext()) {
                    Variable var2 = it2.next();
                    this.writeVariable(portName, var2);
                }
            }
        }
        if (additionalVarKey != null) {
            this.writeVariableName(additionalVarKey.getName());
            this.writeTextDescriptor(additionalVarType, additionalTextDescriptor);
            this.writeVarValue(additionalVarValue);
        }
    }

    void writeVariable(String portName, Variable var) throws IOException {
        Float[] varObj = var.getObject();
        if (varObj instanceof EPoint[]) {
            EPoint[] points = (EPoint[])varObj;
            int len = points.length * 2;
            Float[] newPoints = new Float[len];
            for (int j = 0; j < points.length; ++j) {
                if (points[j] != null) {
                    newPoints[j * 2] = new Float(points[j].getLambdaX());
                    newPoints[j * 2 + 1] = new Float(points[j].getLambdaY());
                    continue;
                }
                Float f = Float.valueOf(Float.NaN);
                newPoints[j * 2 + 1] = f;
                newPoints[j * 2] = f;
            }
            varObj = newPoints;
        } else if (varObj instanceof EPoint) {
            EPoint p = (EPoint)varObj;
            varObj = new Float[]{new Float(p.getLambdaX()), new Float(p.getLambdaY())};
        }
        int type = ELIBConstants.getVarType(varObj);
        if (this.compatibleWith6 && type == 6) {
            type = 5;
        }
        assert (type != 0);
        if (var.isDisplay()) {
            type |= 0x40;
        }
        if (varObj instanceof Object[]) {
            Object[] objList = varObj;
            type |= 0x80 | objList.length << 9;
        }
        assert ((type & 0x1F) == 4 || (type & 0x20000020) == 0);
        this.writeVariableName(this.diskName(portName, var));
        this.writeTextDescriptor(type, var.getTextDescriptor());
        this.writeVarValue(varObj);
    }

    void writeMeaningPrefs(Object obj) throws IOException {
        Setting.Group group = null;
        if (obj instanceof Tool) {
            group = ((Tool)obj).getProjectSettings();
        } else if (obj instanceof Technology) {
            group = ((Technology)obj).getProjectSettings();
        }
        Map<Setting, Object> settings = group.getDiskSettings(this.snapshot.getSettings());
        this.writeInt("variables: ", settings.size());
        for (Map.Entry<Setting, Object> e : settings.entrySet()) {
            Setting setting = e.getKey();
            Object varObj = e.getValue();
            this.projectSettings.put(setting, varObj);
            if (varObj instanceof Boolean) {
                varObj = (Boolean)varObj != false ? 1 : 0;
            }
            int type = ELIBConstants.getVarType(varObj);
            if (this.compatibleWith6 && type == 6) {
                type = 5;
            }
            this.writeVariableName(setting.getPrefName());
            this.writeTextDescriptor(type, null);
            this.writeVarValue(varObj);
        }
    }

    void writeVarValue(Object varObj) throws IOException {
        if (varObj instanceof Object[]) {
            Object[] objList = (Object[])varObj;
            int len = objList.length;
            this.writeBigInteger(len);
            for (int i = 0; i < len; ++i) {
                Object oneObj = objList[i];
                this.putOutVar(oneObj);
            }
        } else {
            this.putOutVar(varObj);
        }
    }

    private void putOutVar(Object obj) throws IOException {
        if (obj instanceof String) {
            this.writeString((String)obj);
            return;
        }
        if (obj instanceof CodeExpression) {
            this.writeString(((CodeExpression)obj).getExpr());
            return;
        }
        if (obj instanceof Double) {
            if (this.compatibleWith6) {
                this.writeFloat(((Double)obj).floatValue());
            } else {
                this.writeDouble((Double)obj);
            }
            return;
        }
        if (obj instanceof Float) {
            this.writeFloat(((Float)obj).floatValue());
            return;
        }
        if (obj instanceof Long) {
            this.writeBigInteger(((Long)obj).intValue());
            return;
        }
        if (obj instanceof Integer) {
            this.writeBigInteger((Integer)obj);
            return;
        }
        if (obj instanceof Short) {
            this.writeSmallInteger((Short)obj);
            return;
        }
        if (obj instanceof Byte) {
            this.writeByte((Byte)obj);
            return;
        }
        if (obj instanceof Boolean) {
            this.writeByte((Boolean)obj != false ? (byte)1 : 0);
            return;
        }
        if (obj instanceof Tool) {
            Tool tool = (Tool)obj;
            this.writeBigInteger(tool.getIndex());
            return;
        }
        if (obj instanceof LibId) {
            LibId libId = (LibId)obj;
            this.writeString(libId.libName);
            return;
        }
        this.writeObj(obj);
    }

    private void writeTextDescriptor(int varBits, TextDescriptor td) throws IOException {
        int td1;
        int td0;
        if (td != null) {
            td0 = td.lowLevelGet0();
            td1 = td.lowLevelGet1();
            if ((td1 & 0x3F8000) != 0) {
                int face = (td1 & 0x3F8000) >> 15;
                td1 = td1 & 0xFFC07FFF | this.faceMap[face] << 15;
            }
        } else {
            td0 = 0;
            td1 = 0;
        }
        this.writeTextDescriptor(varBits, td0, td1);
    }

    void writeTextDescriptor(int varBits, int td0, int td1) throws IOException {
        if (varBits != -1) {
            this.writeBigInteger(varBits);
        }
        this.writeBigInteger(td0);
        this.writeBigInteger(td1);
    }

    void writeObj(Object obj) throws IOException {
        Integer i;
        int objIndex = -1;
        if (obj != null && (i = this.objInfo.get(obj)) != null) {
            objIndex = i;
        }
        this.writeBigInteger(objIndex);
    }

    private void writeGridCoord(CellBackup cellBackup, String keyword, double gridCoord) throws IOException {
        this.writeGridCoord(cellBackup.cellRevision, keyword, gridCoord);
    }

    private void writeGridCoord(CellRevision cellRevision, String keyword, double gridCoord) throws IOException {
        Technology tech = this.snapshot.getTech(cellRevision.d.techId);
        this.writeInt(keyword, this.gridCoordToElib(tech, gridCoord));
    }

    int gridCoordToElib(Technology tech, double gridCoord) {
        return (int)Math.round(gridCoord * this.getScale(tech) * 2.0 / 400.0);
    }

    double getScale(TechId techId) {
        return this.getScale(this.snapshot.getTech(techId));
    }

    double getScale(Technology tech) {
        return tech.isScaleRelevant() || tech == Generic.tech() ? tech.getScale() : this.irrelevantScale;
    }

    private Technology.SizeCorrector getSizeCorrector(TechId techId) {
        Technology.SizeCorrector corrector = this.sizeCorrectors.get(techId);
        if (corrector == null) {
            corrector = this.techPool.getTech(techId).getSizeCorrector(Version.getVersion(), this.projectSettings, false, false);
            this.sizeCorrectors.put(techId, corrector);
        }
        return corrector;
    }

    void writeInt(String keyword, int i) throws IOException {
        this.writeBigInteger(i);
    }

    void writeTxt(String txt) throws IOException {
    }

    void writeVariableName(String name) throws IOException {
        short varNameIndex = this.nameSpace.get(name);
        this.writeSmallInteger(varNameIndex);
    }

    private void writeByte(byte b) throws IOException {
        this.dataOutputStream.write(b);
    }

    void writeBigInteger(int i) throws IOException {
        this.dataOutputStream.writeInt(i);
    }

    private void writeFloat(float f) throws IOException {
        this.dataOutputStream.writeFloat(f);
    }

    private void writeDouble(double d) throws IOException {
        this.dataOutputStream.writeDouble(d);
    }

    private void writeSmallInteger(short s2) throws IOException {
        this.dataOutputStream.writeShort(s2);
    }

    private void writeString(String s2) throws IOException {
        int len = s2.length();
        this.writeBigInteger(len);
        this.dataOutputStream.write(s2.getBytes(), 0, len);
    }

    private static class ElibConnection
    implements Comparable<ElibConnection> {
        private final PortProtoId portId;
        private final int arcId;
        private final boolean isHead;
        private final int arcIndex;

        private ElibConnection(PortProtoId portId, int arcId, boolean isHead, int arcIndex) {
            this.portId = portId;
            this.arcId = arcId;
            this.isHead = isHead;
            this.arcIndex = arcIndex;
        }

        @Override
        public int compareTo(ElibConnection that) {
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(this.portId.externalId, that.portId.externalId);
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.arcId - that.arcId;
            if (cmp != 0) {
                return cmp;
            }
            if (this.isHead && !that.isHead) {
                return 1;
            }
            if (!this.isHead && that.isHead) {
                return -1;
            }
            return 0;
        }
    }
}

