/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.basic;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.Aborter;
import com.sun.electric.tool.ncc.NccEngine;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import com.sun.electric.tool.ncc.result.BenchmarkResults;
import com.sun.electric.tool.ncc.result.NccResult;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class NccUtils {
    private static long pow(int x, int y) {
        long prod = 1L;
        for (int i = 0; i < y; ++i) {
            prod *= (long)x;
        }
        return prod;
    }

    public static String fullName(Cell c) {
        return c.libDescribe();
    }

    private static Cell findLayout(Cell.CellGroup group) {
        if (group == null) {
            return null;
        }
        Iterator<Cell> it = group.getCells();
        while (it.hasNext()) {
            Cell c = it.next();
            if (c.getView() != View.LAYOUT) continue;
            return c.getNewestVersion();
        }
        return null;
    }

    public static Cell[] findSchematicAndLayout(Cell cell) {
        Cell.CellGroup group = cell.getCellGroup();
        Cell layout = null;
        Cell schematic = null;
        if (cell.isSchematic()) {
            schematic = cell;
            layout = NccUtils.findLayout(group);
        } else if (cell.getView() == View.LAYOUT) {
            schematic = cell.getMainSchematicInGroup();
            layout = cell;
        } else {
            schematic = cell.getMainSchematicInGroup();
            layout = NccUtils.findLayout(group);
        }
        if (schematic != null && layout != null) {
            return new Cell[]{schematic, layout};
        }
        return null;
    }

    public static CellContext getCurrentCellContext() {
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        return NccUtils.getCellContext(wnd);
    }

    public static CellContext getCellContext(EditWindow_ wnd) {
        if (wnd == null) {
            return null;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            System.out.println("window has no Cell");
            return null;
        }
        VarContext context = wnd.getVarContext();
        return new CellContext(cell, context);
    }

    public static List<CellContext> getCellContextsFromWindows() {
        ArrayList<CellContext> cellCtxts = new ArrayList<CellContext>();
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        CellContext curCellCtxt = NccUtils.getCellContext(wnd);
        if (curCellCtxt == null) {
            return cellCtxts;
        }
        cellCtxts.add(curCellCtxt);
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            EditWindow_ wnd2;
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow_) || (wnd2 = (EditWindow_)((Object)content)) == wnd) continue;
            CellContext cc = NccUtils.getCellContext((EditWindow_)((Object)content));
            cellCtxts.add(cc);
        }
        return cellCtxts;
    }

    public static String hourMinSec(Date start, Date stop) {
        long elapsedMsec = stop.getTime() - start.getTime();
        return NccUtils.hourMinSec(elapsedMsec);
    }

    public static String hourMinSec(long elapsedMsec) {
        int msecPerHour = 3600000;
        int msecPerMin = 60000;
        long hours = elapsedMsec / 3600000L;
        long mins = (elapsedMsec %= 3600000L) / 60000L;
        double secs = (double)(elapsedMsec %= 60000L) / 1000.0;
        String time = "";
        if (hours != 0L) {
            time = time + hours + " hours ";
        }
        if (mins != 0L) {
            time = time + mins + " minutes ";
        }
        time = time + secs + " seconds";
        return time;
    }

    public static NccResult buildBlackBoxes(CellContext c1, CellContext c2, HierarchyInfo hierInfo, NccOptions options, Aborter aborter) {
        System.out.println("Build black boxes for: " + NccUtils.fullName(c1.cell) + " and: " + NccUtils.fullName(c2.cell));
        System.out.flush();
        NccResult r = NccEngine.buildBlackBoxes(c1.cell, c1.context, c2.cell, c2.context, hierInfo, options, aborter);
        System.out.println(r.match() ? "Done" : "Failed");
        System.out.flush();
        return r;
    }

    public static boolean sizesMatch(double w1, double w2, NccOptions opt2) {
        double maxWidth = Math.max(w1, w2);
        double minWidth = Math.min(w1, w2);
        double absWidErr = maxWidth - minWidth;
        double relWidErr = absWidErr / minWidth;
        boolean absV = NccUtils.round(absWidErr, 2) <= opt2.absoluteSizeTolerance;
        boolean relV = relWidErr <= opt2.relativeSizeTolerance;
        return relV || absV;
    }

    public static void hang(String msg) {
        long YEAR = 1471228928L;
        try {
            System.out.println(msg + " now going to sleep for 1 year");
            System.out.flush();
            Thread.sleep(1471228928L);
        }
        catch (Exception e) {
            System.out.println("Huh? I woke up.");
        }
    }

    public static double round(double x, int places) {
        long m = NccUtils.pow(10, places);
        return Math.rint(x * (double)m) / (double)m;
    }

    public static long registerTiming(String msg, long start, BenchmarkResults.BenchIdx benchmark, NccGlobals globals) {
        long end = NccUtils.getTime();
        long time = end - start;
        if (msg != null) {
            globals.status1(msg + NccUtils.hourMinSec(time));
        }
        int n = benchmark.ordinal();
        globals.getBenchmarkResults().results[n] = globals.getBenchmarkResults().results[n] + time;
        return end;
    }

    public static long accumulateBenchmarkValue(String msg, long val, BenchmarkResults.BenchIdx benchmark, NccGlobals globals) {
        if (msg != null) {
            globals.status1(msg + val);
        }
        int n = benchmark.ordinal();
        long l = globals.getBenchmarkResults().results[n] + val;
        globals.getBenchmarkResults().results[n] = l;
        return l;
    }

    public static void incrementBenchmarkCount(BenchmarkResults.BenchIdx benchmark, NccGlobals globals) {
        int n = benchmark.ordinal();
        globals.getBenchmarkResults().results[n] = globals.getBenchmarkResults().results[n] + 1L;
    }

    public static long getTime() {
        return System.currentTimeMillis();
    }
}

