/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.result;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.result.NetObjReport;

public class PartReport
extends NetObjReport {
    static final long serialVersionUID = 0L;
    private final NccNameProxy.PartNameProxy nameProxy;
    private final String typeString;
    private boolean isMos;
    private boolean isResistor;
    private double width;
    private double length;

    private void checkLenWidValid() {
        Job.error(!this.isMos && !this.isResistor, "PartReport has no width or length");
    }

    public PartReport(PartReportable p) {
        super(p);
        this.nameProxy = p.getNameProxy();
        this.typeString = p.typeString();
        this.isMos = p.isMos();
        this.isResistor = p.isResistor();
        if (this.isMos || this.isResistor) {
            this.width = p.getWidth();
            this.length = p.getLength();
        }
    }

    public NccNameProxy.PartNameProxy getNameProxy() {
        return this.nameProxy;
    }

    public boolean isMos() {
        return this.isMos;
    }

    public boolean isResistor() {
        return this.isResistor;
    }

    public double getWidth() {
        this.checkLenWidValid();
        return this.width;
    }

    public double getLength() {
        this.checkLenWidValid();
        return this.length;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public static interface PartReportable
    extends NetObjReport.NetObjReportable {
        public NccNameProxy.PartNameProxy getNameProxy();

        public String typeString();

        public boolean isMos();

        public boolean isResistor();

        public double getWidth();

        public double getLength();
    }
}

