/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.utils.concurrent;

import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.EmptyException;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.IStructure;

public class CircularArray
extends IStructure<Runnable> {
    private int logCapacity;
    private Runnable[] currentItems;

    public CircularArray(int myLogCapacity) {
        this.logCapacity = myLogCapacity;
        this.currentItems = new Runnable[1 << this.logCapacity];
    }

    public void add(int i, Runnable item) {
        this.currentItems[i % this.getCapacity()] = item;
    }

    @Override
    @Deprecated
    public void add(Runnable item) {
        this.add(0, item);
    }

    @Override
    public Runnable get() throws EmptyException {
        return this.get(0);
    }

    public Runnable get(int i) throws EmptyException {
        return this.currentItems[i % this.getCapacity()];
    }

    public int getCapacity() {
        return 1 << this.logCapacity;
    }

    @Override
    @Deprecated
    public boolean isEmpty() {
        return false;
    }

    public CircularArray resize(int bottom, int top) {
        CircularArray newTasks = new CircularArray(this.logCapacity + 1);
        for (int i = top; i < bottom; ++i) {
            try {
                newTasks.add(i, this.get(i));
                continue;
            }
            catch (EmptyException e) {
                e.printStackTrace();
            }
        }
        return newTasks;
    }
}

