/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.utils.output;

import com.sun.electric.tool.io.output.PNG;
import com.sun.electric.tool.placement.PlacementFrame;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;

public class PNGOutput {
    List<PlacementFrame.PlacementNode> nodes;
    List<PlacementFrame.PlacementNetwork> nets;

    public PNGOutput(List<PlacementFrame.PlacementNode> nodes, List<PlacementFrame.PlacementNetwork> nets) {
        this.nodes = nodes;
        this.nets = nets;
    }

    public void draw(String fileName) {
        BufferedImage image = new BufferedImage(3000, 3000, 1);
        Graphics2D graphic = image.createGraphics();
        this.drawNodes(graphic, 0.7);
        PNG.writeImage(image, fileName);
    }

    private void drawNodes(Graphics2D graphic, double scale) {
        for (PlacementFrame.PlacementNode node : this.nodes) {
            double x = (node.getPlacementX() - node.getWidth() / 2.0) * scale + 300.0;
            double y = (node.getPlacementY() - node.getHeight() / 2.0) * scale + 300.0;
            graphic.drawRect((int)x, (int)y, (int)(node.getWidth() * scale), (int)(node.getHeight() * scale));
        }
    }
}

