/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Block;
import com.sun.electric.tool.placement.genetic2.Individual;
import com.sun.electric.tool.placement.genetic2.Reference;
import com.sun.electric.tool.placement.genetic2.metrics.DeltaBBMetric;
import com.sun.electric.util.math.Orientation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class DeltaIndividual
extends Individual<DeltaIndividual> {
    public List<Block> blocks = new ArrayList<Block>();
    private double[] hashes = new double[3];
    double[] overlaps;
    double[] netLengths;
    double spread;

    DeltaIndividual(Reference ref, Random rand) {
        super(ref);
        int i;
        this.netLengths = new double[ref.netLengths.length];
        for (i = 0; i < ref.netLengths.length; ++i) {
            this.netLengths[i] = ref.netLengths[i];
        }
        this.overlaps = new double[ref.overlaps.length];
        for (i = 0; i < ref.overlaps.length; ++i) {
            this.overlaps[i] = ref.overlaps[i];
        }
        this.mutate(rand);
        this.evaluate();
    }

    @Override
    public void reboot(Random rand) {
        this.blocks.clear();
        this.mutate(rand);
        this.evaluate();
    }

    public void prepareForTest() {
        int i = 0;
        while (i < 10) {
            int nodeNr = i++;
            PlacementFrame.PlacementNode n = (PlacementFrame.PlacementNode)this.nodesToPlace.get(nodeNr);
            this.blocks.add(new Block(n.getPlacementX(), n.getPlacementY(), n.getWidth(), n.getHeight(), n.getPlacementOrientation(), nodeNr));
        }
        Collections.sort(this.blocks);
    }

    @Override
    public void setProgress(double p) {
        this.p = p;
    }

    @Override
    public void writeToPlacement(List<PlacementFrame.PlacementNode> nodesToPlace) {
        for (Block b : this.blocks) {
            nodesToPlace.get(b.getNr()).setPlacement(b.getX(), b.getY());
            nodesToPlace.get(b.getNr()).setOrientation(b.getOrientation());
        }
    }

    @Override
    public int compareTo(DeltaIndividual other) {
        if (this.getBadness() < other.getBadness()) {
            return -1;
        }
        return 1;
    }

    @Override
    public void copyFrom(DeltaIndividual other) {
        int i;
        if (this == other) {
            return;
        }
        this.blocks.clear();
        for (Block b : other.blocks) {
            this.blocks.add(new Block(b));
        }
        this.netLengths = new double[this.ref.netLengths.length];
        for (i = 0; i < this.ref.netLengths.length; ++i) {
            this.netLengths[i] = this.ref.netLengths[i];
        }
        this.overlaps = new double[this.ref.overlaps.length];
        for (i = 0; i < this.ref.overlaps.length; ++i) {
            this.overlaps[i] = this.ref.overlaps[i];
        }
        this.setBadness(other.badnessComponents);
    }

    @Override
    public void deriveFrom(DeltaIndividual mom, DeltaIndividual dad, Random rand) {
        if (this == mom || this == dad) {
            return;
        }
        this.blocks.clear();
        for (Block b : mom.blocks) {
            this.blocks.add(new Block(b));
        }
        for (Block b : dad.blocks) {
            this.blocks.add(new Block(b));
        }
        Collections.sort(this.blocks);
        int pos = 0;
        int usedNr = -1;
        int prevNr = -1;
        while (pos < this.blocks.size()) {
            if (rand.nextDouble() > 0.5 && this.blocks.get(pos).getNr() != prevNr || this.blocks.get(pos).getNr() == usedNr) {
                prevNr = this.blocks.get(pos).getNr();
                this.blocks.remove(pos);
                continue;
            }
            prevNr = this.blocks.get(pos).getNr();
            usedNr = this.blocks.get(pos).getNr();
            ++pos;
        }
        this.mutate(rand);
        this.evaluate();
    }

    @Override
    public double distance(DeltaIndividual other) {
        double d = 0.0;
        for (int i = 0; i < this.netLengths.length; ++i) {
            d += Math.abs(this.netLengths[i] - other.netLengths[i]);
        }
        return d;
    }

    @Override
    public double distance() {
        double d = 0.0;
        for (int i = 0; i < this.netLengths.length; ++i) {
            d += Math.abs(this.netLengths[i] - this.ref.netLengths[i]);
        }
        return d;
    }

    public void swapBlocks(Random rand) {
        int a = rand.nextInt(this.nodesToPlace.size());
        int b = rand.nextInt(this.nodesToPlace.size());
        Block one = this.insertBlock(rand, a, false);
        Block two = this.insertBlock(rand, b, false);
        double ax = one.getX();
        double ay = one.getY();
        one.setPos(two.getX(), two.getY());
        two.setPos(ax, ay);
    }

    public Block insertBlock(Random rand, int nodeNr, boolean mutation) {
        PlacementFrame.PlacementNode n = (PlacementFrame.PlacementNode)this.nodesToPlace.get(nodeNr);
        double xmut = 0.0;
        double ymut = 0.0;
        if (mutation) {
            xmut = this.ref.avgW * rand.nextGaussian();
            ymut = this.ref.avgW * rand.nextGaussian();
        }
        Block b = new Block(n.getPlacementX() + xmut, n.getPlacementY() + ymut, n.getWidth(), n.getHeight(), n.getPlacementOrientation(), nodeNr);
        this.blocks.add(b);
        Collections.sort(this.blocks);
        for (int i = 1; i < this.blocks.size(); ++i) {
            if (this.blocks.get(i).getNr() != this.blocks.get(i - 1).getNr()) continue;
            if (rand.nextDouble() > 0.5) {
                b = this.blocks.get(i - 1);
                this.blocks.remove(i);
                continue;
            }
            b = this.blocks.get(i);
            this.blocks.remove(i - 1);
        }
        return b;
    }

    @Override
    public void mutate(Random rand) {
        int i;
        if (this.blocks.size() < 50 && (this.blocks.size() == 0 || rand.nextDouble() > 0.5)) {
            int nodeNr = rand.nextInt(this.nodesToPlace.size());
            this.insertBlock(rand, nodeNr, true);
        }
        if (rand.nextDouble() > 0.5 && this.blocks.size() > 1) {
            this.blocks.remove(rand.nextInt(this.blocks.size()));
        }
        int disturbedPositions = Math.abs((int)(rand.nextGaussian() * 3.0));
        int disturbedOrientations = Math.abs((int)(rand.nextGaussian() * 1.0));
        int swaps = Math.abs((int)(rand.nextGaussian() * 2.0 * (1.0 - this.p)));
        for (i = 0; i < disturbedPositions; ++i) {
            this.blocks.get(rand.nextInt(this.blocks.size())).disturb(this.ref.avgW, rand);
        }
        for (i = 0; i < disturbedOrientations; ++i) {
            this.blocks.get(rand.nextInt(this.blocks.size())).disturbOrientation(rand);
        }
        for (i = 0; i < swaps; ++i) {
            this.swapBlocks(rand);
        }
    }

    @Override
    public double calculateOverlap() {
        double overlap = this.ref.badnessComponents[1];
        for (int i = 0; i < this.nodesToPlace.size(); ++i) {
            this.overlaps[i] = this.ref.overlaps[i];
        }
        Block otherOrig = new Block();
        Block orig = new Block();
        for (int n = 0; n < this.blocks.size(); ++n) {
            Block b = this.blocks.get(n);
            overlap += this.ref.grid.collide(b, this.blocks, this.nodesToPlace, this.overlaps);
            orig.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(b.getNr()));
            for (int i = 0; i < n; ++i) {
                Block otherBlock = this.blocks.get(i);
                otherOrig.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(otherBlock.getNr()));
                overlap -= orig.intersectionArea(otherOrig);
                overlap += b.intersectionArea(otherBlock);
                int n2 = b.getNr();
                this.overlaps[n2] = this.overlaps[n2] - orig.intersectionArea(otherOrig);
                int n3 = b.getNr();
                this.overlaps[n3] = this.overlaps[n3] + b.intersectionArea(otherBlock);
            }
        }
        return overlap;
    }

    public double old_calculateOverlap() {
        double overlap = this.ref.badnessComponents[1];
        for (int i = 0; i < this.nodesToPlace.size(); ++i) {
            this.overlaps[i] = this.ref.overlaps[i];
        }
        Block other = new Block();
        Block orig = new Block();
        Iterator<Block> ib = this.blocks.iterator();
        Block deltaBlock = ib.next();
        for (int n = 0; n < this.blocks.size(); ++n) {
            Block b = this.blocks.get(n);
            orig.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(b.getNr()));
            ib = this.blocks.iterator();
            deltaBlock = ib.next();
            for (int i = 0; i < this.nodesToPlace.size(); ++i) {
                if (i > deltaBlock.getNr() && ib.hasNext()) {
                    deltaBlock = ib.next();
                }
                if (i == b.getNr()) continue;
                if (i < b.getNr() && deltaBlock.getNr() == i) {
                    other.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(i));
                    overlap -= orig.intersectionArea(other);
                    int n2 = b.getNr();
                    this.overlaps[n2] = this.overlaps[n2] - orig.intersectionArea(other);
                    int n3 = b.getNr();
                    this.overlaps[n3] = this.overlaps[n3] + b.intersectionArea(deltaBlock);
                    overlap += b.intersectionArea(deltaBlock);
                    continue;
                }
                if (deltaBlock.getNr() == i) continue;
                other.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(i));
                overlap -= orig.intersectionArea(other);
                int n4 = i;
                this.overlaps[n4] = this.overlaps[n4] - orig.intersectionArea(other);
                int n5 = i;
                this.overlaps[n5] = this.overlaps[n5] + b.intersectionArea(other);
                overlap += b.intersectionArea(other);
            }
        }
        return overlap;
    }

    @Override
    public double getBoundingBoxArea() {
        Iterator it = this.nodesToPlace.iterator();
        Iterator<Block> ib = this.blocks.iterator();
        Block deltaBlock = ib.next();
        Block b = new Block();
        PlacementFrame.PlacementNode n = (PlacementFrame.PlacementNode)it.next();
        b.setPos(n.getPlacementX(), n.getPlacementY());
        b.setOrientation(n.getPlacementOrientation());
        double left = b.getLeft();
        double top = b.getTop();
        double right = b.getRight();
        double bottom = b.getBottom();
        for (int i = 1; i < this.nodesToPlace.size(); ++i) {
            n = (PlacementFrame.PlacementNode)it.next();
            b.setPos(n.getPlacementX(), n.getPlacementY());
            b.setOrientation(n.getPlacementOrientation());
            if (i > deltaBlock.getNr() && ib.hasNext()) {
                deltaBlock = ib.next();
            }
            if (deltaBlock.getNr() == i) {
                if (deltaBlock.getLeft() < left) {
                    left = deltaBlock.getLeft();
                }
                if (deltaBlock.getTop() > top) {
                    top = deltaBlock.getTop();
                }
                if (deltaBlock.getRight() > right) {
                    right = deltaBlock.getRight();
                }
                if (!(deltaBlock.getBottom() < bottom)) continue;
                bottom = deltaBlock.getBottom();
                continue;
            }
            if (b.getLeft() < left) {
                left = b.getLeft();
            }
            if (b.getTop() > top) {
                top = b.getTop();
            }
            if (b.getRight() > right) {
                right = b.getRight();
            }
            if (!(b.getBottom() < bottom)) continue;
            bottom = b.getBottom();
        }
        return (top - bottom) * (right - left);
    }

    @Override
    public double getSemiperimeterLength() {
        Iterator it = this.nodesToPlace.iterator();
        Iterator<Block> ib = this.blocks.iterator();
        Block deltaBlock = ib.next();
        Block b = new Block();
        PlacementFrame.PlacementNode n = (PlacementFrame.PlacementNode)it.next();
        b.valuesFrom(n);
        double left = b.getLeft();
        double top = b.getTop();
        double right = b.getRight();
        double bottom = b.getBottom();
        if (deltaBlock.getNr() == 0) {
            if (deltaBlock.getLeft() < left) {
                left = deltaBlock.getLeft();
            }
            if (deltaBlock.getTop() > top) {
                top = deltaBlock.getTop();
            }
            if (deltaBlock.getRight() > right) {
                right = deltaBlock.getRight();
            }
            if (deltaBlock.getBottom() < bottom) {
                bottom = deltaBlock.getBottom();
            }
        } else {
            if (b.getLeft() < left) {
                left = b.getLeft();
            }
            if (b.getTop() > top) {
                top = b.getTop();
            }
            if (b.getRight() > right) {
                right = b.getRight();
            }
            if (b.getBottom() < bottom) {
                bottom = b.getBottom();
            }
        }
        for (int i = 1; i < this.nodesToPlace.size(); ++i) {
            n = (PlacementFrame.PlacementNode)it.next();
            b.valuesFrom(n);
            if (i > deltaBlock.getNr() && ib.hasNext()) {
                deltaBlock = ib.next();
            }
            if (deltaBlock.getNr() == i) {
                if (deltaBlock.getLeft() < left) {
                    left = deltaBlock.getLeft();
                }
                if (deltaBlock.getTop() > top) {
                    top = deltaBlock.getTop();
                }
                if (deltaBlock.getRight() > right) {
                    right = deltaBlock.getRight();
                }
                if (!(deltaBlock.getBottom() < bottom)) continue;
                bottom = deltaBlock.getBottom();
                continue;
            }
            if (b.getLeft() < left) {
                left = b.getLeft();
            }
            if (b.getTop() > top) {
                top = b.getTop();
            }
            if (b.getRight() > right) {
                right = b.getRight();
            }
            if (!(b.getBottom() < bottom)) continue;
            bottom = b.getBottom();
        }
        return top - bottom + (right - left);
    }

    @Override
    public double getNetLength() {
        return this.badnessComponents[0];
    }

    @Override
    public void evaluate() {
        int i;
        this.netLengths = new double[this.ref.netLengths.length];
        for (i = 0; i < this.ref.netLengths.length; ++i) {
            this.netLengths[i] = this.ref.netLengths[i];
        }
        this.overlaps = new double[this.ref.overlaps.length];
        for (i = 0; i < this.ref.overlaps.length; ++i) {
            this.overlaps[i] = this.ref.overlaps[i];
        }
        this.badnessComponents[0] = DeltaBBMetric.compute(this.blocks, this.netLengths);
        this.badnessComponents[1] = this.calculateOverlap();
        this.badnessComponents[2] = this.calculateSpread();
        this.hashes[0] = this.getXHash();
        this.hashes[1] = this.getYHash();
        this.hashes[2] = this.getRotHash();
    }

    @Override
    public double getSize() {
        return this.blocks.size();
    }

    @Override
    public double getBadness() {
        double badness = 0.0;
        badness += this.badnessComponents[0];
        badness += this.badnessComponents[1] * (1.0 + 300.0 * this.p * this.p);
        return badness += 1.0E-5 * this.badnessComponents[2];
    }

    public double calculateSpread() {
        this.spread = this.ref.spread;
        Block refBlock = new Block();
        for (Block b : this.blocks) {
            refBlock.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(b.getNr()));
            this.spread -= Math.sqrt(refBlock.getX() * refBlock.getX() + refBlock.getY() * refBlock.getY()) * refBlock.getWidth() * refBlock.getHeight();
            this.spread += Math.sqrt(b.getX() * b.getX() + b.getY() * b.getY()) * b.getWidth() * b.getHeight();
        }
        return this.spread;
    }

    @Override
    public void setBadness(double[] otherComponents) {
        for (int i = 0; i < this.badnessComponents.length; ++i) {
            this.badnessComponents[i] = otherComponents[i];
        }
    }

    @Override
    public double getXHash() {
        double r = 0.0;
        for (Block b : this.blocks) {
            r += b.getX() - ((PlacementFrame.PlacementNode)this.nodesToPlace.get(b.getNr())).getPlacementX();
        }
        r = Math.abs(r);
        return (Math.sin((r /= 5000.0) * Math.PI) + 1.0) / 2.0;
    }

    @Override
    public double getYHash() {
        double r = 0.0;
        for (Block b : this.blocks) {
            r += b.getY() - ((PlacementFrame.PlacementNode)this.nodesToPlace.get(b.getNr())).getPlacementY();
        }
        r = Math.abs(r);
        return (Math.sin((r /= 5000.0) * Math.PI) + 1.0) / 2.0;
    }

    @Override
    public double getRotHash() {
        double r = 0.0;
        for (Block b : this.blocks) {
            Orientation o = b.getOrientation();
            if (o == ((PlacementFrame.PlacementNode)this.nodesToPlace.get(b.getNr())).getPlacementOrientation()) {
                r += 0.0;
                continue;
            }
            if (o == Orientation.IDENT) {
                r += 0.1;
                continue;
            }
            if (o == Orientation.R) {
                r -= 0.2;
                continue;
            }
            if (o == Orientation.RR) {
                r += 0.3;
                continue;
            }
            if (o == Orientation.RRR) {
                r -= 0.4;
                continue;
            }
            if (o == Orientation.X) {
                r += 0.5;
                continue;
            }
            if (o == Orientation.XR) {
                r -= 0.6;
                continue;
            }
            if (o == Orientation.XRR) {
                r += 0.7;
                continue;
            }
            if (o == Orientation.XRRR) {
                r -= 0.8;
                continue;
            }
            if (o == Orientation.Y) {
                r += 0.9;
                continue;
            }
            if (o == Orientation.YR) {
                r -= 1.0;
                continue;
            }
            if (o == Orientation.YRR) {
                r += 1.1;
                continue;
            }
            if (o == Orientation.YRRR) {
                r -= 1.2;
                continue;
            }
            if (o == Orientation.XY) {
                r += 1.3;
                continue;
            }
            if (o == Orientation.XYR) {
                r -= 1.4;
                continue;
            }
            if (o == Orientation.XYRR) {
                r += 1.5;
                continue;
            }
            if (o != Orientation.XYRRR) continue;
            r -= 1.6;
        }
        return (Math.sin((r /= 50.0) * Math.PI) + 1.0) / 2.0;
    }

    @Override
    public double getHash() {
        double b;
        for (b = this.getBadness(); b > 2.0; b /= 10.0) {
        }
        b = (Math.sin(b * Math.PI) + 1.0) / 2.0;
        double h = this.hashes[0] + this.hashes[1] + this.hashes[2] + b;
        return h;
    }

    @Override
    public double[] getHashes() {
        return this.hashes;
    }
}

