/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Individual;
import java.util.List;
import java.util.Random;

public class Evolver
implements Runnable {
    List<PlacementFrame.PlacementNetwork> allNetworks;
    private Individual[] indis;
    private Random rand;
    private long evolutionStepTime;
    double p;
    long steps;

    Evolver(Individual[] indis, long evolutionStepTime, Random rand) {
        this.indis = indis;
        this.evolutionStepTime = evolutionStepTime;
        this.rand = rand;
    }

    public void setProgress(double p) {
        this.p = p;
    }

    private void evoLocal() {
        int i;
        int[] positions = new int[3];
        positions[0] = this.rand.nextInt(this.indis.length);
        while (!this.indis[positions[0]].rwLock.writeLock().tryLock()) {
            positions[0] = this.rand.nextInt(this.indis.length);
        }
        for (i = 1; i < positions.length; ++i) {
            positions[i] = (positions[0] + (int)(20.0 * this.rand.nextGaussian())) % this.indis.length;
            if (positions[i] < 0) {
                int n = i;
                positions[n] = positions[n] + this.indis.length;
            }
            while (!this.indis[positions[i]].rwLock.writeLock().tryLock()) {
                positions[i] = (positions[0] + (int)(20.0 * this.rand.nextGaussian())) % this.indis.length;
                if (positions[i] >= 0) continue;
                int n = i;
                positions[n] = positions[n] + this.indis.length;
            }
        }
        if (this.indis[positions[0]].getBadness() >= this.indis[positions[1]].getBadness() && this.indis[positions[0]].getBadness() >= this.indis[positions[2]].getBadness()) {
            this.indis[positions[0]].deriveFrom(this.indis[positions[1]], this.indis[positions[2]], this.rand);
        } else if (this.indis[positions[1]].getBadness() >= this.indis[positions[0]].getBadness() && this.indis[positions[1]].getBadness() >= this.indis[positions[2]].getBadness()) {
            this.indis[positions[1]].deriveFrom(this.indis[positions[0]], this.indis[positions[2]], this.rand);
        } else {
            this.indis[positions[2]].deriveFrom(this.indis[positions[0]], this.indis[positions[1]], this.rand);
        }
        for (i = 0; i < positions.length; ++i) {
            this.indis[positions[i]].rwLock.writeLock().unlock();
        }
    }

    public long getSteps() {
        return this.steps;
    }

    @Override
    public void run() {
        long t = System.currentTimeMillis();
        while (System.currentTimeMillis() - t < this.evolutionStepTime) {
            this.evoLocal();
            ++this.steps;
        }
    }
}

