/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar2.map;

import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarMapBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarMapVisitorBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarRegionNode;

public class RegionBoundingBox
extends AStarMapBase<AStarRegionNode> {
    private static final int GROWTH_RATE = 2;
    private AStarMapBase<AStarRegionNode> regionGrid;
    private int westernBound;
    private int easternBound;
    private int northernBound;
    private int southernBound;
    private int upperBound;
    private int lowerBound;

    public RegionBoundingBox(AStarMapBase<AStarRegionNode> regionGrid, int startX, int startY, int startZ, int goalX, int goalY, int goalZ) {
        this.westernBound = Math.min(startX, goalX);
        this.easternBound = Math.max(startX, goalX);
        this.northernBound = Math.min(startY, goalY);
        this.southernBound = Math.max(startY, goalY);
        this.upperBound = Math.min(startZ, goalZ) - 1;
        this.lowerBound = Math.max(startZ, goalZ) + 1;
        this.regionGrid = regionGrid;
    }

    @Deprecated
    public void setBounds(int westernBound, int easternBound, int northernBound, int southernBound, int upperBound, int lowerBound) {
        this.westernBound = westernBound;
        this.easternBound = easternBound;
        this.northernBound = northernBound;
        this.southernBound = southernBound;
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
    }

    public void enlarge() {
        this.westernBound -= 2;
        this.easternBound += 2;
        this.northernBound -= 2;
        this.southernBound += 2;
        this.upperBound -= 2;
        this.lowerBound += 2;
    }

    public boolean isBoundingBoxFree() {
        for (int x = this.westernBound; x <= this.easternBound; ++x) {
            for (int y = this.northernBound; y <= this.southernBound; ++y) {
                for (int z = this.upperBound; z <= this.lowerBound; ++z) {
                    if (this.isOutsideMap(x, y, z) || !this.regionGrid.isTileBlocked(x, y, z)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void occupyBoundingBox() {
        for (int x = this.westernBound; x <= this.easternBound; ++x) {
            for (int y = this.northernBound; y <= this.southernBound; ++y) {
                for (int z = this.upperBound; z <= this.lowerBound; ++z) {
                    if (this.isOutsideMap(x, y, z)) continue;
                    this.regionGrid.setTileBlocked(x, y, z, true);
                }
            }
        }
    }

    public void releaseBoundingBox() {
        for (int x = this.westernBound; x <= this.easternBound; ++x) {
            for (int y = this.northernBound; y <= this.southernBound; ++y) {
                for (int z = this.upperBound; z <= this.lowerBound; ++z) {
                    if (this.isOutsideMap(x, y, z)) continue;
                    this.regionGrid.setTileBlocked(x, y, z, false);
                }
            }
        }
    }

    @Override
    public void clearMapKeepBlocks() {
        throw new UnsupportedOperationException("The region boundinx box cannot be cleared, you must call this method in the region grid.");
    }

    @Override
    public AStarMapBase<AStarRegionNode> clone() {
        throw new UnsupportedOperationException("The region bounding box shouldn't be cloned to ensure mutual exclusive access.");
    }

    @Override
    public int getMaxXNodes() {
        return this.easternBound - this.westernBound;
    }

    @Override
    public int getMaxYNodes() {
        return this.southernBound - this.northernBound;
    }

    @Override
    public int getMaxZNodes() {
        return this.lowerBound - this.upperBound;
    }

    @Override
    public boolean isTileBlocked(int x, int y, int z) {
        return this.isOutsideBounds(x, y, z) || this.regionGrid.isTileBlocked(x, y, z);
    }

    private boolean isOutsideBounds(int x, int y, int z) {
        return x < this.westernBound || x > this.easternBound || y < this.northernBound || y > this.southernBound || z < this.upperBound || z > this.lowerBound;
    }

    private boolean isOutsideMap(int x, int y, int z) {
        boolean outsideX = false;
        boolean outsideY = false;
        boolean outsideZ = false;
        if (this.regionGrid.getMaxXNodes() != 0) {
            boolean bl = outsideX = x < 0 || x >= this.regionGrid.getMaxXNodes();
        }
        if (this.regionGrid.getMaxYNodes() != 0) {
            boolean bl = outsideY = y < 0 || y >= this.regionGrid.getMaxYNodes();
        }
        if (this.regionGrid.getMaxZNodes() != 0) {
            outsideZ = z < 0 || z >= this.regionGrid.getMaxZNodes();
        }
        return outsideX || outsideY || outsideZ;
    }

    @Override
    public AStarRegionNode nodeAt(int x, int y, int z) {
        if (this.isOutsideBounds(x, y, z)) {
            return null;
        }
        return this.regionGrid.nodeAt(x, y, z);
    }

    @Override
    public void setTileBlocked(int x, int y, int z, boolean blockedStatus) {
        this.regionGrid.setTileBlocked(x, y, z, blockedStatus);
    }

    @Override
    public void visitNeighboursOf(AStarRegionNode origin, AStarMapVisitorBase<AStarRegionNode> visitor) {
        int z;
        int y;
        int x = origin.getX();
        if (!this.isOutsideBounds(x, (y = origin.getY()) - 1, z = origin.getZ()) && !this.isOutsideMap(x, y - 1, z)) {
            visitor.visitNeighbour(origin, x, y - 1, z);
        }
        if (!this.isOutsideBounds(x + 1, y, z) && !this.isOutsideMap(x + 1, y, z)) {
            visitor.visitNeighbour(origin, x + 1, y, z);
        }
        if (!this.isOutsideBounds(x, y + 1, z) && !this.isOutsideMap(x, y + 1, z)) {
            visitor.visitNeighbour(origin, x, y + 1, z);
        }
        if (!this.isOutsideBounds(x - 1, y, z) && !this.isOutsideMap(x - 1, y, z)) {
            visitor.visitNeighbour(origin, x - 1, y, z);
        }
        if (!this.isOutsideBounds(x, y, z + 1) && !this.isOutsideMap(x, y, z + 1)) {
            visitor.visitNeighbour(origin, x, y, z + 1);
        }
        if (!this.isOutsideBounds(x, y, z - 1) && !this.isOutsideMap(x, y, z - 1)) {
            visitor.visitNeighbour(origin, x, y, z - 1);
        }
    }
}

